/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.jpa;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.jpa.HibernatePersistenceProvider;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final String name;
    private final Properties properties = new Properties();
    private PersistenceUnitTransactionType transactionType;
    private SharedCacheMode cacheMode;
    private ValidationMode validationMode;
    private List<String> mappingFiles;
    private List<String> managedClassNames;
    private boolean excludeUnlistedClasses;

    public PersistenceUnitInfoImpl(String name) {
        this.name = name;
    }

    public String getPersistenceUnitName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPersistenceProviderClassName() {
        return HibernatePersistenceProvider.class.getName();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(SharedCacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFiles == null ? Collections.emptyList() : this.mappingFiles;
    }

    public void applyMappingFiles(String ... mappingFiles) {
        if (this.mappingFiles == null) {
            this.mappingFiles = new ArrayList<String>();
        }
        Collections.addAll(this.mappingFiles, mappingFiles);
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames == null ? Collections.emptyList() : this.managedClassNames;
    }

    public void applyManagedClassNames(String ... managedClassNames) {
        if (this.managedClassNames == null) {
            this.managedClassNames = new ArrayList<String>();
        }
        Collections.addAll(this.managedClassNames, managedClassNames);
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public String getPersistenceXMLSchemaVersion() {
        return null;
    }

    public DataSource getJtaDataSource() {
        return null;
    }

    public DataSource getNonJtaDataSource() {
        return null;
    }

    public List<URL> getJarFileUrls() {
        return null;
    }

    public URL getPersistenceUnitRootUrl() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void addTransformer(ClassTransformer transformer) {
    }

    public ClassLoader getNewTempClassLoader() {
        return null;
    }
}

