/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessageFactory;
import org.apache.logging.log4j.message.StringFormattedMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.hibernate.testing.logger.LogListener;
import org.jboss.logging.Logger;

public final class Log4J2DelegatingLogger
extends org.jboss.logging.Logger {
    private final AbstractLogger logger;
    private final MessageFormatMessageFactory messageFactory;
    private final List<LogListener> enabledListeners = new LinkedList<LogListener>();
    private final AtomicBoolean interceptEnabled = new AtomicBoolean(false);

    Log4J2DelegatingLogger(String name) {
        super(name);
        Logger logger = LogManager.getLogger((String)name);
        if (!(logger instanceof AbstractLogger)) {
            throw new LoggingException("The logger for [" + name + "] does not extend AbstractLogger. Actual logger: " + logger.getClass().getName());
        }
        this.logger = (AbstractLogger)logger;
        this.messageFactory = new MessageFormatMessageFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerListener(LogListener newListener) {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            if (newListener != null) {
                this.enabledListeners.add(newListener);
                this.interceptEnabled.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAllListeners() {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            this.enabledListeners.clear();
            this.interceptEnabled.set(false);
        }
    }

    public boolean isEnabled(Logger.Level level) {
        return this.logger.isEnabled(Log4J2DelegatingLogger.translate(level));
    }

    protected void doLog(Logger.Level level, String loggerClassName, Object message, Object[] parameters, Throwable thrown) {
        Level translatedLevel = Log4J2DelegatingLogger.translate(level);
        if (this.interceptEnabled.get()) {
            this.intercept(level, parameters == null || parameters.length == 0 ? String.valueOf(message) : MessageFormat.format(String.valueOf(message), parameters), thrown);
        }
        if (!this.logger.isEnabled(translatedLevel)) {
            return;
        }
        try {
            this.logger.logMessage(loggerClassName, translatedLevel, null, parameters == null || parameters.length == 0 ? this.messageFactory.newMessage(message) : this.messageFactory.newMessage(String.valueOf(message), parameters), thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intercept(Logger.Level level, String renderedMessage, Throwable thrown) {
        List<LogListener> list = this.enabledListeners;
        synchronized (list) {
            for (LogListener listener : this.enabledListeners) {
                listener.loggedEvent(level, renderedMessage, thrown);
            }
        }
    }

    protected void doLogf(Logger.Level level, String loggerClassName, String format, Object[] parameters, Throwable thrown) {
        Level translatedLevel = Log4J2DelegatingLogger.translate(level);
        if (this.interceptEnabled.get()) {
            this.intercept(level, parameters == null ? format : String.format(format, parameters), thrown);
        }
        if (!this.logger.isEnabled(translatedLevel)) {
            return;
        }
        try {
            this.logger.logMessage(loggerClassName, translatedLevel, null, (Message)new StringFormattedMessage(format, parameters), thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Level translate(Logger.Level level) {
        if (level == null) {
            return Level.ALL;
        }
        switch (level) {
            case FATAL: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        return Level.ALL;
    }
}

