/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.junit.Assert;

public class SQLServerSnapshotIsolationConnectionProvider
extends ConnectionProviderDelegate {
    private static final String RCS = "ALTER DATABASE %s SET READ_COMMITTED_SNAPSHOT %s";
    private static final String SI = "ALTER DATABASE %s SET ALLOW_SNAPSHOT_ISOLATION %s";
    private String dbName = null;

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        try (Statement statement = connection.createStatement();){
            if (this.dbName == null) {
                try (ResultSet rs = statement.executeQuery("SELECT DB_NAME()");){
                    rs.next();
                    this.dbName = rs.getString(1);
                }
            }
            statement.executeUpdate(String.format(RCS, this.dbName, "ON"));
            statement.executeUpdate(String.format(SI, this.dbName, "ON"));
        }
        catch (SQLException se) {
            Assert.fail((String)se.getMessage());
        }
        return connection;
    }
}

