/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.ThreadContext;
import org.hibernate.testing.logger.Log4J2DelegatingLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;

public class TestableLoggerProvider
implements LoggerProvider {
    private static final ConcurrentMap<String, Logger> reuseLoggerInstances = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger previous;
        Logger logger = (Logger)reuseLoggerInstances.get(name);
        if (logger == null && (previous = reuseLoggerInstances.putIfAbsent(name, logger = new Log4J2DelegatingLogger("".equals(name) ? "ROOT" : name))) != null) {
            return previous;
        }
        return logger;
    }

    public void clearMdc() {
        ThreadContext.clearMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putMdc(String key, Object value) {
        try {
            String string = ThreadContext.get((String)key);
            return string;
        }
        finally {
            ThreadContext.put((String)key, (String)String.valueOf(value));
        }
    }

    public Object getMdc(String key) {
        return ThreadContext.get((String)key);
    }

    public void removeMdc(String key) {
        ThreadContext.remove((String)key);
    }

    public Map<String, Object> getMdcMap() {
        return new HashMap<String, Object>(ThreadContext.getImmutableContext());
    }

    public void clearNdc() {
        ThreadContext.clearStack();
    }

    public String getNdc() {
        return ThreadContext.peek();
    }

    public int getNdcDepth() {
        return ThreadContext.getDepth();
    }

    public String popNdc() {
        return ThreadContext.pop();
    }

    public String peekNdc() {
        return ThreadContext.peek();
    }

    public void pushNdc(String message) {
        ThreadContext.push((String)message);
    }

    public void setNdcMaxDepth(int maxDepth) {
        ThreadContext.trim((int)maxDepth);
    }
}

