/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.List;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.FacetingRequestImpl;
import org.hibernate.search.query.dsl.impl.RangeFacetImpl;
import org.hibernate.search.query.facet.Facet;

public class RangeFacetRequest<T>
extends FacetingRequestImpl {
    private final List<FacetRange<T>> facetRangeList;

    RangeFacetRequest(String name, String fieldName, List<FacetRange<T>> facetRanges) {
        super(name, fieldName);
        if (facetRanges == null || facetRanges.isEmpty()) {
            throw new IllegalArgumentException("At least one facet range must be specified");
        }
        this.facetRangeList = facetRanges;
    }

    public List<FacetRange<T>> getFacetRangeList() {
        return this.facetRangeList;
    }

    @Override
    public Class<?> getFacetValueType() {
        T o = this.facetRangeList.get(0).getMin();
        if (o == null) {
            o = this.facetRangeList.get(0).getMax();
        }
        return o.getClass();
    }

    @Override
    public Facet createFacet(FacetMetadata facetMetadata, String value, int count) {
        int facetIndex = this.findFacetRangeIndex(value);
        FacetRange<T> range = this.facetRangeList.get(facetIndex);
        return new RangeFacetImpl<T>(this.getFacetingName(), this.getFieldName(), facetMetadata.getSourceField().getAbsoluteName(), range, count, facetIndex);
    }

    @Override
    public String toString() {
        return "RangeFacetRequest{facetRangeList=" + this.facetRangeList + "} " + super.toString();
    }

    private int findFacetRangeIndex(String value) {
        int index = 0;
        for (FacetRange<T> facetRange : this.facetRangeList) {
            if (facetRange.getRangeString().equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

