/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.StreamingOperationExecutor;
import org.hibernate.search.backend.impl.StreamingOperationExecutorSelector;
import org.hibernate.search.backend.spi.OperationDispatcher;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;

public class StreamingOperationDispatcher
implements OperationDispatcher {
    private final boolean forceAsync;
    private final SearchIntegrator integrator;

    public StreamingOperationDispatcher(SearchIntegrator integrator, boolean forceAsync) {
        this.integrator = integrator;
        this.forceAsync = forceAsync;
    }

    @Override
    public void dispatch(LuceneWork work, IndexingMonitor monitor) {
        this.executeWork(work, monitor);
    }

    @Override
    public void dispatch(List<LuceneWork> queue, IndexingMonitor monitor) {
        for (LuceneWork work : queue) {
            this.executeWork(work, monitor);
        }
    }

    private void executeWork(LuceneWork work, IndexingMonitor progressMonitor) {
        IndexedTypeIdentifier entityType = work.getEntityType();
        EntityIndexBinding entityIndexBinding = this.integrator.getIndexBinding(entityType);
        IndexManagerSelector selector = entityIndexBinding.getIndexManagerSelector();
        StreamingOperationExecutor executor = work.acceptIndexWorkVisitor(StreamingOperationExecutorSelector.INSTANCE, null);
        executor.performStreamOperation(work, selector, progressMonitor, this.forceAsync);
    }
}

