/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.service.spi.Stoppable;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiServiceUtil
implements Stoppable {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(OsgiServiceUtil.class);
    private BundleContext context;
    private Map<String, ServiceTracker> serviceTrackers = new HashMap<String, ServiceTracker>();

    public OsgiServiceUtil(BundleContext context) {
        this.context = context;
    }

    public <T> T[] getServiceImpls(Class<T> contract) {
        Object[] services = (Object[])Array.newInstance(contract, 0);
        ServiceTracker serviceTracker = this.getServiceTracker(contract.getName());
        try {
            services = serviceTracker.getServices(services);
            if (services != null) {
                return services;
            }
        }
        catch (Exception e) {
            LOG.unableToDiscoverOsgiService(contract.getName(), e);
        }
        return services;
    }

    public <T> T getServiceImpl(Class<T> contract) {
        ServiceTracker serviceTracker = this.getServiceTracker(contract.getName());
        try {
            return (T)serviceTracker.waitForService(1000L);
        }
        catch (Exception e) {
            LOG.unableToDiscoverOsgiService(contract.getName(), e);
            return null;
        }
    }

    private <T> ServiceTracker getServiceTracker(String contractClassName) {
        if (!this.serviceTrackers.containsKey(contractClassName)) {
            ServiceTracker serviceTracker = new ServiceTracker(this.context, contractClassName, null);
            serviceTracker.open();
            this.serviceTrackers.put(contractClassName, serviceTracker);
        }
        return this.serviceTrackers.get(contractClassName);
    }

    public void stop() {
        for (Map.Entry<String, ServiceTracker> entry : this.serviceTrackers.entrySet()) {
            entry.getValue().close();
        }
        this.serviceTrackers.clear();
    }
}

