/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.hibernate.service.spi.Stoppable;
import org.osgi.framework.Bundle;

public class OsgiClassLoader
extends ClassLoader
implements Stoppable {
    private Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private Set<Bundle> bundles = new LinkedHashSet<Bundle>();
    private Map<String, Class<?>> classCache = new HashMap();
    private Map<String, URL> resourceCache = new HashMap<String, URL>();

    public OsgiClassLoader() {
        super(null);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz2;
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        for (Bundle bundle : this.bundles) {
            try {
                clazz2 = bundle.loadClass(name);
                if (clazz2 == null) continue;
                this.classCache.put(name, clazz2);
                return clazz2;
            }
            catch (Exception clazz2) {
            }
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                clazz2 = classLoader.loadClass(name);
                if (clazz2 == null) continue;
                this.classCache.put(name, clazz2);
                return clazz2;
            }
            catch (Exception exception) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    @Override
    protected URL findResource(String name) {
        URL resource2;
        if (this.resourceCache.containsKey(name)) {
            return this.resourceCache.get(name);
        }
        for (Bundle bundle : this.bundles) {
            try {
                resource2 = bundle.getResource(name);
                if (resource2 == null) continue;
                this.resourceCache.put(name, resource2);
                return resource2;
            }
            catch (Exception resource2) {
            }
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                resource2 = classLoader.getResource(name);
                if (resource2 == null) continue;
                this.resourceCache.put(name, resource2);
                return resource2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Enumeration<URL> resources2;
        final ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        for (Bundle bundle : this.bundles) {
            try {
                resources2 = bundle.getResources(name);
                if (resources2 == null) continue;
                enumerations.add(resources2);
            }
            catch (Exception resources2) {}
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                resources2 = classLoader.getResources(name);
                if (resources2 == null) continue;
                enumerations.add(resources2);
            }
            catch (Exception exception) {}
        }
        Enumeration<URL> aggEnumeration = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return (URL)enumeration.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
        return aggEnumeration;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    public void stop() {
        this.classLoaders.clear();
        this.bundles.clear();
        this.classCache.clear();
        this.resourceCache.clear();
    }
}

