/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.osgi.framework.Bundle;

public class OsgiClassLoader
extends ClassLoader {
    private Set<ClassLoader> classLoaders = new LinkedHashSet<ClassLoader>();
    private Set<Bundle> bundles = new LinkedHashSet<Bundle>();
    private Map<String, Class<?>> classCache = new HashMap();
    private Map<String, URL> resourceCache = new HashMap<String, URL>();

    public OsgiClassLoader() {
        super(null);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.classCache.containsKey(name)) {
            return this.classCache.get(name);
        }
        for (Bundle bundle : this.bundles) {
            try {
                clazz = bundle.loadClass(name);
                if (clazz == null) continue;
                this.classCache.put(name, clazz);
                return clazz;
            }
            catch (Exception ignore) {
            }
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                clazz = classLoader.loadClass(name);
                if (clazz == null) continue;
                this.classCache.put(name, clazz);
                return clazz;
            }
            catch (Exception ignore) {
            }
        }
        throw new ClassNotFoundException("Could not load requested class : " + name);
    }

    @Override
    protected URL findResource(String name) {
        URL resource;
        if (this.resourceCache.containsKey(name)) {
            return this.resourceCache.get(name);
        }
        for (Bundle bundle : this.bundles) {
            try {
                resource = bundle.getResource(name);
                if (resource == null) continue;
                this.resourceCache.put(name, resource);
                return resource;
            }
            catch (Exception ignore) {
            }
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                resource = classLoader.getResource(name);
                if (resource == null) continue;
                this.resourceCache.put(name, resource);
                return resource;
            }
            catch (Exception ignore) {
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Enumeration<URL> resources;
        final ArrayList<Enumeration<URL>> enumerations = new ArrayList<Enumeration<URL>>();
        for (Bundle bundle : this.bundles) {
            try {
                resources = bundle.getResources(name);
                if (resources == null) continue;
                enumerations.add(resources);
            }
            catch (Exception ignore) {}
        }
        for (ClassLoader classLoader : this.classLoaders) {
            try {
                resources = classLoader.getResources(name);
                if (resources == null) continue;
                enumerations.add(resources);
            }
            catch (Exception ignore) {}
        }
        Enumeration<URL> aggEnumeration = new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public URL nextElement() {
                for (Enumeration enumeration : enumerations) {
                    if (enumeration == null || !enumeration.hasMoreElements()) continue;
                    return (URL)enumeration.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
        return aggEnumeration;
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addBundle(Bundle bundle) {
        this.bundles.add(bundle);
    }

    public void clear() {
        this.classCache.clear();
        this.resourceCache.clear();
    }
}

