/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import java.util.Map;
import org.hibernate.envers.AuditTable;
import org.hibernate.envers.configuration.internal.metadata.reader.AuditedPropertiesHolder;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.tools.Tools;

public class ClassAuditingData
implements AuditedPropertiesHolder {
    private final Map<String, PropertyAuditingData> properties = Tools.newHashMap();
    private final Map<String, String> secondaryTableDictionary = Tools.newHashMap();
    private AuditTable auditTable;
    private boolean defaultAudited;

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public void addPropertyAuditingData(String propertyName, PropertyAuditingData auditingData) {
        this.properties.put(propertyName, auditingData);
    }

    @Override
    public PropertyAuditingData getPropertyAuditingData(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Iterable<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Map<String, String> getSecondaryTableDictionary() {
        return this.secondaryTableDictionary;
    }

    public AuditTable getAuditTable() {
        return this.auditTable;
    }

    public void setAuditTable(AuditTable auditTable) {
        this.auditTable = auditTable;
    }

    public void setDefaultAudited(boolean defaultAudited) {
        this.defaultAudited = defaultAudited;
    }

    public boolean isAudited() {
        return this.defaultAudited || this.properties.size() > 0;
    }

    @Override
    public boolean contains(String propertyName) {
        return this.properties.containsKey(propertyName);
    }
}

