/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.management.impl;

public abstract class CacheRegionUtils {
    public static String determineShortName(String fullName) {
        String result = fullName;
        if (fullName != null) {
            String[] comps = fullName.split("\\.");
            if (comps.length == 1) {
                return fullName;
            }
            boolean truncate = true;
            for (int i = 0; i < comps.length; ++i) {
                String comp = comps[i];
                char c = comp.charAt(0);
                if (truncate && Character.isUpperCase(c)) {
                    truncate = false;
                }
                if (!truncate) continue;
                comps[i] = Character.toString(c);
            }
            result = CacheRegionUtils.join(comps, '.');
        }
        return result;
    }

    private static String join(String[] elements, char c) {
        if (elements == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : elements) {
            sb.append(s).append(c);
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }
}

