/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.ScanFilter;
import org.hbase.async.generated.ComparatorPB;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.util.CharsetUtil;

public final class KeyRegexpFilter
extends ScanFilter {
    private static final byte[] ROWFILTER = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RowFilter");
    private static final byte[] REGEXSTRINGCOMPARATOR = Bytes.ISO88591("org.apache.hadoop.hbase.filter.RegexStringComparator");
    private static final byte[] EQUAL = new byte[]{69, 81, 85, 65, 76};
    private final byte[] regexp;
    private final byte[] charset;

    public KeyRegexpFilter(String regexp) {
        this(regexp, CharsetUtil.ISO_8859_1);
    }

    public KeyRegexpFilter(String regexp, Charset charset) {
        this(Bytes.UTF8(regexp), charset);
    }

    public KeyRegexpFilter(byte[] regexp) {
        this(regexp, CharsetUtil.ISO_8859_1);
    }

    public KeyRegexpFilter(byte[] regexp, Charset charset) {
        this.regexp = regexp;
        this.charset = Bytes.UTF8(charset.name());
    }

    public byte[] getRegexp() {
        return Arrays.copyOf(this.regexp, this.regexp.length);
    }

    public Charset getCharset() {
        return Charset.forName(new String(this.charset));
    }

    @Override
    byte[] serialize() {
        ComparatorPB.Comparator.Builder comparator = ComparatorPB.Comparator.newBuilder();
        comparator.setNameBytes(Bytes.wrap(REGEXSTRINGCOMPARATOR));
        byte[] regex_cmp = ComparatorPB.RegexStringComparator.newBuilder().setPatternBytes(Bytes.wrap(this.regexp)).setPatternFlags(0).setCharsetBytes(Bytes.wrap(this.charset)).build().toByteArray();
        comparator.setSerializedComparator(Bytes.wrap(regex_cmp));
        FilterPB.CompareFilter cmp = FilterPB.CompareFilter.newBuilder().setCompareOp(HBasePB.CompareType.EQUAL).setComparator(comparator.build()).build();
        return FilterPB.RowFilter.newBuilder().setCompareFilter(cmp).build().toByteArray();
    }

    @Override
    byte[] name() {
        return ROWFILTER;
    }

    @Override
    void serializeOld(ChannelBuffer buf) {
        buf.writeByte((int)((byte)ROWFILTER.length));
        buf.writeBytes(ROWFILTER);
        buf.writeShort(5);
        buf.writeBytes(EQUAL);
        buf.writeByte(54);
        buf.writeByte(0);
        buf.writeByte((int)((byte)REGEXSTRINGCOMPARATOR.length));
        buf.writeBytes(REGEXSTRINGCOMPARATOR);
        buf.writeShort(this.regexp.length);
        buf.writeBytes(this.regexp);
        buf.writeShort(this.charset.length);
        buf.writeBytes(this.charset);
    }

    @Override
    int predictSerializedSize() {
        return 105 + this.regexp.length + 2 + this.charset.length;
    }

    public String toString() {
        return "KeyRegexpFilter(\"" + new String(this.regexp, CharsetUtil.UTF_8) + "\", " + new String(this.charset, CharsetUtil.UTF_8) + ')';
    }
}

