/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ta" locale.
 */
public class LocalizedNamesImpl_ta extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
        "LK",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "FK",
        "FO",
        "FJ",
        "AI",
        "AO",
        "AZ",
        "AQ",
        "AD",
        "AS",
        "US",
        "IE",
        "AW",
        "AR",
        "AM",
        "DZ",
        "AL",
        "AC",
        "AF",
        "AG",
        "AX",
        "AT",
        "AU",
        "IT",
        "IN",
        "ID",
        "LK",
        "IL",
        "EC",
        "GQ",
        "IQ",
        "IR",
        "UG",
        "UA",
        "UY",
        "UZ",
        "EG",
        "ET",
        "ER",
        "SV",
        "EE",
        "YE",
        "AE",
        "UN",
        "EU",
        "IM",
        "IS",
        "OM",
        "QA",
        "CA",
        "KH",
        "GY",
        "BQ",
        "GT",
        "KZ",
        "CD",
        "CG",
        "GH",
        "GM",
        "GN",
        "GW",
        "CU",
        "GD",
        "KI",
        "GL",
        "GR",
        "KG",
        "CX",
        "CP",
        "CK",
        "CW",
        "HR",
        "GU",
        "KW",
        "KE",
        "KY",
        "GG",
        "IC",
        "GA",
        "CV",
        "CM",
        "XK",
        "CO",
        "CC",
        "CI",
        "KM",
        "CR",
        "GP",
        "WS",
        "SA",
        "TD",
        "SM",
        "SB",
        "ST",
        "SG",
        "SX",
        "SL",
        "EA",
        "SY",
        "CL",
        "CN",
        "SC",
        "SR",
        "SD",
        "CZ",
        "SN",
        "KN",
        "BL",
        "PM",
        "MF",
        "LC",
        "VC",
        "SH",
        "RS",
        "CY",
        "SO",
        "JP",
        "JM",
        "ZM",
        "GE",
        "DJ",
        "GI",
        "ZW",
        "JE",
        "DE",
        "JO",
        "TC",
        "DG",
        "TT",
        "TA",
        "TN",
        "DK",
        "DO",
        "DM",
        "TK",
        "TG",
        "TO",
        "TJ",
        "TZ",
        "TH",
        "TR",
        "TM",
        "TV",
        "ZA",
        "KR",
        "SS",
        "GS",
        "TL",
        "TW",
        "NA",
        "NF",
        "NO",
        "NI",
        "NU",
        "NC",
        "NZ",
        "NL",
        "NP",
        "NE",
        "NG",
        "NR",
        "BD",
        "PA",
        "PG",
        "PY",
        "BG",
        "BS",
        "BH",
        "PK",
        "BB",
        "PS",
        "PW",
        "PN",
        "FI",
        "PR",
        "FR",
        "IO",
        "VG",
        "GF",
        "TF",
        "PF",
        "BR",
        "PH",
        "BI",
        "BN",
        "BF",
        "BT",
        "BJ",
        "PE",
        "BM",
        "BY",
        "BZ",
        "BE",
        "BO",
        "BV",
        "BW",
        "PT",
        "PL",
        "BA",
        "MO",
        "MN",
        "MG",
        "CF",
        "YT",
        "MW",
        "MY",
        "MK",
        "MS",
        "ME",
        "MQ",
        "MH",
        "MV",
        "ML",
        "MT",
        "MD",
        "MM",
        "MX",
        "EH",
        "FM",
        "MZ",
        "MC",
        "MA",
        "MU",
        "MR",
        "GB",
        "VI",
        "UM",
        "EZ",
        "RU",
        "RE",
        "RO",
        "RW",
        "LU",
        "LV",
        "LA",
        "LI",
        "LT",
        "LY",
        "LS",
        "LB",
        "LR",
        "KP",
        "MP",
        "VU",
        "VA",
        "WF",
        "VN",
        "VE",
        "QO",
        "ES",
        "SK",
        "SI",
        "SJ",
        "SZ",
        "CH",
        "SE",
        "HU",
        "HK",
        "HM",
        "HT",
        "HN",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "உலகம்");
    namesMap.put("002", "ஆப்ரிக்கா");
    namesMap.put("003", "வட அமெரிக்கா");
    namesMap.put("005", "தென் அமெரிக்கா");
    namesMap.put("009", "ஓஷியானியா");
    namesMap.put("011", "மேற்கு ஆப்ரிக்கா");
    namesMap.put("013", "மத்திய அமெரிக்கா");
    namesMap.put("014", "கிழக்கு ஆப்ரிக்கா");
    namesMap.put("015", "வடக்கு ஆப்ரிக்கா");
    namesMap.put("017", "மத்திய ஆப்ரிக்கா");
    namesMap.put("018", "தெற்கு ஆப்ரிக்கா");
    namesMap.put("019", "அமெரிக்காஸ்");
    namesMap.put("021", "வடக்கு அமெரிக்கா");
    namesMap.put("029", "கரீபியன்");
    namesMap.put("030", "கிழக்காசியா");
    namesMap.put("034", "தெற்காசியா");
    namesMap.put("035", "தென்கிழக்காசியா");
    namesMap.put("039", "தெற்கு ஐரோப்பா");
    namesMap.put("053", "ஆஸ்திரலேசியா");
    namesMap.put("054", "மெலனேஷியா");
    namesMap.put("057", "மைக்ரோ நேஷியா பிரதேசம்");
    namesMap.put("061", "பாலினேஷியா");
    namesMap.put("142", "ஆசியா");
    namesMap.put("143", "மத்திய ஆசியா");
    namesMap.put("145", "மேற்காசியா");
    namesMap.put("150", "ஐரோப்பா");
    namesMap.put("151", "கிழக்கு ஐரோப்பா");
    namesMap.put("154", "வடக்கு ஐரோப்பா");
    namesMap.put("155", "மேற்கு ஐரோப்பா");
    namesMap.put("202", "துணை சஹாரா ஆப்பிரிக்கா");
    namesMap.put("419", "லத்தீன் அமெரிக்கா");
    namesMap.put("AC", "அஷன்ஷியன் தீவு");
    namesMap.put("AD", "அன்டோரா");
    namesMap.put("AE", "ஐக்கிய அரபு எமிரேட்ஸ்");
    namesMap.put("AF", "ஆஃப்கானிஸ்தான்");
    namesMap.put("AG", "ஆண்டிகுவா மற்றும் பார்புடா");
    namesMap.put("AI", "அங்கியுலா");
    namesMap.put("AL", "அல்பேனியா");
    namesMap.put("AM", "அர்மேனியா");
    namesMap.put("AO", "அங்கோலா");
    namesMap.put("AQ", "அண்டார்டிகா");
    namesMap.put("AR", "அர்ஜென்டினா");
    namesMap.put("AS", "அமெரிக்க சமோவா");
    namesMap.put("AT", "ஆஸ்திரியா");
    namesMap.put("AU", "ஆஸ்திரேலியா");
    namesMap.put("AW", "அரூபா");
    namesMap.put("AX", "ஆலந்து தீவுகள்");
    namesMap.put("AZ", "அசர்பைஜான்");
    namesMap.put("BA", "போஸ்னியா & ஹெர்ஸகோவினா");
    namesMap.put("BB", "பார்படோஸ்");
    namesMap.put("BD", "பங்களாதேஷ்");
    namesMap.put("BE", "பெல்ஜியம்");
    namesMap.put("BF", "புர்கினா ஃபாஸோ");
    namesMap.put("BG", "பல்கேரியா");
    namesMap.put("BH", "பஹ்ரைன்");
    namesMap.put("BI", "புருண்டி");
    namesMap.put("BJ", "பெனின்");
    namesMap.put("BL", "செயின்ட் பார்தேலெமி");
    namesMap.put("BM", "பெர்முடா");
    namesMap.put("BN", "புருனே");
    namesMap.put("BO", "பொலிவியா");
    namesMap.put("BQ", "கரீபியன் நெதர்லாந்து");
    namesMap.put("BR", "பிரேசில்");
    namesMap.put("BS", "பஹாமாஸ்");
    namesMap.put("BT", "பூடான்");
    namesMap.put("BV", "பொவேட் தீவுகள்");
    namesMap.put("BW", "போட்ஸ்வானா");
    namesMap.put("BY", "பெலாரஸ்");
    namesMap.put("BZ", "பெலிஸ்");
    namesMap.put("CA", "கனடா");
    namesMap.put("CC", "கோகோஸ் (கீலிங்) தீவுகள்");
    namesMap.put("CD", "காங்கோ - கின்ஷாசா");
    namesMap.put("CF", "மத்திய ஆப்ரிக்கக் குடியரசு");
    namesMap.put("CG", "காங்கோ - ப்ராஸாவில்லே");
    namesMap.put("CH", "ஸ்விட்சர்லாந்து");
    namesMap.put("CI", "கோட் தி’வாயர்");
    namesMap.put("CK", "குக் தீவுகள்");
    namesMap.put("CL", "சிலி");
    namesMap.put("CM", "கேமரூன்");
    namesMap.put("CN", "சீனா");
    namesMap.put("CO", "கொலம்பியா");
    namesMap.put("CP", "கிலிப்பர்டன் தீவு");
    namesMap.put("CR", "கோஸ்டாரிகா");
    namesMap.put("CU", "கியூபா");
    namesMap.put("CV", "கேப் வெர்டே");
    namesMap.put("CW", "குராகவ்");
    namesMap.put("CX", "கிறிஸ்துமஸ் தீவு");
    namesMap.put("CY", "சைப்ரஸ்");
    namesMap.put("CZ", "செசியா");
    namesMap.put("DE", "ஜெர்மனி");
    namesMap.put("DG", "டியகோ கார்ஷியா");
    namesMap.put("DJ", "ஜிபௌட்டி");
    namesMap.put("DK", "டென்மார்க்");
    namesMap.put("DM", "டொமினிகா");
    namesMap.put("DO", "டொமினிகன் குடியரசு");
    namesMap.put("DZ", "அல்ஜீரியா");
    namesMap.put("EA", "சியூடா & மெலில்லா");
    namesMap.put("EC", "ஈக்வடார்");
    namesMap.put("EE", "எஸ்டோனியா");
    namesMap.put("EG", "எகிப்து");
    namesMap.put("EH", "மேற்கு சஹாரா");
    namesMap.put("ER", "எரிட்ரியா");
    namesMap.put("ES", "ஸ்பெயின்");
    namesMap.put("ET", "எத்தியோப்பியா");
    namesMap.put("EU", "ஐரோப்பிய யூனியன்");
    namesMap.put("EZ", "யூரோஜோன்");
    namesMap.put("FI", "பின்லாந்து");
    namesMap.put("FJ", "ஃபிஜி");
    namesMap.put("FK", "ஃபாக்லாந்து தீவுகள்");
    namesMap.put("FM", "மைக்ரோனேஷியா");
    namesMap.put("FO", "ஃபாரோ தீவுகள்");
    namesMap.put("FR", "பிரான்ஸ்");
    namesMap.put("GA", "கேபான்");
    namesMap.put("GB", "யுனைடெட் கிங்டம்");
    namesMap.put("GD", "கிரனெடா");
    namesMap.put("GE", "ஜார்ஜியா");
    namesMap.put("GF", "பிரெஞ்சு கயானா");
    namesMap.put("GG", "கெர்ன்சி");
    namesMap.put("GH", "கானா");
    namesMap.put("GI", "ஜிப்ரால்டர்");
    namesMap.put("GL", "கிரீன்லாந்து");
    namesMap.put("GM", "காம்பியா");
    namesMap.put("GN", "கினியா");
    namesMap.put("GP", "க்வாதேலோப்");
    namesMap.put("GQ", "ஈக்வடோரியல் கினியா");
    namesMap.put("GR", "கிரீஸ்");
    namesMap.put("GS", "தெற்கு ஜார்ஜியா மற்றும் தெற்கு சாண்ட்விச் தீவுகள்");
    namesMap.put("GT", "கவுதமாலா");
    namesMap.put("GU", "குவாம்");
    namesMap.put("GW", "கினியா-பிஸ்ஸாவ்");
    namesMap.put("GY", "கயானா");
    namesMap.put("HK", "ஹாங்காங் எஸ்ஏஆர் சீனா");
    namesMap.put("HM", "ஹேர்ட் மற்றும் மெக்டொனால்டு தீவுகள்");
    namesMap.put("HN", "ஹோண்டூராஸ்");
    namesMap.put("HR", "குரேஷியா");
    namesMap.put("HT", "ஹைட்டி");
    namesMap.put("HU", "ஹங்கேரி");
    namesMap.put("IC", "கேனரி தீவுகள்");
    namesMap.put("ID", "இந்தோனேசியா");
    namesMap.put("IE", "அயர்லாந்து");
    namesMap.put("IL", "இஸ்ரேல்");
    namesMap.put("IM", "ஐல் ஆஃப் மேன்");
    namesMap.put("IN", "இந்தியா");
    namesMap.put("IO", "பிரிட்டிஷ் இந்தியப் பெருங்கடல் பிரதேசம்");
    namesMap.put("IQ", "ஈராக்");
    namesMap.put("IR", "ஈரான்");
    namesMap.put("IS", "ஐஸ்லாந்து");
    namesMap.put("IT", "இத்தாலி");
    namesMap.put("JE", "ஜெர்சி");
    namesMap.put("JM", "ஜமைகா");
    namesMap.put("JO", "ஜோர்டான்");
    namesMap.put("JP", "ஜப்பான்");
    namesMap.put("KE", "கென்யா");
    namesMap.put("KG", "கிர்கிஸ்தான்");
    namesMap.put("KH", "கம்போடியா");
    namesMap.put("KI", "கிரிபாட்டி");
    namesMap.put("KM", "கோமரோஸ்");
    namesMap.put("KN", "செயின்ட் கிட்ஸ் & நெவிஸ்");
    namesMap.put("KP", "வட கொரியா");
    namesMap.put("KR", "தென் கொரியா");
    namesMap.put("KW", "குவைத்");
    namesMap.put("KY", "கெய்மென் தீவுகள்");
    namesMap.put("KZ", "கஸகஸ்தான்");
    namesMap.put("LA", "லாவோஸ்");
    namesMap.put("LB", "லெபனான்");
    namesMap.put("LC", "செயின்ட் லூசியா");
    namesMap.put("LI", "லிச்செண்ஸ்டெய்ன்");
    namesMap.put("LK", "இலங்கை");
    namesMap.put("LR", "லைபீரியா");
    namesMap.put("LS", "லெசோதோ");
    namesMap.put("LT", "லிதுவேனியா");
    namesMap.put("LU", "லக்ஸ்சம்பர்க்");
    namesMap.put("LV", "லாட்வியா");
    namesMap.put("LY", "லிபியா");
    namesMap.put("MA", "மொராக்கோ");
    namesMap.put("MC", "மொனாக்கோ");
    namesMap.put("MD", "மால்டோவா");
    namesMap.put("ME", "மான்டேனெக்ரோ");
    namesMap.put("MF", "செயின்ட் மார்ட்டீன்");
    namesMap.put("MG", "மடகாஸ்கர்");
    namesMap.put("MH", "மார்ஷல் தீவுகள்");
    namesMap.put("MK", "மாசிடோனியா");
    namesMap.put("ML", "மாலி");
    namesMap.put("MM", "மியான்மார் (பர்மா)");
    namesMap.put("MN", "மங்கோலியா");
    namesMap.put("MO", "மகாவ் எஸ்ஏஆர் சீனா");
    namesMap.put("MP", "வடக்கு மரியானா தீவுகள்");
    namesMap.put("MQ", "மார்டினிக்");
    namesMap.put("MR", "மௌரிடானியா");
    namesMap.put("MS", "மாண்ட்செராட்");
    namesMap.put("MT", "மால்டா");
    namesMap.put("MU", "மொரிசியஸ்");
    namesMap.put("MV", "மாலத்தீவு");
    namesMap.put("MW", "மலாவி");
    namesMap.put("MX", "மெக்சிகோ");
    namesMap.put("MY", "மலேசியா");
    namesMap.put("MZ", "மொசாம்பிக்");
    namesMap.put("NA", "நமீபியா");
    namesMap.put("NC", "நியூ கேலிடோனியா");
    namesMap.put("NE", "நைஜர்");
    namesMap.put("NF", "நார்ஃபோக் தீவு");
    namesMap.put("NG", "நைஜீரியா");
    namesMap.put("NI", "நிகரகுவா");
    namesMap.put("NL", "நெதர்லாந்து");
    namesMap.put("NO", "நார்வே");
    namesMap.put("NP", "நேபாளம்");
    namesMap.put("NR", "நௌரு");
    namesMap.put("NU", "நியுவே");
    namesMap.put("NZ", "நியூசிலாந்து");
    namesMap.put("OM", "ஓமன்");
    namesMap.put("PA", "பனாமா");
    namesMap.put("PE", "பெரு");
    namesMap.put("PF", "பிரெஞ்சு பாலினேஷியா");
    namesMap.put("PG", "பப்புவா நியூ கினியா");
    namesMap.put("PH", "பிலிப்பைன்ஸ்");
    namesMap.put("PK", "பாகிஸ்தான்");
    namesMap.put("PL", "போலந்து");
    namesMap.put("PM", "செயின்ட் பியர் & மிக்வேலான்");
    namesMap.put("PN", "பிட்கெய்ர்ன் தீவுகள்");
    namesMap.put("PR", "பியூர்டோ ரிகோ");
    namesMap.put("PS", "பாலஸ்தீனிய பிரதேசங்கள்");
    namesMap.put("PT", "போர்ச்சுக்கல்");
    namesMap.put("PW", "பாலோ");
    namesMap.put("PY", "பராகுவே");
    namesMap.put("QA", "கத்தார்");
    namesMap.put("QO", "வெளிப்புற ஓஷியானியா");
    namesMap.put("RE", "ரீயூனியன்");
    namesMap.put("RO", "ருமேனியா");
    namesMap.put("RS", "செர்பியா");
    namesMap.put("RU", "ரஷ்யா");
    namesMap.put("RW", "ருவாண்டா");
    namesMap.put("SA", "சவூதி அரேபியா");
    namesMap.put("SB", "சாலமன் தீவுகள்");
    namesMap.put("SC", "சீஷெல்ஸ்");
    namesMap.put("SD", "சூடான்");
    namesMap.put("SE", "ஸ்வீடன்");
    namesMap.put("SG", "சிங்கப்பூர்");
    namesMap.put("SH", "செயின்ட் ஹெலெனா");
    namesMap.put("SI", "ஸ்லோவேனியா");
    namesMap.put("SJ", "ஸ்வல்பார்டு & ஜான் மேயன்");
    namesMap.put("SK", "ஸ்லோவாகியா");
    namesMap.put("SL", "சியாரா லியோன்");
    namesMap.put("SM", "சான் மரினோ");
    namesMap.put("SN", "செனெகல்");
    namesMap.put("SO", "சோமாலியா");
    namesMap.put("SR", "சுரினாம்");
    namesMap.put("SS", "தெற்கு சூடான்");
    namesMap.put("ST", "சாவ் தோம் & ப்ரின்சிபி");
    namesMap.put("SV", "எல் சால்வடார்");
    namesMap.put("SX", "சின்ட் மார்டென்");
    namesMap.put("SY", "சிரியா");
    namesMap.put("SZ", "ஸ்வாஸிலாந்து");
    namesMap.put("TA", "டிரிஸ்டன் டா குன்ஹா");
    namesMap.put("TC", "டர்க்ஸ் & கைகோஸ் தீவுகள்");
    namesMap.put("TD", "சாட்");
    namesMap.put("TF", "பிரெஞ்சு தெற்கு பிரதேசங்கள்");
    namesMap.put("TG", "டோகோ");
    namesMap.put("TH", "தாய்லாந்து");
    namesMap.put("TJ", "தஜிகிஸ்தான்");
    namesMap.put("TK", "டோகேலோ");
    namesMap.put("TL", "தைமூர்-லெஸ்தே");
    namesMap.put("TM", "துர்க்மெனிஸ்தான்");
    namesMap.put("TN", "டுனிசியா");
    namesMap.put("TO", "டோங்கா");
    namesMap.put("TR", "துருக்கி");
    namesMap.put("TT", "டிரினிடாட் & டொபாகோ");
    namesMap.put("TV", "துவாலு");
    namesMap.put("TW", "தைவான்");
    namesMap.put("TZ", "தான்சானியா");
    namesMap.put("UA", "உக்ரைன்");
    namesMap.put("UG", "உகாண்டா");
    namesMap.put("UM", "யூ.எஸ். வெளிப்புறத் தீவுகள்");
    namesMap.put("UN", "ஐக்கிய நாடுகள்");
    namesMap.put("US", "அமெரிக்கா");
    namesMap.put("UY", "உருகுவே");
    namesMap.put("UZ", "உஸ்பெகிஸ்தான்");
    namesMap.put("VA", "வாடிகன் நகரம்");
    namesMap.put("VC", "செயின்ட் வின்சென்ட் & கிரெனடைன்ஸ்");
    namesMap.put("VE", "வெனிசுலா");
    namesMap.put("VG", "பிரிட்டீஷ் கன்னித் தீவுகள்");
    namesMap.put("VI", "யூ.எஸ். கன்னித் தீவுகள்");
    namesMap.put("VN", "வியட்நாம்");
    namesMap.put("VU", "வனுவாட்டு");
    namesMap.put("WF", "வாலிஸ் மற்றும் ஃபுடுனா");
    namesMap.put("WS", "சமோவா");
    namesMap.put("XK", "கொசோவோ");
    namesMap.put("YE", "ஏமன்");
    namesMap.put("YT", "மயோட்");
    namesMap.put("ZA", "தென் ஆப்பிரிக்கா");
    namesMap.put("ZM", "ஜாம்பியா");
    namesMap.put("ZW", "ஜிம்பாப்வே");
    namesMap.put("ZZ", "அறியப்படாத பிரதேசம்");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "உலகம்",
        "002": "ஆப்ரிக்கா",
        "003": "வட அமெரிக்கா",
        "005": "தென் அமெரிக்கா",
        "009": "ஓஷியானியா",
        "011": "மேற்கு ஆப்ரிக்கா",
        "013": "மத்திய அமெரிக்கா",
        "014": "கிழக்கு ஆப்ரிக்கா",
        "015": "வடக்கு ஆப்ரிக்கா",
        "017": "மத்திய ஆப்ரிக்கா",
        "018": "தெற்கு ஆப்ரிக்கா",
        "019": "அமெரிக்காஸ்",
        "021": "வடக்கு அமெரிக்கா",
        "029": "கரீபியன்",
        "030": "கிழக்காசியா",
        "034": "தெற்காசியா",
        "035": "தென்கிழக்காசியா",
        "039": "தெற்கு ஐரோப்பா",
        "053": "ஆஸ்திரலேசியா",
        "054": "மெலனேஷியா",
        "057": "மைக்ரோ நேஷியா பிரதேசம்",
        "061": "பாலினேஷியா",
        "142": "ஆசியா",
        "143": "மத்திய ஆசியா",
        "145": "மேற்காசியா",
        "150": "ஐரோப்பா",
        "151": "கிழக்கு ஐரோப்பா",
        "154": "வடக்கு ஐரோப்பா",
        "155": "மேற்கு ஐரோப்பா",
        "202": "துணை சஹாரா ஆப்பிரிக்கா",
        "419": "லத்தீன் அமெரிக்கா",
        "AC": "அஷன்ஷியன் தீவு",
        "AD": "அன்டோரா",
        "AE": "ஐக்கிய அரபு எமிரேட்ஸ்",
        "AF": "ஆஃப்கானிஸ்தான்",
        "AG": "ஆண்டிகுவா மற்றும் பார்புடா",
        "AI": "அங்கியுலா",
        "AL": "அல்பேனியா",
        "AM": "அர்மேனியா",
        "AO": "அங்கோலா",
        "AQ": "அண்டார்டிகா",
        "AR": "அர்ஜென்டினா",
        "AS": "அமெரிக்க சமோவா",
        "AT": "ஆஸ்திரியா",
        "AU": "ஆஸ்திரேலியா",
        "AW": "அரூபா",
        "AX": "ஆலந்து தீவுகள்",
        "AZ": "அசர்பைஜான்",
        "BA": "போஸ்னியா & ஹெர்ஸகோவினா",
        "BB": "பார்படோஸ்",
        "BD": "பங்களாதேஷ்",
        "BE": "பெல்ஜியம்",
        "BF": "புர்கினா ஃபாஸோ",
        "BG": "பல்கேரியா",
        "BH": "பஹ்ரைன்",
        "BI": "புருண்டி",
        "BJ": "பெனின்",
        "BL": "செயின்ட் பார்தேலெமி",
        "BM": "பெர்முடா",
        "BN": "புருனே",
        "BO": "பொலிவியா",
        "BQ": "கரீபியன் நெதர்லாந்து",
        "BR": "பிரேசில்",
        "BS": "பஹாமாஸ்",
        "BT": "பூடான்",
        "BV": "பொவேட் தீவுகள்",
        "BW": "போட்ஸ்வானா",
        "BY": "பெலாரஸ்",
        "BZ": "பெலிஸ்",
        "CA": "கனடா",
        "CC": "கோகோஸ் (கீலிங்) தீவுகள்",
        "CD": "காங்கோ - கின்ஷாசா",
        "CF": "மத்திய ஆப்ரிக்கக் குடியரசு",
        "CG": "காங்கோ - ப்ராஸாவில்லே",
        "CH": "ஸ்விட்சர்லாந்து",
        "CI": "கோட் தி’வாயர்",
        "CK": "குக் தீவுகள்",
        "CL": "சிலி",
        "CM": "கேமரூன்",
        "CN": "சீனா",
        "CO": "கொலம்பியா",
        "CP": "கிலிப்பர்டன் தீவு",
        "CR": "கோஸ்டாரிகா",
        "CU": "கியூபா",
        "CV": "கேப் வெர்டே",
        "CW": "குராகவ்",
        "CX": "கிறிஸ்துமஸ் தீவு",
        "CY": "சைப்ரஸ்",
        "CZ": "செசியா",
        "DE": "ஜெர்மனி",
        "DG": "டியகோ கார்ஷியா",
        "DJ": "ஜிபௌட்டி",
        "DK": "டென்மார்க்",
        "DM": "டொமினிகா",
        "DO": "டொமினிகன் குடியரசு",
        "DZ": "அல்ஜீரியா",
        "EA": "சியூடா & மெலில்லா",
        "EC": "ஈக்வடார்",
        "EE": "எஸ்டோனியா",
        "EG": "எகிப்து",
        "EH": "மேற்கு சஹாரா",
        "ER": "எரிட்ரியா",
        "ES": "ஸ்பெயின்",
        "ET": "எத்தியோப்பியா",
        "EU": "ஐரோப்பிய யூனியன்",
        "EZ": "யூரோஜோன்",
        "FI": "பின்லாந்து",
        "FJ": "ஃபிஜி",
        "FK": "ஃபாக்லாந்து தீவுகள்",
        "FM": "மைக்ரோனேஷியா",
        "FO": "ஃபாரோ தீவுகள்",
        "FR": "பிரான்ஸ்",
        "GA": "கேபான்",
        "GB": "யுனைடெட் கிங்டம்",
        "GD": "கிரனெடா",
        "GE": "ஜார்ஜியா",
        "GF": "பிரெஞ்சு கயானா",
        "GG": "கெர்ன்சி",
        "GH": "கானா",
        "GI": "ஜிப்ரால்டர்",
        "GL": "கிரீன்லாந்து",
        "GM": "காம்பியா",
        "GN": "கினியா",
        "GP": "க்வாதேலோப்",
        "GQ": "ஈக்வடோரியல் கினியா",
        "GR": "கிரீஸ்",
        "GS": "தெற்கு ஜார்ஜியா மற்றும் தெற்கு சாண்ட்விச் தீவுகள்",
        "GT": "கவுதமாலா",
        "GU": "குவாம்",
        "GW": "கினியா-பிஸ்ஸாவ்",
        "GY": "கயானா",
        "HK": "ஹாங்காங் எஸ்ஏஆர் சீனா",
        "HM": "ஹேர்ட் மற்றும் மெக்டொனால்டு தீவுகள்",
        "HN": "ஹோண்டூராஸ்",
        "HR": "குரேஷியா",
        "HT": "ஹைட்டி",
        "HU": "ஹங்கேரி",
        "IC": "கேனரி தீவுகள்",
        "ID": "இந்தோனேசியா",
        "IE": "அயர்லாந்து",
        "IL": "இஸ்ரேல்",
        "IM": "ஐல் ஆஃப் மேன்",
        "IN": "இந்தியா",
        "IO": "பிரிட்டிஷ் இந்தியப் பெருங்கடல் பிரதேசம்",
        "IQ": "ஈராக்",
        "IR": "ஈரான்",
        "IS": "ஐஸ்லாந்து",
        "IT": "இத்தாலி",
        "JE": "ஜெர்சி",
        "JM": "ஜமைகா",
        "JO": "ஜோர்டான்",
        "JP": "ஜப்பான்",
        "KE": "கென்யா",
        "KG": "கிர்கிஸ்தான்",
        "KH": "கம்போடியா",
        "KI": "கிரிபாட்டி",
        "KM": "கோமரோஸ்",
        "KN": "செயின்ட் கிட்ஸ் & நெவிஸ்",
        "KP": "வட கொரியா",
        "KR": "தென் கொரியா",
        "KW": "குவைத்",
        "KY": "கெய்மென் தீவுகள்",
        "KZ": "கஸகஸ்தான்",
        "LA": "லாவோஸ்",
        "LB": "லெபனான்",
        "LC": "செயின்ட் லூசியா",
        "LI": "லிச்செண்ஸ்டெய்ன்",
        "LK": "இலங்கை",
        "LR": "லைபீரியா",
        "LS": "லெசோதோ",
        "LT": "லிதுவேனியா",
        "LU": "லக்ஸ்சம்பர்க்",
        "LV": "லாட்வியா",
        "LY": "லிபியா",
        "MA": "மொராக்கோ",
        "MC": "மொனாக்கோ",
        "MD": "மால்டோவா",
        "ME": "மான்டேனெக்ரோ",
        "MF": "செயின்ட் மார்ட்டீன்",
        "MG": "மடகாஸ்கர்",
        "MH": "மார்ஷல் தீவுகள்",
        "MK": "மாசிடோனியா",
        "ML": "மாலி",
        "MM": "மியான்மார் (பர்மா)",
        "MN": "மங்கோலியா",
        "MO": "மகாவ் எஸ்ஏஆர் சீனா",
        "MP": "வடக்கு மரியானா தீவுகள்",
        "MQ": "மார்டினிக்",
        "MR": "மௌரிடானியா",
        "MS": "மாண்ட்செராட்",
        "MT": "மால்டா",
        "MU": "மொரிசியஸ்",
        "MV": "மாலத்தீவு",
        "MW": "மலாவி",
        "MX": "மெக்சிகோ",
        "MY": "மலேசியா",
        "MZ": "மொசாம்பிக்",
        "NA": "நமீபியா",
        "NC": "நியூ கேலிடோனியா",
        "NE": "நைஜர்",
        "NF": "நார்ஃபோக் தீவு",
        "NG": "நைஜீரியா",
        "NI": "நிகரகுவா",
        "NL": "நெதர்லாந்து",
        "NO": "நார்வே",
        "NP": "நேபாளம்",
        "NR": "நௌரு",
        "NU": "நியுவே",
        "NZ": "நியூசிலாந்து",
        "OM": "ஓமன்",
        "PA": "பனாமா",
        "PE": "பெரு",
        "PF": "பிரெஞ்சு பாலினேஷியா",
        "PG": "பப்புவா நியூ கினியா",
        "PH": "பிலிப்பைன்ஸ்",
        "PK": "பாகிஸ்தான்",
        "PL": "போலந்து",
        "PM": "செயின்ட் பியர் & மிக்வேலான்",
        "PN": "பிட்கெய்ர்ன் தீவுகள்",
        "PR": "பியூர்டோ ரிகோ",
        "PS": "பாலஸ்தீனிய பிரதேசங்கள்",
        "PT": "போர்ச்சுக்கல்",
        "PW": "பாலோ",
        "PY": "பராகுவே",
        "QA": "கத்தார்",
        "QO": "வெளிப்புற ஓஷியானியா",
        "RE": "ரீயூனியன்",
        "RO": "ருமேனியா",
        "RS": "செர்பியா",
        "RU": "ரஷ்யா",
        "RW": "ருவாண்டா",
        "SA": "சவூதி அரேபியா",
        "SB": "சாலமன் தீவுகள்",
        "SC": "சீஷெல்ஸ்",
        "SD": "சூடான்",
        "SE": "ஸ்வீடன்",
        "SG": "சிங்கப்பூர்",
        "SH": "செயின்ட் ஹெலெனா",
        "SI": "ஸ்லோவேனியா",
        "SJ": "ஸ்வல்பார்டு & ஜான் மேயன்",
        "SK": "ஸ்லோவாகியா",
        "SL": "சியாரா லியோன்",
        "SM": "சான் மரினோ",
        "SN": "செனெகல்",
        "SO": "சோமாலியா",
        "SR": "சுரினாம்",
        "SS": "தெற்கு சூடான்",
        "ST": "சாவ் தோம் & ப்ரின்சிபி",
        "SV": "எல் சால்வடார்",
        "SX": "சின்ட் மார்டென்",
        "SY": "சிரியா",
        "SZ": "ஸ்வாஸிலாந்து",
        "TA": "டிரிஸ்டன் டா குன்ஹா",
        "TC": "டர்க்ஸ் & கைகோஸ் தீவுகள்",
        "TD": "சாட்",
        "TF": "பிரெஞ்சு தெற்கு பிரதேசங்கள்",
        "TG": "டோகோ",
        "TH": "தாய்லாந்து",
        "TJ": "தஜிகிஸ்தான்",
        "TK": "டோகேலோ",
        "TL": "தைமூர்-லெஸ்தே",
        "TM": "துர்க்மெனிஸ்தான்",
        "TN": "டுனிசியா",
        "TO": "டோங்கா",
        "TR": "துருக்கி",
        "TT": "டிரினிடாட் & டொபாகோ",
        "TV": "துவாலு",
        "TW": "தைவான்",
        "TZ": "தான்சானியா",
        "UA": "உக்ரைன்",
        "UG": "உகாண்டா",
        "UM": "யூ.எஸ். வெளிப்புறத் தீவுகள்",
        "UN": "ஐக்கிய நாடுகள்",
        "US": "அமெரிக்கா",
        "UY": "உருகுவே",
        "UZ": "உஸ்பெகிஸ்தான்",
        "VA": "வாடிகன் நகரம்",
        "VC": "செயின்ட் வின்சென்ட் & கிரெனடைன்ஸ்",
        "VE": "வெனிசுலா",
        "VG": "பிரிட்டீஷ் கன்னித் தீவுகள்",
        "VI": "யூ.எஸ். கன்னித் தீவுகள்",
        "VN": "வியட்நாம்",
        "VU": "வனுவாட்டு",
        "WF": "வாலிஸ் மற்றும் ஃபுடுனா",
        "WS": "சமோவா",
        "XK": "கொசோவோ",
        "YE": "ஏமன்",
        "YT": "மயோட்",
        "ZA": "தென் ஆப்பிரிக்கா",
        "ZM": "ஜாம்பியா",
        "ZW": "ஜிம்பாப்வே",
        "ZZ": "அறியப்படாத பிரதேசம்"
    };
  }-*/;
}
