/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.gss;

import com.google.gwt.resources.gss.ast.CssJavaExpressionNode;
import com.google.gwt.resources.gss.ast.CssRuntimeConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssAtRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssBooleanExpressionNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssCompilerPass;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalBlockNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssConditionalRuleNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.CssValueNode;
import com.google.gwt.thirdparty.common.css.compiler.ast.DefaultTreeVisitor;
import com.google.gwt.thirdparty.common.css.compiler.ast.MutatingVisitController;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CreateRuntimeConditionalNodes
extends DefaultTreeVisitor
implements CssCompilerPass {
    private static final Pattern EVAL_FUNCTION = Pattern.compile("^eval\\(([\"'])(((?!\\1).)*)\\1\\)$");
    private final MutatingVisitController visitController;

    public CreateRuntimeConditionalNodes(MutatingVisitController visitController) {
        this.visitController = visitController;
    }

    public boolean enterConditionalBlock(CssConditionalBlockNode block) {
        ArrayList<CssConditionalRuleNode> children = Lists.newArrayList(block.getChildren());
        for (CssConditionalRuleNode ruleNode : children) {
            this.visitConditionalRule(ruleNode, block);
        }
        return true;
    }

    private void visitConditionalRule(CssConditionalRuleNode node, CssConditionalBlockNode parent) {
        CssBooleanExpressionNode nodeCondition;
        String condition;
        if (node.getType() != CssAtRuleNode.Type.ELSE && (condition = this.extractRuntimeCondition((CssValueNode)(nodeCondition = node.getCondition()))) != null) {
            CssJavaExpressionNode newNode = new CssJavaExpressionNode(condition, nodeCondition.getSourceCodeLocation());
            CssRuntimeConditionalRuleNode newRuleNode = new CssRuntimeConditionalRuleNode(node, newNode);
            int index = parent.getChildren().indexOf(node);
            parent.replaceChildAt(index, Lists.newArrayList(newRuleNode));
        }
    }

    private String extractRuntimeCondition(CssValueNode node) {
        Matcher m = EVAL_FUNCTION.matcher(node.getValue());
        return m.matches() ? m.group(2) : null;
    }

    public void runPass() {
        this.visitController.startVisit((CssTreeVisitor)this);
    }
}

