/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.i18n.client.CurrencyData;
import com.google.gwt.i18n.client.impl.CurrencyDataImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

public class CurrencyList
implements Iterable<CurrencyData> {
    protected HashMap<String, CurrencyData> dataMapJava;
    protected JavaScriptObject dataMapNative;
    protected HashMap<String, String> namesMapJava;
    protected JavaScriptObject namesMapNative;

    public static CurrencyList get() {
        return CurrencyListInstance.instance;
    }

    protected static final native JavaScriptObject overrideMap(JavaScriptObject var0, JavaScriptObject var1);

    private static native void loadCurrencyValuesNative(JavaScriptObject var0, ArrayList<CurrencyData> var1);

    private static native String lookupNameNative(JavaScriptObject var0, String var1);

    private static native CurrencyData lookupNative(JavaScriptObject var0, String var1);

    public CurrencyData getDefault() {
        if (GWT.isScript()) {
            return this.getDefaultNative();
        }
        return this.getDefaultJava();
    }

    @Override
    public final Iterator<CurrencyData> iterator() {
        return this.iterator(false);
    }

    public final Iterator<CurrencyData> iterator(boolean includeDeprecated) {
        this.ensureCurrencyMap();
        ArrayList<CurrencyData> collection = new ArrayList<CurrencyData>();
        if (GWT.isScript()) {
            CurrencyList.loadCurrencyValuesNative(this.dataMapNative, collection);
        } else {
            for (CurrencyData item : this.dataMapJava.values()) {
                collection.add(item);
            }
        }
        if (!includeDeprecated) {
            ArrayList<CurrencyData> newCollection = new ArrayList<CurrencyData>();
            for (CurrencyData value : collection) {
                if (value.isDeprecated()) continue;
                newCollection.add(value);
            }
            collection = newCollection;
        }
        return Collections.unmodifiableList(collection).iterator();
    }

    public final CurrencyData lookup(String currencyCode) {
        this.ensureCurrencyMap();
        if (GWT.isScript()) {
            return CurrencyList.lookupNative(this.dataMapNative, currencyCode);
        }
        return this.dataMapJava.get(currencyCode);
    }

    public final String lookupName(String currencyCode) {
        this.ensureNamesMap();
        if (GWT.isScript()) {
            return CurrencyList.lookupNameNative(this.namesMapNative, currencyCode);
        }
        String result = this.namesMapJava.get(currencyCode);
        return result == null ? currencyCode : result;
    }

    protected CurrencyData getDefaultJava() {
        return new CurrencyDataImpl("USD", "$", 2, "US$", "$");
    }

    protected native CurrencyData getDefaultNative();

    protected HashMap<String, CurrencyData> loadCurrencyMapJava() {
        HashMap<String, CurrencyData> result = new HashMap<String, CurrencyData>();
        result.put("USD", new CurrencyDataImpl("USD", "$", 2, "US$", "$"));
        result.put("EUR", new CurrencyDataImpl("EUR", "\u20ac", 2, "\u20ac", "\u20ac"));
        result.put("GBP", new CurrencyDataImpl("GBP", "UK\u00a3", 2, "UK\u00a3", "\u00a3"));
        result.put("JPY", new CurrencyDataImpl("JPY", "\u00a5", 0, "JP\u00a5", "\u00a5"));
        return result;
    }

    protected native JavaScriptObject loadCurrencyMapNative();

    protected HashMap<String, String> loadNamesMapJava() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("USD", "US Dollar");
        result.put("EUR", "Euro");
        result.put("GBP", "British Pound Sterling");
        result.put("JPY", "Japanese Yen");
        return result;
    }

    protected native JavaScriptObject loadNamesMapNative();

    private void ensureCurrencyMap() {
        if (GWT.isScript()) {
            if (this.dataMapNative == null) {
                this.dataMapNative = this.loadCurrencyMapNative();
            }
        } else if (this.dataMapJava == null) {
            this.dataMapJava = this.loadCurrencyMapJava();
        }
    }

    private void ensureNamesMap() {
        if (GWT.isScript()) {
            if (this.namesMapNative == null) {
                this.namesMapNative = this.loadNamesMapNative();
            }
        } else if (this.namesMapJava == null) {
            this.namesMapJava = this.loadNamesMapJava();
        }
    }

    private static class CurrencyListInstance {
        private static CurrencyList instance = (CurrencyList)GWT.create(CurrencyList.class);

        private CurrencyListInstance() {
        }
    }
}

