/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.editor.client.adapters;

import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.EditorSource;
import com.google.gwt.editor.client.adapters.ListEditor;
import com.google.gwt.view.client.HasData;
import java.util.Collections;

public class HasDataEditor<T>
extends ListEditor<T, LeafValueEditor<T>> {
    public static <T> HasDataEditor<T> of(HasData<T> data) {
        return new HasDataEditor<T>(data);
    }

    private HasDataEditor(HasData<T> data) {
        super(new HasDataEditorSource<T>(data));
    }

    static class HasDataEditorSource<T>
    extends EditorSource<LeafValueEditor<T>> {
        private final HasData<T> data;

        public HasDataEditorSource(HasData<T> data) {
            this.data = data;
        }

        @Override
        public IndexedEditor<T> create(int index) {
            assert (index >= 0);
            return new IndexedEditor<T>(index, this.data);
        }

        @Override
        public LeafValueEditor<T> createEditorForTraversal() {
            return new IndexedEditor(-1, null);
        }

        @Override
        public void dispose(LeafValueEditor<T> subEditor) {
            assert (((IndexedEditor)subEditor).index >= 0);
            this.data.setRowCount(this.data.getRowCount() - 1);
        }

        @Override
        public void setIndex(LeafValueEditor<T> editor, int index) {
            assert (index >= 0);
            ((IndexedEditor)editor).setIndex(index);
        }
    }

    private static class IndexedEditor<Q>
    implements LeafValueEditor<Q> {
        private int index;
        private Q value;
        private final HasData<Q> data;

        IndexedEditor(int index, HasData<Q> data) {
            this.index = index;
            this.data = data;
        }

        @Override
        public Q getValue() {
            return this.value;
        }

        @Override
        public void setValue(Q value) {
            this.value = value;
            this.push();
        }

        void setIndex(int index) {
            assert (index >= 0);
            this.index = index;
            this.push();
        }

        private void push() {
            if (this.data != null) {
                this.data.setRowData(this.index, Collections.singletonList(this.value));
            }
        }
    }
}

