/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.AttachDetachException;
import com.google.gwt.user.client.ui.IndexedPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;
import java.util.Iterator;

public abstract class ComplexPanel
extends Panel
implements IndexedPanel.ForIsWidget {
    private WidgetCollection children = new WidgetCollection(this);
    private AttachDetachException.Command orphanCommand;

    @Override
    public Widget getWidget(int index) {
        return this.getChildren().get(index);
    }

    @Override
    public int getWidgetCount() {
        return this.getChildren().size();
    }

    @Override
    public int getWidgetIndex(Widget child) {
        return this.getChildren().indexOf(child);
    }

    @Override
    public int getWidgetIndex(IsWidget child) {
        return this.getWidgetIndex(ComplexPanel.asWidgetOrNull(child));
    }

    @Override
    public Iterator<Widget> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public boolean remove(int index) {
        return this.remove(this.getWidget(index));
    }

    @Override
    public boolean remove(Widget w) {
        if (w.getParent() != this) {
            return false;
        }
        try {
            this.orphan(w);
        }
        finally {
            Element elem = w.getElement();
            DOM.getParent(elem).removeChild(elem);
            this.getChildren().remove(w);
        }
        return true;
    }

    protected void add(Widget child, com.google.gwt.dom.client.Element container) {
        this.add(child, DOM.asOld(container));
    }

    @Deprecated
    protected void add(Widget child, Element container) {
        child.removeFromParent();
        this.getChildren().add(child);
        DOM.appendChild(container, child.getElement());
        this.adopt(child);
    }

    protected int adjustIndex(Widget child, int beforeIndex) {
        int idx;
        this.checkIndexBoundsForInsertion(beforeIndex);
        if (child.getParent() == this && (idx = this.getWidgetIndex(child)) < beforeIndex) {
            --beforeIndex;
        }
        return beforeIndex;
    }

    protected void checkIndexBoundsForAccess(int index) {
        if (index < 0 || index >= this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected void checkIndexBoundsForInsertion(int index) {
        if (index < 0 || index > this.getWidgetCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected WidgetCollection getChildren() {
        return this.children;
    }

    protected void insert(Widget child, com.google.gwt.dom.client.Element container, int beforeIndex, boolean domInsert) {
        this.insert(child, DOM.asOld(container), beforeIndex, domInsert);
    }

    @Deprecated
    protected void insert(Widget child, Element container, int beforeIndex, boolean domInsert) {
        beforeIndex = this.adjustIndex(child, beforeIndex);
        child.removeFromParent();
        this.getChildren().insert(child, beforeIndex);
        if (domInsert) {
            DOM.insertChild(container, child.getElement(), beforeIndex);
        } else {
            DOM.appendChild(container, child.getElement());
        }
        this.adopt(child);
    }

    void doLogicalClear() {
        if (this.orphanCommand == null) {
            this.orphanCommand = new AttachDetachException.Command(){

                @Override
                public void execute(Widget w) {
                    ComplexPanel.this.orphan(w);
                }
            };
        }
        try {
            AttachDetachException.tryCommand(this, this.orphanCommand);
        }
        finally {
            this.children = new WidgetCollection(this);
        }
    }
}

