/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferViewImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Int16Array;

public final class Int16ArrayImpl
extends ArrayBufferViewImpl
implements Int16Array {
    public Int16ArrayImpl(ArrayBuffer buffer, int byteOffset, int length) {
        super(buffer, byteOffset, length * 2);
    }

    @Override
    public short get(int index) {
        return this.arrayBuf.getInt16(this.checkRange(index, 2), true);
    }

    @Override
    public int length() {
        return this.byteLength() / 2;
    }

    @Override
    public void set(int index, int value) {
        this.arrayBuf.setInt16(this.checkRange(index, 2), (short)(value & 0xFFFF), true);
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, array[i]);
        }
    }

    @Override
    public void set(Int16Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Int16Array array, int offset) {
        int len = array.length();
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array.get(i));
        }
    }

    @Override
    public void set(short[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(short[] array, int offset) {
        int len = array.length;
        if (offset + len > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.set(offset++, (int)array[i]);
        }
    }

    @Override
    public Int16Array subarray(int begin) {
        int count = (this.byteLength() - this.byteOffset()) / 2;
        return this.subarray(begin, count);
    }

    @Override
    public Int16Array subarray(int begin, int end) {
        int count = (this.byteLength() - this.byteOffset()) / 2;
        if (begin < 0) {
            if ((begin += count) < 0) {
                begin = 0;
            }
        } else if (begin > count) {
            begin = count;
        }
        if (end < 0) {
            if ((end += count) < 0) {
                end = 0;
            }
        } else if (end > count) {
            end = count;
        }
        if (end < begin) {
            end = begin;
        }
        return new Int16ArrayImpl(this.arrayBuf, begin * 2, end * 2);
    }
}

