/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import com.google.gwt.thirdparty.debugging.sourcemap.OriginalMapping;
import java.util.Optional;

final class AutoValue_OriginalMapping
extends OriginalMapping {
    private final String originalFile;
    private final int lineNumber;
    private final int columnPosition;
    private final Optional<String> identifier;
    private final OriginalMapping.Precision precision;

    private AutoValue_OriginalMapping(String originalFile, int lineNumber, int columnPosition, Optional<String> identifier, OriginalMapping.Precision precision) {
        this.originalFile = originalFile;
        this.lineNumber = lineNumber;
        this.columnPosition = columnPosition;
        this.identifier = identifier;
        this.precision = precision;
    }

    @Override
    public String getOriginalFile() {
        return this.originalFile;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnPosition() {
        return this.columnPosition;
    }

    @Override
    public Optional<String> getIdentifier() {
        return this.identifier;
    }

    @Override
    public OriginalMapping.Precision getPrecision() {
        return this.precision;
    }

    public String toString() {
        return "OriginalMapping{originalFile=" + this.originalFile + ", lineNumber=" + this.lineNumber + ", columnPosition=" + this.columnPosition + ", identifier=" + this.identifier + ", precision=" + (Object)((Object)this.precision) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OriginalMapping) {
            OriginalMapping that = (OriginalMapping)o;
            return this.originalFile.equals(that.getOriginalFile()) && this.lineNumber == that.getLineNumber() && this.columnPosition == that.getColumnPosition() && this.identifier.equals(that.getIdentifier()) && this.precision.equals((Object)that.getPrecision());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.originalFile.hashCode();
        h$ *= 1000003;
        h$ ^= this.lineNumber;
        h$ *= 1000003;
        h$ ^= this.columnPosition;
        h$ *= 1000003;
        h$ ^= this.identifier.hashCode();
        h$ *= 1000003;
        return h$ ^= this.precision.hashCode();
    }

    @Override
    public OriginalMapping.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends OriginalMapping.Builder {
        private String originalFile;
        private Integer lineNumber;
        private Integer columnPosition;
        private Optional<String> identifier = Optional.empty();
        private OriginalMapping.Precision precision;

        Builder() {
        }

        private Builder(OriginalMapping source) {
            this.originalFile = source.getOriginalFile();
            this.lineNumber = source.getLineNumber();
            this.columnPosition = source.getColumnPosition();
            this.identifier = source.getIdentifier();
            this.precision = source.getPrecision();
        }

        @Override
        public OriginalMapping.Builder setOriginalFile(String originalFile) {
            if (originalFile == null) {
                throw new NullPointerException("Null originalFile");
            }
            this.originalFile = originalFile;
            return this;
        }

        @Override
        public OriginalMapping.Builder setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        @Override
        public OriginalMapping.Builder setColumnPosition(int columnPosition) {
            this.columnPosition = columnPosition;
            return this;
        }

        @Override
        public OriginalMapping.Builder setIdentifier(String identifier) {
            if (identifier == null) {
                throw new NullPointerException("Null identifier");
            }
            this.identifier = Optional.of(identifier);
            return this;
        }

        @Override
        public OriginalMapping.Builder setPrecision(OriginalMapping.Precision precision) {
            if (precision == null) {
                throw new NullPointerException("Null precision");
            }
            this.precision = precision;
            return this;
        }

        @Override
        public OriginalMapping build() {
            String missing = "";
            if (this.originalFile == null) {
                missing = missing + " originalFile";
            }
            if (this.lineNumber == null) {
                missing = missing + " lineNumber";
            }
            if (this.columnPosition == null) {
                missing = missing + " columnPosition";
            }
            if (this.precision == null) {
                missing = missing + " precision";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_OriginalMapping(this.originalFile, this.lineNumber, this.columnPosition, this.identifier, this.precision);
        }
    }
}

