/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.place.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.LegacyHandlerWrapper;
import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceChangeEvent;
import com.google.gwt.place.shared.PlaceController;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.user.client.History;
import java.util.logging.Logger;

public class PlaceHistoryHandler {
    private static final Logger log = Logger.getLogger(PlaceHistoryHandler.class.getName());
    private final Historian historian;
    private final PlaceHistoryMapper mapper;
    private PlaceController placeController;
    private Place defaultPlace = Place.NOWHERE;

    public PlaceHistoryHandler(PlaceHistoryMapper mapper) {
        this(mapper, (Historian)GWT.create(DefaultHistorian.class));
    }

    public PlaceHistoryHandler(PlaceHistoryMapper mapper, Historian historian) {
        this.mapper = mapper;
        this.historian = historian;
    }

    public void handleCurrentHistory() {
        this.handleHistoryToken(this.historian.getToken());
    }

    @Deprecated
    public HandlerRegistration register(PlaceController placeController, EventBus eventBus, Place defaultPlace) {
        return new LegacyHandlerWrapper(this.register(placeController, (com.google.web.bindery.event.shared.EventBus)eventBus, defaultPlace));
    }

    public com.google.web.bindery.event.shared.HandlerRegistration register(PlaceController placeController, com.google.web.bindery.event.shared.EventBus eventBus, Place defaultPlace) {
        this.placeController = placeController;
        this.defaultPlace = defaultPlace;
        final com.google.web.bindery.event.shared.HandlerRegistration placeReg = eventBus.addHandler(PlaceChangeEvent.TYPE, new PlaceChangeEvent.Handler(){

            @Override
            public void onPlaceChange(PlaceChangeEvent event) {
                Place newPlace = event.getNewPlace();
                PlaceHistoryHandler.this.historian.newItem(PlaceHistoryHandler.this.tokenForPlace(newPlace), false);
            }
        });
        final HandlerRegistration historyReg = this.historian.addValueChangeHandler(new ValueChangeHandler<String>(){

            @Override
            public void onValueChange(ValueChangeEvent<String> event) {
                String token = event.getValue();
                PlaceHistoryHandler.this.handleHistoryToken(token);
            }
        });
        return new com.google.web.bindery.event.shared.HandlerRegistration(){
            final /* synthetic */ PlaceHistoryHandler this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void removeHandler() {
                this.this$0.defaultPlace = Place.NOWHERE;
                this.this$0.placeController = null;
                placeReg.removeHandler();
                historyReg.removeHandler();
            }
        };
    }

    Logger log() {
        return log;
    }

    private void handleHistoryToken(String token) {
        Place newPlace = null;
        if ("".equals(token)) {
            newPlace = this.defaultPlace;
        }
        if (newPlace == null) {
            newPlace = this.mapper.getPlace(token);
        }
        if (newPlace == null) {
            this.log().warning("Unrecognized history token: " + token);
            newPlace = this.defaultPlace;
        }
        this.placeController.goTo(newPlace);
    }

    private String tokenForPlace(Place newPlace) {
        if (this.defaultPlace.equals(newPlace)) {
            return "";
        }
        String token = this.mapper.getToken(newPlace);
        if (token != null) {
            return token;
        }
        this.log().warning("Place not mapped to a token: " + newPlace);
        return "";
    }

    public static interface Historian {
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> var1);

        public String getToken();

        public void newItem(String var1, boolean var2);
    }

    public static class DefaultHistorian
    implements Historian {
        @Override
        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> valueChangeHandler) {
            return History.addValueChangeHandler(valueChangeHandler);
        }

        @Override
        public String getToken() {
            return History.getToken();
        }

        @Override
        public void newItem(String token, boolean issueEvent) {
            History.newItem(token, issueEvent);
        }
    }
}

