/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.ConstraintDescriptorImpl;
import com.google.gwt.validation.client.impl.ConstraintFinderImpl;
import com.google.gwt.validation.client.impl.GwtBeanDescriptor;
import com.google.gwt.validation.client.impl.PropertyDescriptorImpl;
import com.google.gwt.validation.client.impl.metadata.BeanMetadata;
import com.google.gwt.validation.client.impl.metadata.ValidationGroupsMetadata;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.PropertyDescriptor;

public final class GwtBeanDescriptorImpl<T>
implements GwtBeanDescriptor<T> {
    private final Class<T> clazz;
    private final Set<ConstraintDescriptorImpl<?>> constraints = new HashSet();
    private final Map<String, PropertyDescriptorImpl> descriptorMap = new HashMap<String, PropertyDescriptorImpl>();
    private final boolean isBeanConstrained;
    private final BeanMetadata beanMetadata;
    private ValidationGroupsMetadata validationGroupsMetadata;

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder(clazz);
    }

    private GwtBeanDescriptorImpl(Class<T> clazz, boolean isConstrained, Map<String, PropertyDescriptorImpl> descriptorMap, BeanMetadata beanMetadata, Set<ConstraintDescriptorImpl<?>> constraints) {
        this.clazz = clazz;
        this.isBeanConstrained = isConstrained;
        this.beanMetadata = beanMetadata;
        this.descriptorMap.putAll(descriptorMap);
        this.constraints.addAll(constraints);
    }

    public ElementDescriptor.ConstraintFinder findConstraints() {
        return new ConstraintFinderImpl(this.beanMetadata, this.validationGroupsMetadata, this.constraints);
    }

    public Set<PropertyDescriptor> getConstrainedProperties() {
        Collection<PropertyDescriptorImpl> props = this.descriptorMap.values();
        for (PropertyDescriptorImpl prop : props) {
            prop.setValidationGroupsMetadata(this.validationGroupsMetadata);
        }
        return new HashSet<PropertyDescriptor>(props);
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        return this.findConstraints().getConstraintDescriptors();
    }

    public PropertyDescriptor getConstraintsForProperty(String propertyName) {
        PropertyDescriptorImpl propDesc = this.descriptorMap.get(propertyName);
        if (propDesc != null) {
            propDesc.setValidationGroupsMetadata(this.validationGroupsMetadata);
        }
        return propDesc;
    }

    public Class<?> getElementClass() {
        return this.clazz;
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public boolean isBeanConstrained() {
        return this.isBeanConstrained;
    }

    @Override
    public void setValidationGroupsMetadata(ValidationGroupsMetadata validationGroupsMetadata) {
        this.validationGroupsMetadata = validationGroupsMetadata;
    }

    public static final class Builder<T> {
        private final Class<T> clazz;
        private final Map<String, PropertyDescriptorImpl> descriptorMap = new HashMap<String, PropertyDescriptorImpl>();
        private final Set<ConstraintDescriptorImpl<? extends Annotation>> constraints = new HashSet<ConstraintDescriptorImpl<? extends Annotation>>();
        private boolean isConstrained;
        private BeanMetadata beanMetadata;

        private Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public Builder<T> add(ConstraintDescriptorImpl<? extends Annotation> constraintDescriptor) {
            this.constraints.add(constraintDescriptor);
            return this;
        }

        public GwtBeanDescriptorImpl<T> build() {
            return new GwtBeanDescriptorImpl(this.clazz, this.isConstrained, this.descriptorMap, this.beanMetadata, this.constraints);
        }

        public Builder<T> put(String key, PropertyDescriptorImpl value) {
            this.descriptorMap.put(key, value.shallowCopy());
            return this;
        }

        public Builder<T> setBeanMetadata(BeanMetadata beanMetadata) {
            this.beanMetadata = beanMetadata;
            return this;
        }

        public Builder<T> setConstrained(boolean isConstrained) {
            this.isConstrained = isConstrained;
            return this;
        }
    }
}

