/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.text.shared.Parser;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ValueBoxBase;

public class ValueBox<T>
extends ValueBoxBase<T> {
    public static <T> ValueBox<T> wrap(Element element, Renderer<T> renderer, Parser<T> parser) {
        assert (Document.get().getBody().isOrHasChild(element));
        ValueBox<T> valueBox = new ValueBox<T>(element, renderer, parser);
        valueBox.onAttach();
        RootPanel.detachOnWindowClose(valueBox);
        return valueBox;
    }

    protected ValueBox(Element element, Renderer<T> renderer, Parser<T> parser) {
        super(element, renderer, parser);
        this.setDirectionEstimator(false);
        if (LocaleInfo.getCurrentLocale().isRTL()) {
            this.setDirection(HasDirection.Direction.LTR);
        }
        assert (InputElement.as(element).getType().equalsIgnoreCase("text"));
    }

    public int getMaxLength() {
        return this.getInputElement().getMaxLength();
    }

    public int getVisibleLength() {
        return this.getInputElement().getSize();
    }

    public void setMaxLength(int length) {
        this.getInputElement().setMaxLength(length);
    }

    public void setVisibleLength(int length) {
        this.getInputElement().setSize(length);
    }

    private InputElement getInputElement() {
        return (InputElement)this.getElement().cast();
    }
}

