/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.RootPanel;

public class SimpleCheckBox
extends FocusWidget
implements HasName,
HasValue<Boolean>,
IsEditor<LeafValueEditor<Boolean>> {
    private LeafValueEditor<Boolean> editor;
    private boolean valueChangeHandlerInitialized;

    public static SimpleCheckBox wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        SimpleCheckBox checkBox = new SimpleCheckBox(element);
        checkBox.onAttach();
        RootPanel.detachOnWindowClose(checkBox);
        return checkBox;
    }

    public SimpleCheckBox() {
        this(Document.get().createCheckInputElement(), "gwt-SimpleCheckBox");
    }

    protected SimpleCheckBox(Element element) {
        assert (InputElement.as(element).getType().equalsIgnoreCase("checkbox"));
        this.setElement(element);
    }

    SimpleCheckBox(Element element, String styleName) {
        this.setElement(element);
        if (styleName != null) {
            this.setStyleName(styleName);
        }
    }

    @Override
    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Boolean> handler) {
        if (!this.valueChangeHandlerInitialized) {
            this.ensureDomEventHandlers();
            this.valueChangeHandlerInitialized = true;
        }
        return this.addHandler(handler, ValueChangeEvent.getType());
    }

    @Override
    public LeafValueEditor<Boolean> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    public String getFormValue() {
        return this.getInputElement().getValue();
    }

    @Override
    public String getName() {
        return this.getInputElement().getName();
    }

    @Override
    public Boolean getValue() {
        String propName = this.isAttached() ? "checked" : "defaultChecked";
        return this.getInputElement().getPropertyBoolean(propName);
    }

    @Deprecated
    public boolean isChecked() {
        return this.getValue() == true;
    }

    @Deprecated
    public void setChecked(boolean checked) {
        this.setValue(checked);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.removeStyleDependentName("disabled");
        } else {
            this.addStyleDependentName("disabled");
        }
    }

    public void setFormValue(String value) {
        this.getInputElement().setAttribute("value", value);
    }

    @Override
    public void setName(String name) {
        this.getInputElement().setName(name);
    }

    @Override
    public void setValue(Boolean value) {
        this.setValue(value, false);
    }

    @Override
    public void setValue(Boolean value, boolean fireEvents) {
        if (value == null) {
            value = Boolean.FALSE;
        }
        Boolean oldValue = fireEvents ? this.getValue() : null;
        this.getInputElement().setChecked(value);
        this.getInputElement().setDefaultChecked(value);
        if (fireEvents) {
            ValueChangeEvent.fireIfNotEqual(this, oldValue, value);
        }
    }

    protected void ensureDomEventHandlers() {
        this.addClickHandler(new ClickHandler(){

            @Override
            public void onClick(ClickEvent event) {
                ValueChangeEvent.fire(SimpleCheckBox.this, SimpleCheckBox.this.getValue());
            }
        });
    }

    @Override
    protected void onUnload() {
        this.setValue(this.getValue());
    }

    private InputElement getInputElement() {
        return InputElement.as(this.getElement());
    }
}

