/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.HasChangeHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.BidiFormatter;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.i18n.shared.HasDirectionEstimator;
import com.google.gwt.i18n.shared.WordCountDirectionEstimator;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.ListenerWrapper;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SourcesChangeEvents;

public class ListBox
extends FocusWidget
implements SourcesChangeEvents,
HasChangeHandlers,
HasName,
HasDirectionEstimator {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = WordCountDirectionEstimator.get();
    private static final String BIDI_ATTR_NAME = "bidiwrapped";
    private static final int INSERT_AT_END = -1;
    private DirectionEstimator estimator;

    public static ListBox wrap(Element element) {
        assert (Document.get().getBody().isOrHasChild(element));
        ListBox listBox = new ListBox(element);
        listBox.onAttach();
        RootPanel.detachOnWindowClose(listBox);
        return listBox;
    }

    public ListBox() {
        super(Document.get().createSelectElement());
        this.setStyleName("gwt-ListBox");
    }

    @Deprecated
    public ListBox(boolean isMultipleSelect) {
        this();
        this.setMultipleSelect(isMultipleSelect);
    }

    protected ListBox(Element element) {
        super(element);
        SelectElement.as(element);
    }

    @Override
    public HandlerRegistration addChangeHandler(ChangeHandler handler) {
        return this.addDomHandler(handler, ChangeEvent.getType());
    }

    @Override
    @Deprecated
    public void addChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.add(this, listener);
    }

    public void addItem(String item) {
        this.insertItem(item, -1);
    }

    public void addItem(String item, HasDirection.Direction dir) {
        this.insertItem(item, dir, -1);
    }

    public void addItem(String item, String value) {
        this.insertItem(item, value, -1);
    }

    public void addItem(String item, HasDirection.Direction dir, String value) {
        this.insertItem(item, dir, value, -1);
    }

    public void clear() {
        this.getSelectElement().clear();
    }

    @Override
    public DirectionEstimator getDirectionEstimator() {
        return this.estimator;
    }

    public int getItemCount() {
        return this.getSelectElement().getOptions().getLength();
    }

    public String getItemText(int index) {
        this.checkIndex(index);
        return this.getOptionText(this.getSelectElement().getOptions().getItem(index));
    }

    public String getSelectedItemText() {
        int index = this.getSelectedIndex();
        return index == -1 ? null : this.getItemText(index);
    }

    @Override
    public String getName() {
        return this.getSelectElement().getName();
    }

    public int getSelectedIndex() {
        return this.getSelectElement().getSelectedIndex();
    }

    public String getValue(int index) {
        this.checkIndex(index);
        return this.getSelectElement().getOptions().getItem(index).getValue();
    }

    public String getSelectedValue() {
        int index = this.getSelectedIndex();
        return index == -1 ? null : this.getValue(index);
    }

    public int getVisibleItemCount() {
        return this.getSelectElement().getSize();
    }

    public void insertItem(String item, int index) {
        this.insertItem(item, item, index);
    }

    public void insertItem(String item, HasDirection.Direction dir, int index) {
        this.insertItem(item, dir, item, index);
    }

    public void insertItem(String item, String value, int index) {
        this.insertItem(item, null, value, index);
    }

    public void insertItem(String item, HasDirection.Direction dir, String value, int index) {
        SelectElement select = this.getSelectElement();
        OptionElement option = Document.get().createOptionElement();
        this.setOptionText(option, item, dir);
        option.setValue(value);
        int itemCount = select.getLength();
        if (index < 0 || index > itemCount) {
            index = itemCount;
        }
        if (index == itemCount) {
            select.add(option, null);
        } else {
            OptionElement before = select.getOptions().getItem(index);
            select.add(option, before);
        }
    }

    public boolean isItemSelected(int index) {
        this.checkIndex(index);
        return this.getSelectElement().getOptions().getItem(index).isSelected();
    }

    public boolean isMultipleSelect() {
        return this.getSelectElement().isMultiple();
    }

    @Override
    @Deprecated
    public void removeChangeListener(ChangeListener listener) {
        ListenerWrapper.WrappedChangeListener.remove(this, listener);
    }

    public void removeItem(int index) {
        this.checkIndex(index);
        this.getSelectElement().remove(index);
    }

    @Override
    public void setDirectionEstimator(boolean enabled) {
        this.setDirectionEstimator(enabled ? DEFAULT_DIRECTION_ESTIMATOR : null);
    }

    @Override
    public void setDirectionEstimator(DirectionEstimator directionEstimator) {
        this.estimator = directionEstimator;
    }

    public void setItemSelected(int index, boolean selected) {
        this.checkIndex(index);
        this.getSelectElement().getOptions().getItem(index).setSelected(selected);
    }

    public void setItemText(int index, String text) {
        this.setItemText(index, text, null);
    }

    public void setItemText(int index, String text, HasDirection.Direction dir) {
        this.checkIndex(index);
        if (text == null) {
            throw new NullPointerException("Cannot set an option to have null text");
        }
        this.setOptionText(this.getSelectElement().getOptions().getItem(index), text, dir);
    }

    public void setMultipleSelect(boolean multiple) {
        this.getSelectElement().setMultiple(multiple);
    }

    @Override
    public void setName(String name) {
        this.getSelectElement().setName(name);
    }

    public void setSelectedIndex(int index) {
        this.getSelectElement().setSelectedIndex(index);
    }

    public void setValue(int index, String value) {
        this.checkIndex(index);
        this.getSelectElement().getOptions().getItem(index).setValue(value);
    }

    public void setVisibleItemCount(int visibleItems) {
        this.getSelectElement().setSize(visibleItems);
    }

    protected String getOptionText(OptionElement option) {
        String text = option.getText();
        if (option.hasAttribute(BIDI_ATTR_NAME) && text.length() > 1) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    @Override
    protected void onEnsureDebugId(String baseID) {
        super.onEnsureDebugId(baseID);
        int numItems = this.getItemCount();
        for (int i = 0; i < numItems; ++i) {
            ListBox.ensureDebugId(this.getSelectElement().getOptions().getItem(i), baseID, "item" + i);
        }
    }

    protected void setOptionText(OptionElement option, String text, HasDirection.Direction dir) {
        if (dir == null && this.estimator != null) {
            dir = this.estimator.estimateDirection(text);
        }
        if (dir == null) {
            option.setText(text);
            option.removeAttribute(BIDI_ATTR_NAME);
        } else {
            String formattedText = BidiFormatter.getInstanceForCurrentLocale().unicodeWrapWithKnownDir(dir, text, false, false);
            option.setText(formattedText);
            if (formattedText.length() > text.length()) {
                option.setAttribute(BIDI_ATTR_NAME, "");
            } else {
                option.removeAttribute(BIDI_ATTR_NAME);
            }
        }
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private SelectElement getSelectElement() {
        return (SelectElement)this.getElement().cast();
    }
}

