/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.MenuItemSeparator;

public class MenuBarParser
implements ElementParser {
    static final String BAD_CHILD = "Only MenuItem or MenuItemSeparator subclasses are valid children";

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        if (MenuBar.class.getName().equals(type.getQualifiedSourceName()) && elem.hasAttribute("vertical")) {
            String vertical = elem.consumeBooleanAttribute("vertical");
            writer.setFieldInitializerAsConstructor(fieldName, new String[]{vertical});
        }
        JClassType itemType = writer.getOracle().findType(MenuItem.class.getName());
        JClassType separatorType = writer.getOracle().findType(MenuItemSeparator.class.getName());
        for (XMLElement child : elem.consumeChildElements()) {
            FieldWriter childField;
            JClassType childType = writer.findFieldType(child);
            if (itemType.isAssignableFrom(childType)) {
                childField = writer.parseElementToField(child);
                writer.addStatement("%1$s.addItem(%2$s);", new Object[]{fieldName, childField.getNextReference()});
                continue;
            }
            if (separatorType.isAssignableFrom(childType)) {
                childField = writer.parseElementToField(child);
                writer.addStatement("%1$s.addSeparator(%2$s);", new Object[]{fieldName, childField.getNextReference()});
                continue;
            }
            writer.die(child, BAD_CHILD, new Object[0]);
        }
    }
}

