/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.streamhtmlparser.impl;

import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.streamhtmlparser.impl.InternalState;

class ParserStateTable {
    private static final int MAX_STATES = 256;
    private static final int MAX_CHARS = 256;
    private final InternalState[][] stateTable = new InternalState[256][256];
    private final InternalState[] defaultStateTable = new InternalState[256];

    InternalState getNextState(InternalState from, int currentChar) {
        if (from == null || currentChar < 0) {
            return InternalState.INTERNAL_ERROR_STATE;
        }
        int id = from.getId();
        if (id < 0 || id >= 256) {
            return InternalState.INTERNAL_ERROR_STATE;
        }
        InternalState result = null;
        if (currentChar < 256) {
            result = this.stateTable[id][currentChar];
        }
        if (result == null) {
            result = this.defaultStateTable[from.getId()];
        }
        return result != null ? result : InternalState.INTERNAL_ERROR_STATE;
    }

    void setExpression(String expr, InternalState from, InternalState to) {
        if (expr == null || from == null || to == null) {
            return;
        }
        if ("[:default:]".equals(expr)) {
            this.setDefaultDestination(from, to);
            return;
        }
        int i = 0;
        while (i < expr.length()) {
            if (i < expr.length() - 2 && expr.charAt(i + 1) == '-') {
                this.setRange(from, expr.charAt(i), expr.charAt(i + 2), to);
                i += 2;
                continue;
            }
            this.setDestination(from, expr.charAt(i), to);
            ++i;
        }
    }

    private void fill(InternalState from, InternalState to) {
        for (char c = '\u0000'; c < '\u0100'; c = (char)(c + '\u0001')) {
            this.setDestination(from, c, to);
        }
    }

    private void setDefaultDestination(InternalState from, InternalState to) {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        int id = from.getId();
        if (id < 0 || id >= 256) {
            return;
        }
        this.defaultStateTable[from.getId()] = to;
    }

    private void setDestination(InternalState from, char chr, InternalState to) {
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        Preconditions.checkArgument(chr >= '\u0000' && chr < '\u0100', "char must be in ASCII set: %c", Character.valueOf(chr));
        int id = from.getId();
        if (id < 0 || id >= 256) {
            return;
        }
        this.stateTable[from.getId()][chr] = to;
    }

    private void setRange(InternalState from, char start, char end, InternalState to) {
        Preconditions.checkArgument(start >= '\u0000' && start < '\u0100', "char must be in ASCII set: %c", Character.valueOf(start));
        Preconditions.checkArgument(end >= '\u0000' && end < '\u0100', "char must be in ASCII set: %c", Character.valueOf(end));
        for (char c = start; c <= end; c = (char)(c + '\u0001')) {
            this.setDestination(from, c, to);
        }
    }
}

