/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client;

import com.google.gwt.i18n.client.DateTimeFormatInfo;
import com.google.gwt.i18n.client.DateTimeFormatInfoAdapter;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.i18n.client.constants.DateTimeConstants;
import com.google.gwt.i18n.client.impl.cldr.DateTimeFormatInfoImpl_en;
import java.util.HashMap;
import java.util.Map;

public class DateTimeFormat
extends com.google.gwt.i18n.shared.DateTimeFormat {
    private static final Map<String, DateTimeFormat> cache = new HashMap<String, DateTimeFormat>();

    public static DateTimeFormat getFormat(PredefinedFormat predef) {
        String pattern;
        if (DateTimeFormat.usesFixedEnglishStrings(predef)) {
            String pattern2;
            switch (predef.ordinal()) {
                case 1: {
                    pattern2 = "EEE, d MMM yyyy HH:mm:ss Z";
                    break;
                }
                case 0: {
                    pattern2 = "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected predef type " + (Object)((Object)predef));
                }
            }
            return DateTimeFormat.getFormat(pattern2, new DateTimeFormatInfoImpl_en());
        }
        DateTimeFormatInfo dtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        switch (predef.ordinal()) {
            case 2: {
                pattern = dtfi.dateFormatFull();
                break;
            }
            case 3: {
                pattern = dtfi.dateFormatLong();
                break;
            }
            case 4: {
                pattern = dtfi.dateFormatMedium();
                break;
            }
            case 5: {
                pattern = dtfi.dateFormatShort();
                break;
            }
            case 10: {
                pattern = dtfi.dateTimeFull(dtfi.timeFormatFull(), dtfi.dateFormatFull());
                break;
            }
            case 11: {
                pattern = dtfi.dateTimeLong(dtfi.timeFormatLong(), dtfi.dateFormatLong());
                break;
            }
            case 12: {
                pattern = dtfi.dateTimeMedium(dtfi.timeFormatMedium(), dtfi.dateFormatMedium());
                break;
            }
            case 13: {
                pattern = dtfi.dateTimeShort(dtfi.timeFormatShort(), dtfi.dateFormatShort());
                break;
            }
            case 14: {
                pattern = dtfi.formatDay();
                break;
            }
            case 17: {
                pattern = dtfi.formatHour24Minute();
                break;
            }
            case 18: {
                pattern = dtfi.formatHour24MinuteSecond();
                break;
            }
            case 15: {
                pattern = dtfi.formatHour12Minute();
                break;
            }
            case 16: {
                pattern = dtfi.formatHour12MinuteSecond();
                break;
            }
            case 19: {
                pattern = dtfi.formatMinuteSecond();
                break;
            }
            case 20: {
                pattern = dtfi.formatMonthFull();
                break;
            }
            case 21: {
                pattern = dtfi.formatMonthAbbrev();
                break;
            }
            case 22: {
                pattern = dtfi.formatMonthAbbrevDay();
                break;
            }
            case 23: {
                pattern = dtfi.formatMonthFullDay();
                break;
            }
            case 24: {
                pattern = dtfi.formatMonthNumDay();
                break;
            }
            case 25: {
                pattern = dtfi.formatMonthFullWeekdayDay();
                break;
            }
            case 6: {
                pattern = dtfi.timeFormatFull();
                break;
            }
            case 7: {
                pattern = dtfi.timeFormatLong();
                break;
            }
            case 8: {
                pattern = dtfi.timeFormatMedium();
                break;
            }
            case 9: {
                pattern = dtfi.timeFormatShort();
                break;
            }
            case 26: {
                pattern = dtfi.formatYear();
                break;
            }
            case 27: {
                pattern = dtfi.formatYearMonthFull();
                break;
            }
            case 28: {
                pattern = dtfi.formatYearMonthAbbrev();
                break;
            }
            case 29: {
                pattern = dtfi.formatYearMonthAbbrevDay();
                break;
            }
            case 30: {
                pattern = dtfi.formatYearMonthFullDay();
                break;
            }
            case 31: {
                pattern = dtfi.formatYearMonthNum();
                break;
            }
            case 32: {
                pattern = dtfi.formatYearMonthNumDay();
                break;
            }
            case 33: {
                pattern = dtfi.formatYearMonthWeekdayDay();
                break;
            }
            case 34: {
                pattern = dtfi.formatYearQuarterFull();
                break;
            }
            case 35: {
                pattern = dtfi.formatYearQuarterShort();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected predefined format " + (Object)((Object)predef));
            }
        }
        return DateTimeFormat.getFormat(pattern, dtfi);
    }

    public static DateTimeFormat getFormat(String pattern) {
        return DateTimeFormat.getFormat(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    public static DateTimeFormat getFullDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getFullTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_FULL);
    }

    @Deprecated
    public static DateTimeFormat getLongDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getLongTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_LONG);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getMediumTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_MEDIUM);
    }

    @Deprecated
    public static DateTimeFormat getShortDateFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortDateTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.DATE_TIME_SHORT);
    }

    @Deprecated
    public static DateTimeFormat getShortTimeFormat() {
        return DateTimeFormat.getFormat(PredefinedFormat.TIME_SHORT);
    }

    protected static DateTimeFormat getFormat(String pattern, DateTimeFormatInfo dtfi) {
        DateTimeFormatInfo defaultDtfi = DateTimeFormat.getDefaultDateTimeFormatInfo();
        DateTimeFormat dtf = null;
        if (dtfi == defaultDtfi) {
            dtf = cache.get(pattern);
        }
        if (dtf == null) {
            dtf = new DateTimeFormat(pattern, dtfi);
            if (dtfi == defaultDtfi) {
                cache.put(pattern, dtf);
            }
        }
        return dtf;
    }

    private static DateTimeFormatInfo getDefaultDateTimeFormatInfo() {
        return LocaleInfo.getCurrentLocale().getDateTimeFormatInfo();
    }

    private static boolean usesFixedEnglishStrings(PredefinedFormat predef) {
        switch (predef.ordinal()) {
            case 1: {
                return true;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    protected DateTimeFormat(String pattern) {
        this(pattern, DateTimeFormat.getDefaultDateTimeFormatInfo());
    }

    @Deprecated
    protected DateTimeFormat(String pattern, DateTimeConstants dateTimeConstants) {
        this(pattern, new DateTimeFormatInfoAdapter(dateTimeConstants));
    }

    protected DateTimeFormat(String pattern, DateTimeFormatInfo dtfi) {
        super(pattern, dtfi);
    }

    public static enum PredefinedFormat {
        ISO_8601,
        RFC_2822,
        DATE_FULL,
        DATE_LONG,
        DATE_MEDIUM,
        DATE_SHORT,
        TIME_FULL,
        TIME_LONG,
        TIME_MEDIUM,
        TIME_SHORT,
        DATE_TIME_FULL,
        DATE_TIME_LONG,
        DATE_TIME_MEDIUM,
        DATE_TIME_SHORT,
        DAY,
        HOUR_MINUTE,
        HOUR_MINUTE_SECOND,
        HOUR24_MINUTE,
        HOUR24_MINUTE_SECOND,
        MINUTE_SECOND,
        MONTH,
        MONTH_ABBR,
        MONTH_ABBR_DAY,
        MONTH_DAY,
        MONTH_NUM_DAY,
        MONTH_WEEKDAY_DAY,
        YEAR,
        YEAR_MONTH,
        YEAR_MONTH_ABBR,
        YEAR_MONTH_ABBR_DAY,
        YEAR_MONTH_DAY,
        YEAR_MONTH_NUM,
        YEAR_MONTH_NUM_DAY,
        YEAR_MONTH_WEEKDAY_DAY,
        YEAR_QUARTER,
        YEAR_QUARTER_ABBR;

    }
}

