/*
 * Copyright 2011 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.util.log.speedtracer;

import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger.EventType;

/**
 * Represents a type of event whose performance is tracked while running
 * {@link com.google.gwt.dev.DevMode}.
 *
 * @deprecated This class is deprecated for removal, see
 * <a href="https://github.com/gwtproject/gwt/issues/10007">issue 10007</a> for discussion of plans
 * to replace it.
 */
@Deprecated
public enum SpeedTracerEventType implements EventType {
  GC("Garbage Collection", "Plum"),
  OVERHEAD("Speedtracer Overhead","Black");

  final String cssColor;
  final String name;

  SpeedTracerEventType(String name, String cssColor) {
    this.name = name;
    this.cssColor = cssColor;
  }

  @Override
  public String getColor() {
    return cssColor;
  }

  @Override
  public String getName() {
    return name;
  }
}
