/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.android;

import android.util.Log;
import java.util.logging.Level;
import org.greenrobot.eventbus.Logger;

public class AndroidLogger
implements Logger {
    private static final boolean ANDROID_LOG_AVAILABLE;
    private final String tag;

    public static boolean isAndroidLogAvailable() {
        return ANDROID_LOG_AVAILABLE;
    }

    public AndroidLogger(String tag) {
        this.tag = tag;
    }

    @Override
    public void log(Level level, String msg) {
        if (level != Level.OFF) {
            Log.println((int)this.mapLevel(level), (String)this.tag, (String)msg);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable th) {
        if (level != Level.OFF) {
            Log.println((int)this.mapLevel(level), (String)this.tag, (String)(msg + "\n" + Log.getStackTraceString((Throwable)th)));
        }
    }

    private int mapLevel(Level level) {
        int value = level.intValue();
        if (value < 800) {
            if (value < 500) {
                return 2;
            }
            return 3;
        }
        if (value < 900) {
            return 4;
        }
        if (value < 1000) {
            return 5;
        }
        return 6;
    }

    static {
        boolean android = false;
        try {
            android = Class.forName("android.util.Log") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ANDROID_LOG_AVAILABLE = android;
    }
}

