/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import android.util.Log;
import java.util.logging.Level;

public interface Logger {
    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public static class SystemOutLogger
    implements Logger {
        @Override
        public void log(Level level, String msg) {
            System.out.println("[" + level + "] " + msg);
        }

        @Override
        public void log(Level level, String msg, Throwable th) {
            System.out.println("[" + level + "] " + msg);
            th.printStackTrace(System.out);
        }
    }

    public static class JavaLogger
    implements Logger {
        protected final java.util.logging.Logger logger;

        public JavaLogger(String tag) {
            this.logger = java.util.logging.Logger.getLogger(tag);
        }

        @Override
        public void log(Level level, String msg) {
            this.logger.log(level, msg);
        }

        @Override
        public void log(Level level, String msg, Throwable th) {
            this.logger.log(level, msg, th);
        }
    }

    public static class AndroidLogger
    implements Logger {
        static final boolean ANDROID_LOG_AVAILABLE;
        private final String tag;

        public static boolean isAndroidLogAvailable() {
            return ANDROID_LOG_AVAILABLE;
        }

        public AndroidLogger(String tag) {
            this.tag = tag;
        }

        @Override
        public void log(Level level, String msg) {
            if (level != Level.OFF) {
                Log.println((int)this.mapLevel(level), (String)this.tag, (String)msg);
            }
        }

        @Override
        public void log(Level level, String msg, Throwable th) {
            if (level != Level.OFF) {
                Log.println((int)this.mapLevel(level), (String)this.tag, (String)(msg + "\n" + Log.getStackTraceString((Throwable)th)));
            }
        }

        protected int mapLevel(Level level) {
            int value = level.intValue();
            if (value < 800) {
                if (value < 500) {
                    return 2;
                }
                return 3;
            }
            if (value < 900) {
                return 4;
            }
            if (value < 1000) {
                return 5;
            }
            return 6;
        }

        static {
            boolean android = false;
            try {
                android = Class.forName("android.util.Log") != null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ANDROID_LOG_AVAILABLE = android;
        }
    }
}

