/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.pool.generic;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.graylog2.syslog4j.SyslogPoolConfigIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.pool.AbstractSyslogPoolFactory;

public class GenericSyslogPoolFactory
extends AbstractSyslogPoolFactory {
    protected void configureGenericObjectPool(GenericObjectPool genericObjectPool) throws SyslogRuntimeException {
        SyslogPoolConfigIF poolConfig = null;
        try {
            poolConfig = (SyslogPoolConfigIF)((Object)this.syslog.getConfig());
        }
        catch (ClassCastException cce) {
            throw new SyslogRuntimeException("config must implement interface SyslogPoolConfigIF");
        }
        genericObjectPool.setMaxActive(poolConfig.getMaxActive());
        genericObjectPool.setMaxIdle(poolConfig.getMaxIdle());
        genericObjectPool.setMaxWait(poolConfig.getMaxWait());
        genericObjectPool.setMinEvictableIdleTimeMillis(poolConfig.getMinEvictableIdleTimeMillis());
        genericObjectPool.setMinIdle(poolConfig.getMinIdle());
        genericObjectPool.setNumTestsPerEvictionRun(poolConfig.getNumTestsPerEvictionRun());
        genericObjectPool.setSoftMinEvictableIdleTimeMillis(poolConfig.getSoftMinEvictableIdleTimeMillis());
        genericObjectPool.setTestOnBorrow(poolConfig.isTestOnBorrow());
        genericObjectPool.setTestOnReturn(poolConfig.isTestOnReturn());
        genericObjectPool.setTestWhileIdle(poolConfig.isTestWhileIdle());
        genericObjectPool.setTimeBetweenEvictionRunsMillis(poolConfig.getTimeBetweenEvictionRunsMillis());
        genericObjectPool.setWhenExhaustedAction(poolConfig.getWhenExhaustedAction());
    }

    @Override
    public ObjectPool createPool() throws SyslogRuntimeException {
        GenericObjectPool genericPool = new GenericObjectPool((PoolableObjectFactory)this);
        this.configureGenericObjectPool(genericPool);
        return genericPool;
    }
}

