/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.HSPolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotHostServices;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.HSObject;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;
import org.graalvm.word.WordFactory;

final class HSPolyglotHostServicesGen {
    HSPolyglotHostServicesGen() {
    }

    static HSPolyglotHostServices createNativeToHS(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
        return new StartPoint(jNIEnv, jObject);
    }

    private static final class StartPoint
    extends HSPolyglotHostServices {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        final JNIData jniMethods_;

        StartPoint(JNI.JNIEnv jNIEnv, JNI.JObject jObject) {
            super(jNIEnv, jObject);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        @Override
        public void attachPolyglotThread(long l2, long l3, long l4) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                jValue.addressOf(2).setLong(l3);
                jValue.addressOf(3).setLong(l4);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.attachPolyglotThreadMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public void detachPolyglotThread(long l2, long l3, long l4) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)4, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setLong(l2);
                jValue.addressOf(2).setLong(l3);
                jValue.addressOf(3).setLong(l4);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.detachPolyglotThreadMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public long retrieveHostStackOverflowLimit() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                return ForeignException.getJNICalls().callStaticLong(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.retrieveHostStackOverflowLimitMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(processHandler != null ? ((HSObject)processHandler).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isDefaultProcessHandlerMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        @Override
        public boolean isInternalFileSystem(FileSystem fileSystem) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.getHandle());
                jValue.addressOf(1).setJObject(fileSystem != null ? ((HSObject)fileSystem).getHandle() : (JNI.JObject)WordFactory.nullPointer());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isInternalFileSystemMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod attachPolyglotThreadMethod;
            final JNICalls.JNIMethod detachPolyglotThreadMethod;
            final JNICalls.JNIMethod retrieveHostStackOverflowLimitMethod;
            final JNICalls.JNIMethod isDefaultProcessHandlerMethod;
            final JNICalls.JNIMethod isInternalFileSystemMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.attachPolyglotThreadMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"attachPolyglotThread", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;JJJ)V");
                this.detachPolyglotThreadMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"detachPolyglotThread", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;JJJ)V");
                this.retrieveHostStackOverflowLimitMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"retrieveHostStackOverflowLimit", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;)J");
                this.isDefaultProcessHandlerMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isDefaultProcessHandler", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;Lorg/graalvm/polyglot/io/ProcessHandler;)Z");
                this.isInternalFileSystemMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isInternalFileSystem", (String)"(Lcom/oracle/truffle/polyglot/enterprise/PolyglotHostServices;Lorg/graalvm/polyglot/io/FileSystem;)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void attachPolyglotThread(PolyglotHostServices polyglotHostServices, long l2, long l3, long l4) {
            try {
                polyglotHostServices.attachPolyglotThread(l2, l3, l4);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void detachPolyglotThread(PolyglotHostServices polyglotHostServices, long l2, long l3, long l4) {
            try {
                polyglotHostServices.detachPolyglotThread(l2, l3, l4);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static long retrieveHostStackOverflowLimit(PolyglotHostServices polyglotHostServices) {
            try {
                long l2 = polyglotHostServices.retrieveHostStackOverflowLimit();
                return l2;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isDefaultProcessHandler(PolyglotHostServices polyglotHostServices, ProcessHandler processHandler) {
            try {
                boolean bl = polyglotHostServices.isDefaultProcessHandler(processHandler);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isInternalFileSystem(PolyglotHostServices polyglotHostServices, FileSystem fileSystem) {
            try {
                boolean bl = polyglotHostServices.isInternalFileSystem(fileSystem);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

