/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.enterprise.HSHostLanguageService;
import com.oracle.truffle.polyglot.enterprise.HSPolyglotObject;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIEntryPoint;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIClassCache;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.word.PointerBase;

final class HSHostLanguageServiceGen {
    HSHostLanguageServiceGen() {
    }

    static HSHostLanguageService createNativeToHS(HSPolyglotObject hSPolyglotObject, AbstractPolyglotImpl abstractPolyglotImpl, JNI.JNIEnv jNIEnv) {
        return new StartPoint(hSPolyglotObject, abstractPolyglotImpl, jNIEnv);
    }

    private static final class StartPoint
    extends HSHostLanguageService {
        private static final BinaryMarshaller<Error> errorMarshaller;
        private static final BinaryMarshaller<Object> objectWithHostContextMarshaller;
        private static final BinaryMarshaller<Object> objectWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Object> objectWithTruffleFileMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<Throwable> throwableWithInteropObjectMarshaller;
        final JNIData jniMethods_;

        StartPoint(HSPolyglotObject hSPolyglotObject, AbstractPolyglotImpl abstractPolyglotImpl, JNI.JNIEnv jNIEnv) {
            super(hSPolyglotObject, abstractPolyglotImpl);
            JNIData jNIData = JNIData.cache_;
            if (jNIData == null) {
                jNIData = JNIData.cache_ = new JNIData(jNIEnv);
            }
            this.jniMethods_ = jNIData;
        }

        public void throwHostLanguageException(String string) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                jValue.addressOf(1).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.throwHostLanguageExceptionMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        public void hostExit(int n2) {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                jValue.addressOf(1).setInt(n2);
                ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.hostExitMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostExceptionImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostExceptionImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostFunctionImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostFunctionImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostObjectImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostObjectImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostSymbolImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostSymbolImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        boolean isHostProxyImpl(Object object) {
            boolean bl;
            block15: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithInteropObjectMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int bl2 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)bl2);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)bl2, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    bl = ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.isHostProxyImplMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    if (cCharPointer == cCharPointer2) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object findStaticClass(Object object, String string) {
            Object object2;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = objectWithHostContextMarshaller.inferSize(object);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)3, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)JNIUtil.createHSString((JNI.JNIEnv)jNIEnv, (String)string));
                    cCharPointerBinaryOutput.addressOf(2).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.findStaticClassMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    object2 = objectWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return object2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createHostAdapter(Object object, Object[] objectArray, Object object2) {
            Object object32;
            block20: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)768);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + 4 + (objectArray != null && objectArray.length > 0 ? objectArray.length * objectWithInteropObjectMarshaller.inferSize(objectArray[0]) : 0) + objectWithInteropObjectMarshaller.inferSize(object2);
                if (n3 > 768) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 768;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        if (objectArray != null) {
                            cCharPointerBinaryOutput.writeInt(objectArray.length);
                            for (Object object32 : objectArray) {
                                objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object32);
                            }
                        } else {
                            cCharPointerBinaryOutput.writeInt(-1);
                        }
                        objectWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object2);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.createHostAdapterMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    object32 = objectWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return object32;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public void addToHostClassPath(Object object, Object object2) {
            try {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + objectWithTruffleFileMarshaller.inferSize(object2);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        objectWithTruffleFileMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object2);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    ForeignException.getJNICalls().callStaticVoid(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.addToHostClassPathMethod, (JNI.JValue)cCharPointerBinaryOutput);
                }
                finally {
                    if (cCharPointer != cCharPointer2) {
                        UnmanagedMemory.free((PointerBase)cCharPointer);
                    }
                }
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public RuntimeException toHostException(Object object, Throwable throwable) {
            RuntimeException runtimeException;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)512);
                int n3 = objectWithHostContextMarshaller.inferSize(object) + throwableMarshaller.inferSize((Object)throwable);
                if (n3 > 512) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 512;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        objectWithHostContextMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, object);
                        throwableMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)throwable);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHostExceptionMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    runtimeException = (RuntimeException)runtimeExceptionWithInteropObjectMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable2;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return runtimeException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Error toHostResourceError(Throwable throwable) {
            Error error;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = throwableWithInteropObjectMarshaller.inferSize((Object)throwable);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        throwableWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)throwable);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.toHostResourceErrorMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    error = (Error)errorMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable2) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable2;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Throwable unboxHostException(Throwable throwable) {
            Throwable throwable2;
            block17: {
                int n2;
                CCharPointer cCharPointer;
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                CCharPointer cCharPointer2 = (CCharPointer)StackValue.get((int)256);
                int n3 = throwableWithInteropObjectMarshaller.inferSize((Object)throwable);
                if (n3 > 256) {
                    cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n3);
                    n2 = n3;
                } else {
                    cCharPointer = cCharPointer2;
                    n2 = 256;
                }
                try {
                    JNI.JByteArray jByteArray;
                    try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = BinaryOutput.create((CCharPointer)cCharPointer, (int)n2, (boolean)false);){
                        throwableWithInteropObjectMarshaller.write((BinaryOutput)cCharPointerBinaryOutput, (Object)throwable);
                        int n4 = cCharPointerBinaryOutput.getPosition();
                        jByteArray = JNIUtil.NewByteArray((JNI.JNIEnv)jNIEnv, (int)n4);
                        JNIUtil.SetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n4, (CCharPointer)cCharPointerBinaryOutput.getAddress());
                    }
                    cCharPointerBinaryOutput = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
                    cCharPointerBinaryOutput.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                    cCharPointerBinaryOutput.addressOf(1).setJObject((JNI.JObject)jByteArray);
                    JNI.JByteArray jByteArray2 = (JNI.JByteArray)ForeignException.getJNICalls().callStaticJObject(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.unboxHostExceptionMethod, (JNI.JValue)cCharPointerBinaryOutput);
                    int n5 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray2);
                    if (n2 < n5) {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        cCharPointer = (CCharPointer)UnmanagedMemory.malloc((int)n5);
                    }
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray2, (int)0, (int)n5, (CCharPointer)cCharPointer);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer, (int)n5);
                    throwable2 = (Throwable)throwableMarshaller.read(binaryInput);
                    if (cCharPointer == cCharPointer2) break block17;
                }
                catch (Throwable throwable3) {
                    try {
                        if (cCharPointer != cCharPointer2) {
                            UnmanagedMemory.free((PointerBase)cCharPointer);
                        }
                        throw throwable3;
                    }
                    catch (ForeignException foreignException) {
                        throw foreignException.throwOriginalException(throwableMarshaller);
                    }
                }
                UnmanagedMemory.free((PointerBase)cCharPointer);
            }
            return throwable2;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean allowsPublicAccess() {
            try {
                JNI.JNIEnv jNIEnv = JNIMethodScope.env();
                JNI.JValue jValue = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
                jValue.addressOf(0).setJObject(this.hostServiceEndpoint.getHandle());
                return ForeignException.getJNICalls().callStaticBoolean(jNIEnv, this.jniMethods_.endPointClass, this.jniMethods_.allowsPublicAccessMethod, jValue);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            errorMarshaller = jNIConfig.lookupMarshaller(Error.class, new Class[0]);
            objectWithHostContextMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.HostContext.class});
            objectWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
            objectWithTruffleFileMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.TruffleFile.class});
            runtimeExceptionWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            throwableWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
        }

        static final class JNIData {
            static JNIData cache_;
            final JNI.JClass endPointClass;
            final JNICalls.JNIMethod throwHostLanguageExceptionMethod;
            final JNICalls.JNIMethod hostExitMethod;
            final JNICalls.JNIMethod isHostExceptionImplMethod;
            final JNICalls.JNIMethod isHostFunctionImplMethod;
            final JNICalls.JNIMethod isHostObjectImplMethod;
            final JNICalls.JNIMethod isHostSymbolImplMethod;
            final JNICalls.JNIMethod isHostProxyImplMethod;
            final JNICalls.JNIMethod findStaticClassMethod;
            final JNICalls.JNIMethod createHostAdapterMethod;
            final JNICalls.JNIMethod addToHostClassPathMethod;
            final JNICalls.JNIMethod toHostExceptionMethod;
            final JNICalls.JNIMethod toHostResourceErrorMethod;
            final JNICalls.JNIMethod unboxHostExceptionMethod;
            final JNICalls.JNIMethod allowsPublicAccessMethod;

            JNIData(JNI.JNIEnv jNIEnv) {
                this.endPointClass = JNIClassCache.lookupClass((JNI.JNIEnv)jNIEnv, EndPoint.class);
                this.throwHostLanguageExceptionMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"throwHostLanguageException", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;Ljava/lang/String;)V");
                this.hostExitMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"hostExit", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;I)V");
                this.isHostExceptionImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isHostExceptionImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostFunctionImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isHostFunctionImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostObjectImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isHostObjectImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostSymbolImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isHostSymbolImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.isHostProxyImplMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"isHostProxyImpl", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)Z");
                this.findStaticClassMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"findStaticClass", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;Ljava/lang/String;[B)[B");
                this.createHostAdapterMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"createHostAdapter", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.addToHostClassPathMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"addToHostClassPath", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)V");
                this.toHostExceptionMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"toHostException", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.toHostResourceErrorMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"toHostResourceError", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.unboxHostExceptionMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"unboxHostException", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;[B)[B");
                this.allowsPublicAccessMethod = JNICalls.JNIMethod.findMethod((JNI.JNIEnv)jNIEnv, (JNI.JClass)this.endPointClass, (boolean)true, (String)"allowsPublicAccess", (String)"(Lorg/graalvm/polyglot/impl/AbstractPolyglotImpl$AbstractHostLanguageService;)Z");
            }
        }
    }

    private static class EndPoint {
        private static final BinaryMarshaller<Error> errorMarshaller;
        private static final BinaryMarshaller<Object> objectWithHostContextMarshaller;
        private static final BinaryMarshaller<Object> objectWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Object> objectWithTruffleFileMarshaller;
        private static final BinaryMarshaller<RuntimeException> runtimeExceptionWithInteropObjectMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;
        private static final BinaryMarshaller<Throwable> throwableWithInteropObjectMarshaller;

        private EndPoint() {
        }

        @JNIEntryPoint
        static void throwHostLanguageException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, String string) {
            try {
                abstractHostLanguageService.throwHostLanguageException(string);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void hostExit(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, int n2) {
            try {
                abstractHostLanguageService.hostExit(n2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostExceptionImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostException(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostFunctionImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostFunction(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostObjectImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostObject(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostSymbolImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostSymbol(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean isHostProxyImpl(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithInteropObjectMarshaller.read(binaryInput);
                boolean bl = abstractHostLanguageService.isHostProxy(object);
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] findStaticClass(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, String string, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Object object2 = abstractHostLanguageService.findStaticClass(object, string);
                int n2 = objectWithInteropObjectMarshaller.inferSize(object2);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                objectWithInteropObjectMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] createHostAdapter(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                Object object;
                int n2;
                Object object2;
                Object[] objectArray;
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object3 = objectWithHostContextMarshaller.read(binaryInput);
                int n3 = binaryInput.readInt();
                if (n3 != -1) {
                    objectArray = new Object[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        objectArray[i2] = object2 = objectWithInteropObjectMarshaller.read(binaryInput);
                    }
                } else {
                    objectArray = null;
                }
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = (n2 = objectWithInteropObjectMarshaller.inferSize(object2 = abstractHostLanguageService.createHostAdapter(object3, objectArray, object = objectWithInteropObjectMarshaller.read(binaryInput)))) > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                objectWithInteropObjectMarshaller.write((BinaryOutput)byteArrayBinaryOutput, object2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static void addToHostClassPath(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Object object2 = objectWithTruffleFileMarshaller.read(binaryInput);
                abstractHostLanguageService.addToHostClassPath(object, object2);
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHostException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Object object = objectWithHostContextMarshaller.read(binaryInput);
                Throwable throwable = (Throwable)throwableMarshaller.read(binaryInput);
                RuntimeException runtimeException = abstractHostLanguageService.toHostException(object, throwable);
                int n2 = runtimeExceptionWithInteropObjectMarshaller.inferSize((Object)runtimeException);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                runtimeExceptionWithInteropObjectMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)runtimeException);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] toHostResourceError(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Throwable throwable = (Throwable)throwableWithInteropObjectMarshaller.read(binaryInput);
                Error error = abstractHostLanguageService.toHostResourceError(throwable);
                int n2 = errorMarshaller.inferSize((Object)error);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                errorMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)error);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static byte[] unboxHostException(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService, byte[] byArray) {
            try {
                BinaryInput binaryInput = BinaryInput.create((byte[])byArray);
                Throwable throwable = (Throwable)throwableWithInteropObjectMarshaller.read(binaryInput);
                Throwable throwable2 = abstractHostLanguageService.unboxHostException(throwable);
                int n2 = throwableMarshaller.inferSize((Object)throwable2);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = n2 > byArray.length ? BinaryOutput.ByteArrayBinaryOutput.create((int)n2) : BinaryOutput.create((byte[])byArray);
                throwableMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)throwable2);
                return byteArrayBinaryOutput.getArray();
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        @JNIEntryPoint
        static boolean allowsPublicAccess(AbstractPolyglotImpl.AbstractHostLanguageService abstractHostLanguageService) {
            try {
                boolean bl = abstractHostLanguageService.allowsPublicAccess();
                return bl;
            }
            catch (Throwable throwable) {
                throw ForeignException.forThrowable((Throwable)throwable, throwableMarshaller);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            errorMarshaller = jNIConfig.lookupMarshaller(Error.class, new Class[0]);
            objectWithHostContextMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.HostContext.class});
            objectWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
            objectWithTruffleFileMarshaller = jNIConfig.lookupMarshaller(Object.class, new Class[]{PolyglotJNIConfig.TruffleFile.class});
            runtimeExceptionWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(RuntimeException.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
            throwableWithInteropObjectMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[]{PolyglotJNIConfig.InteropObject.class});
        }
    }
}

