/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedProfile;
import com.oracle.truffle.api.profiles.Profile;

public final class InlinedBranchProfile
extends InlinedProfile {
    private static final InlinedBranchProfile DISABLED;
    private static final int REQUIRED_STATE_BITS = 1;
    private final InlineSupport.StateField state;

    private InlinedBranchProfile() {
        this.state = null;
    }

    private InlinedBranchProfile(InlineSupport.InlineTarget target) {
        this.state = target.getState(0, 1);
    }

    public void enter(Node node) {
        if (this.state == null) {
            return;
        }
        int s = this.state.get(node);
        if (s == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.state.set(node, 1);
        }
    }

    public boolean wasEntered(Node node) {
        if (this.state == null) {
            return true;
        }
        return this.state.get(node) != 0;
    }

    @Override
    public void reset(Node node) {
        if (this.state == null) {
            return;
        }
        this.state.set(node, 0);
    }

    @Override
    public void disable(Node node) {
        if (this.state == null) {
            return;
        }
        this.state.set(node, 1);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(InlinedBranchProfile.class, this.state.get(node) == 0, false, "VISITED");
    }

    boolean isGeneric(Node node) {
        if (this.state == null) {
            return true;
        }
        return this.state.get(node) == 1;
    }

    boolean isUninitialized(Node node) {
        if (this.state == null) {
            return false;
        }
        return this.state.get(node) == 0;
    }

    public static InlinedBranchProfile inline(@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=1) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedBranchProfile(target);
        }
        return InlinedBranchProfile.getUncached();
    }

    public static InlinedBranchProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedBranchProfile profile;
        DISABLED = profile = new InlinedBranchProfile();
    }
}

