/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.Encodings;
import com.oracle.truffle.api.strings.IndexOfCodePointSet;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.InternalErrors;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.MutableTruffleString;
import com.oracle.truffle.api.strings.NativeAllocator;
import com.oracle.truffle.api.strings.NumberConversion;
import com.oracle.truffle.api.strings.Stride;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringConstants;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringInternalNodesFactory;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TStringUnsafe;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleStringFactory;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.BitSet;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public final class TruffleString
extends AbstractTruffleString {
    private static final VarHandle NEXT_UPDATER = TruffleString.initializeNextUpdater();
    private static final byte FLAG_CACHE_HEAD = -128;
    TruffleString next;

    @CompilerDirectives.TruffleBoundary
    private static VarHandle initializeNextUpdater() {
        try {
            return MethodHandles.lookup().findVarHandle(TruffleString.class, "next", TruffleString.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private TruffleString(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        super(data, offset, length, stride, encoding, isCacheHead ? -128 : 0, codePointLength, codeRange);
    }

    private static TruffleString create(Object data, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        TruffleString string = new TruffleString(data, offset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        if (AbstractTruffleString.DEBUG_ALWAYS_CREATE_JAVA_STRING) {
            string.toJavaStringUncached();
        }
        return string;
    }

    static TruffleString createFromByteArray(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createFromByteArray(bytes, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createFromByteArray(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        return TruffleString.createFromArray(bytes, 0, length, stride, encoding, codePointLength, codeRange, isCacheHead);
    }

    static TruffleString createFromArray(Object bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createFromArray(bytes, offset, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createFromArray(Object bytes, int offset, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        assert (bytes instanceof byte[] || TStringGuards.isInlinedJavaString(bytes) || bytes instanceof AbstractTruffleString.NativePointer);
        assert (offset >= 0);
        assert (bytes instanceof AbstractTruffleString.NativePointer || (long)offset + ((long)length << stride) <= TStringOps.byteLength(bytes));
        assert (TruffleString.attrsAreCorrect(bytes, encoding, offset, length, codePointLength, codeRange, stride));
        if (DEBUG_NON_ZERO_OFFSET && bytes instanceof byte[]) {
            int byteLength;
            int add = byteLength = Math.toIntExact((long)length << stride);
            byte[] copy = new byte[add + byteLength];
            System.arraycopy(bytes, offset, copy, add, byteLength);
            return TruffleString.create(copy, add, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        }
        return TruffleString.create(bytes, offset, length, stride, encoding, codePointLength, codeRange, isCacheHead);
    }

    static TruffleString createConstant(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange) {
        return TruffleString.createConstant(bytes, length, stride, encoding, codePointLength, codeRange, true);
    }

    static TruffleString createConstant(byte[] bytes, int length, int stride, Encoding encoding, int codePointLength, int codeRange, boolean isCacheHead) {
        TruffleString ret = TruffleString.createFromByteArray(bytes, length, stride, encoding, codePointLength, codeRange, isCacheHead);
        ret.hashCode();
        return ret;
    }

    static TruffleString createLazyLong(long value, Encoding encoding) {
        int length = NumberConversion.stringLengthLong(value);
        return TruffleString.create(new AbstractTruffleString.LazyLong(value), 0, length, 0, encoding, length, TSCodeRange.get7Bit(), true);
    }

    static TruffleString createLazyConcat(TruffleString a, TruffleString b, Encoding encoding, int length, int stride, int codeRange) {
        assert (!TSCodeRange.isBrokenMultiByte(a.codeRange()));
        assert (!TSCodeRange.isBrokenMultiByte(b.codeRange()));
        assert (a.isLooselyCompatibleTo(encoding));
        assert (b.isLooselyCompatibleTo(encoding));
        assert (length == a.length() + b.length());
        return TruffleString.create(new AbstractTruffleString.LazyConcat(a, b), 0, length, stride, encoding, a.codePointLength() + b.codePointLength(), codeRange, true);
    }

    static TruffleString createWrapJavaString(String str, int codePointLength, int codeRange) {
        int stride = TStringUnsafe.getJavaStringStride(str);
        return TruffleString.create(str, 0, str.length(), stride, Encoding.UTF_16, codePointLength, codeRange, false);
    }

    private static boolean attrsAreCorrect(Object bytes, Encoding encoding, int offset, int length, int codePointLength, int codeRange, int stride) {
        CompilerAsserts.neverPartOfCompilation();
        int knownCodeRange = TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id);
        if (TStringGuards.isUTF16Or32(encoding) && stride == 0) {
            knownCodeRange = TSCodeRange.get8Bit();
        } else if (TStringGuards.isUTF32(encoding) && stride == 1) {
            knownCodeRange = TSCodeRange.get16Bit();
        }
        if (bytes instanceof AbstractTruffleString.NativePointer) {
            ((AbstractTruffleString.NativePointer)bytes).materializeByteArray(null, offset, length << stride, InlinedConditionProfile.getUncached());
        }
        long attrs = TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached().execute(TStringInternalNodesFactory.CalcStringAttributesNodeGen.getUncached(), null, bytes, offset, length, stride, encoding, 0, knownCodeRange);
        int cpLengthCalc = StringAttributes.getCodePointLength(attrs);
        int codeRangeCalc = StringAttributes.getCodeRange(attrs);
        assert (codePointLength == -1 || cpLengthCalc == codePointLength) : "inconsistent codePointLength: " + cpLengthCalc + " != " + codePointLength;
        if (TSCodeRange.isPrecise(codeRange)) {
            assert (codeRangeCalc == codeRange) : "inconsistent codeRange: " + TSCodeRange.toString(codeRangeCalc) + " != " + TSCodeRange.toString(codeRange);
        } else assert (TSCodeRange.isMoreRestrictiveOrEqual(codeRangeCalc, codeRange)) : "imprecise codeRange more restrictive than actual codeRange: " + TSCodeRange.toString(codeRangeCalc) + " > " + TSCodeRange.toString(codeRange);
        return true;
    }

    boolean isCacheHead() {
        assert ((this.flags() & 0xFFFFFF80) != 0 == this.flags() < 0);
        return this.flags() < 0;
    }

    TruffleString getCacheHead() {
        assert (this.cacheRingIsValid());
        TruffleString cur = this.next;
        if (cur == null) {
            assert (this.isCacheHead());
            return this;
        }
        while (!cur.isCacheHead()) {
            cur = cur.next;
        }
        return cur;
    }

    @CompilerDirectives.TruffleBoundary
    void cacheInsert(TruffleString entry) {
        TruffleString cacheHeadNext;
        assert (!entry.isCacheHead());
        TruffleString cacheHead = this.getCacheHead();
        assert (!TruffleString.cacheEntryEquals(cacheHead, entry));
        do {
            if (TruffleString.hasDuplicateEncoding(cacheHead, cacheHeadNext = cacheHead.next, entry)) {
                return;
            }
            TruffleString truffleString = entry.next = cacheHeadNext == null ? cacheHead : cacheHeadNext;
        } while (!TruffleString.setNextAtomic(cacheHead, cacheHeadNext, entry));
    }

    void cacheInsertFirstBeforePublished(TruffleString entry) {
        TruffleString cacheHead;
        assert (!entry.isCacheHead());
        assert (this.isCacheHead());
        assert (this.next == null);
        entry.next = cacheHead = this;
        cacheHead.next = entry;
    }

    private static boolean hasDuplicateEncoding(TruffleString cacheHead, TruffleString start, TruffleString insertEntry) {
        if (start == null) {
            return false;
        }
        TruffleString current = start;
        while (current != cacheHead) {
            if (TruffleString.cacheEntryEquals(insertEntry, current)) {
                return true;
            }
            current = current.next;
        }
        return false;
    }

    private static boolean cacheEntryEquals(TruffleString a, TruffleString b) {
        return b.encoding() == a.encoding() && a.isNative() == b.isNative() && a.stride() == b.stride() && (!TStringGuards.isUTF16(a.encoding()) || b.isJavaString() == a.isJavaString());
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean setNextAtomic(TruffleString cacheHead, TruffleString currentNext, TruffleString newNext) {
        return NEXT_UPDATER.compareAndSet(cacheHead, currentNext, newNext);
    }

    private boolean cacheRingIsValid() {
        CompilerAsserts.neverPartOfCompilation();
        TruffleString head = null;
        TruffleString cur = this;
        boolean javaStringVisited = false;
        BitSet visitedManaged = new BitSet(Encoding.values().length);
        BitSet visitedNativeRegular = new BitSet(Encoding.values().length);
        BitSet visitedNativeCompact = new BitSet(Encoding.values().length);
        EconomicSet visited = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        do {
            if (cur.isCacheHead()) {
                assert (head == null) : "multiple cache heads";
                head = cur;
            }
            if (cur.isJavaString()) {
                assert (!javaStringVisited) : "duplicate cached java string";
                javaStringVisited = true;
            } else {
                Encoding encoding = Encoding.get(cur.encoding());
                if (cur.isManaged()) {
                    assert (!visitedManaged.get(cur.encoding())) : "duplicate managed " + encoding;
                    visitedManaged.set(cur.encoding());
                } else if (cur.stride() == encoding.naturalStride) {
                    assert (!visitedNativeRegular.get(cur.encoding())) : "duplicate native " + encoding;
                    visitedNativeRegular.set(cur.encoding());
                } else {
                    assert (!visitedNativeCompact.get(cur.encoding())) : "duplicate compact native " + encoding;
                    visitedNativeCompact.set(cur.encoding());
                }
            }
            assert (visited.add((Object)cur)) : "not a ring structure";
        } while ((cur = cur.next) != this && cur != null);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCodePointUncached(int codepoint, Encoding encoding) {
        return FromCodePointNode.getUncached().execute(codepoint, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCodePointUncached(int codepoint, Encoding encoding, boolean allowUTF16Surrogates) {
        return FromCodePointNode.getUncached().execute(codepoint, encoding, allowUTF16Surrogates);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromLongUncached(long value, Encoding encoding, boolean lazy) {
        return FromLongNode.getUncached().execute(value, encoding, lazy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, Encoding encoding) {
        return FromByteArrayNode.getUncached().execute(value, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromByteArrayUncached(byte[] value, int byteOffset, int byteLength, Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCharArrayUTF16Uncached(char[] value) {
        return FromCharArrayUTF16Node.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromCharArrayUTF16Uncached(char[] value, int charOffset, int charLength) {
        return FromCharArrayUTF16Node.getUncached().execute(value, charOffset, charLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromJavaStringUncached(String s, Encoding encoding) {
        return FromJavaStringNode.getUncached().execute(s, encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromJavaStringUncached(String s, int charOffset, int length, Encoding encoding, boolean copy) {
        return FromJavaStringNode.getUncached().execute(s, charOffset, length, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromConstant(String s, Encoding encoding) {
        TruffleString string = FromJavaStringNode.getUncached().execute(s, 0, s.length(), encoding, false);
        string.getCodeRangeUncached(encoding);
        string.hashCodeUncached(encoding);
        return string;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromIntArrayUTF32Uncached(int[] value) {
        return FromIntArrayUTF32Node.getUncached().execute(value);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromIntArrayUTF32Uncached(int[] value, int intOffset, int intLength) {
        return FromIntArrayUTF32Node.getUncached().execute(value, intOffset, intLength);
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString fromNativePointerUncached(Object pointerObject, int byteOffset, int byteLength, Encoding encoding, boolean copy) {
        return FromNativePointerNode.getUncached().execute(pointerObject, byteOffset, byteLength, encoding, copy);
    }

    private static boolean noneIsAscii(Node location, byte[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (Byte.toUnsignedInt(values[i]) <= 127) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean noneInCodeRange(Node location, int codeRange, char[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (TSCodeRange.isInCodeRange(values[i], codeRange)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    private static boolean noneInCodeRange(Node location, int codeRange, int[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (TSCodeRange.isInCodeRange(values[i], codeRange)) {
                return false;
            }
            TStringConstants.truffleSafePointPoll(location, i + 1);
        }
        return true;
    }

    public TruffleString asNativeUncached(NativeAllocator allocator, Encoding expectedEncoding, boolean useCompaction, boolean cacheResult) {
        return AsNativeNode.getUncached().execute(this, allocator, expectedEncoding, useCompaction, cacheResult);
    }

    public static final class Encoding
    extends Enum<Encoding> {
        public static final /* enum */ Encoding UTF_32LE = new Encoding(TStringGuards.littleEndian() ? 0 : 99, "UTF_32LE", TStringGuards.littleEndian() ? 2 : 0, TStringGuards.littleEndian());
        public static final /* enum */ Encoding UTF_32BE = new Encoding(TStringGuards.littleEndian() ? 99 : 0, "UTF_32BE", TStringGuards.littleEndian() ? 0 : 2, TStringGuards.bigEndian());
        public static final /* enum */ Encoding UTF_16LE = new Encoding(TStringGuards.littleEndian() ? 1 : 100, "UTF_16LE", TStringGuards.littleEndian() ? 1 : 0, false);
        public static final /* enum */ Encoding UTF_16BE = new Encoding(TStringGuards.littleEndian() ? 100 : 1, "UTF_16BE", TStringGuards.littleEndian() ? 0 : 1, false);
        public static final /* enum */ Encoding ISO_8859_1 = new Encoding(2, "ISO_8859_1", 0, true);
        public static final /* enum */ Encoding UTF_8 = new Encoding(3, "UTF_8", 0, false);
        public static final /* enum */ Encoding US_ASCII = new Encoding(4, "US_ASCII", 0, true);
        public static final /* enum */ Encoding BYTES = new Encoding(5, "BYTES", 0, true);
        public static final /* enum */ Encoding Big5 = new Encoding(6, "Big5");
        public static final /* enum */ Encoding Big5_HKSCS = new Encoding(7, "Big5_HKSCS");
        public static final /* enum */ Encoding Big5_UAO = new Encoding(8, "Big5_UAO");
        public static final /* enum */ Encoding CESU_8 = new Encoding(9, "CESU_8");
        public static final /* enum */ Encoding CP51932 = new Encoding(10, "CP51932");
        public static final /* enum */ Encoding CP850 = new Encoding(11, "CP850");
        public static final /* enum */ Encoding CP852 = new Encoding(12, "CP852");
        public static final /* enum */ Encoding CP855 = new Encoding(13, "CP855");
        public static final /* enum */ Encoding CP949 = new Encoding(14, "CP949");
        public static final /* enum */ Encoding CP950 = new Encoding(15, "CP950");
        public static final /* enum */ Encoding CP951 = new Encoding(16, "CP951");
        public static final /* enum */ Encoding EUC_JIS_2004 = new Encoding(17, "EUC_JIS_2004");
        public static final /* enum */ Encoding EUC_JP = new Encoding(18, "EUC_JP");
        public static final /* enum */ Encoding EUC_KR = new Encoding(19, "EUC_KR");
        public static final /* enum */ Encoding EUC_TW = new Encoding(20, "EUC_TW");
        public static final /* enum */ Encoding Emacs_Mule = new Encoding(21, "Emacs_Mule");
        public static final /* enum */ Encoding EucJP_ms = new Encoding(22, "EucJP_ms");
        public static final /* enum */ Encoding GB12345 = new Encoding(23, "GB12345");
        public static final /* enum */ Encoding GB18030 = new Encoding(24, "GB18030");
        public static final /* enum */ Encoding GB1988 = new Encoding(25, "GB1988");
        public static final /* enum */ Encoding GB2312 = new Encoding(26, "GB2312");
        public static final /* enum */ Encoding GBK = new Encoding(27, "GBK");
        public static final /* enum */ Encoding IBM437 = new Encoding(28, "IBM437");
        public static final /* enum */ Encoding IBM720 = new Encoding(29, "IBM720");
        public static final /* enum */ Encoding IBM737 = new Encoding(30, "IBM737");
        public static final /* enum */ Encoding IBM775 = new Encoding(31, "IBM775");
        public static final /* enum */ Encoding IBM852 = new Encoding(32, "IBM852");
        public static final /* enum */ Encoding IBM855 = new Encoding(33, "IBM855");
        public static final /* enum */ Encoding IBM857 = new Encoding(34, "IBM857");
        public static final /* enum */ Encoding IBM860 = new Encoding(35, "IBM860");
        public static final /* enum */ Encoding IBM861 = new Encoding(36, "IBM861");
        public static final /* enum */ Encoding IBM862 = new Encoding(37, "IBM862");
        public static final /* enum */ Encoding IBM863 = new Encoding(38, "IBM863");
        public static final /* enum */ Encoding IBM864 = new Encoding(39, "IBM864");
        public static final /* enum */ Encoding IBM865 = new Encoding(40, "IBM865");
        public static final /* enum */ Encoding IBM866 = new Encoding(41, "IBM866");
        public static final /* enum */ Encoding IBM869 = new Encoding(42, "IBM869");
        public static final /* enum */ Encoding ISO_8859_10 = new Encoding(43, "ISO_8859_10");
        public static final /* enum */ Encoding ISO_8859_11 = new Encoding(44, "ISO_8859_11");
        public static final /* enum */ Encoding ISO_8859_13 = new Encoding(45, "ISO_8859_13");
        public static final /* enum */ Encoding ISO_8859_14 = new Encoding(46, "ISO_8859_14");
        public static final /* enum */ Encoding ISO_8859_15 = new Encoding(47, "ISO_8859_15");
        public static final /* enum */ Encoding ISO_8859_16 = new Encoding(48, "ISO_8859_16");
        public static final /* enum */ Encoding ISO_8859_2 = new Encoding(49, "ISO_8859_2");
        public static final /* enum */ Encoding ISO_8859_3 = new Encoding(50, "ISO_8859_3");
        public static final /* enum */ Encoding ISO_8859_4 = new Encoding(51, "ISO_8859_4");
        public static final /* enum */ Encoding ISO_8859_5 = new Encoding(52, "ISO_8859_5");
        public static final /* enum */ Encoding ISO_8859_6 = new Encoding(53, "ISO_8859_6");
        public static final /* enum */ Encoding ISO_8859_7 = new Encoding(54, "ISO_8859_7");
        public static final /* enum */ Encoding ISO_8859_8 = new Encoding(55, "ISO_8859_8");
        public static final /* enum */ Encoding ISO_8859_9 = new Encoding(56, "ISO_8859_9");
        public static final /* enum */ Encoding KOI8_R = new Encoding(57, "KOI8_R");
        public static final /* enum */ Encoding KOI8_U = new Encoding(58, "KOI8_U");
        public static final /* enum */ Encoding MacCentEuro = new Encoding(59, "MacCentEuro");
        public static final /* enum */ Encoding MacCroatian = new Encoding(60, "MacCroatian");
        public static final /* enum */ Encoding MacCyrillic = new Encoding(61, "MacCyrillic");
        public static final /* enum */ Encoding MacGreek = new Encoding(62, "MacGreek");
        public static final /* enum */ Encoding MacIceland = new Encoding(63, "MacIceland");
        public static final /* enum */ Encoding MacJapanese = new Encoding(64, "MacJapanese");
        public static final /* enum */ Encoding MacRoman = new Encoding(65, "MacRoman");
        public static final /* enum */ Encoding MacRomania = new Encoding(66, "MacRomania");
        public static final /* enum */ Encoding MacThai = new Encoding(67, "MacThai");
        public static final /* enum */ Encoding MacTurkish = new Encoding(68, "MacTurkish");
        public static final /* enum */ Encoding MacUkraine = new Encoding(69, "MacUkraine");
        public static final /* enum */ Encoding SJIS_DoCoMo = new Encoding(70, "SJIS_DoCoMo");
        public static final /* enum */ Encoding SJIS_KDDI = new Encoding(71, "SJIS_KDDI");
        public static final /* enum */ Encoding SJIS_SoftBank = new Encoding(72, "SJIS_SoftBank");
        public static final /* enum */ Encoding Shift_JIS = new Encoding(73, "Shift_JIS");
        public static final /* enum */ Encoding Stateless_ISO_2022_JP = new Encoding(74, "Stateless_ISO_2022_JP");
        public static final /* enum */ Encoding Stateless_ISO_2022_JP_KDDI = new Encoding(75, "Stateless_ISO_2022_JP_KDDI");
        public static final /* enum */ Encoding TIS_620 = new Encoding(76, "TIS_620");
        public static final /* enum */ Encoding UTF8_DoCoMo = new Encoding(77, "UTF8_DoCoMo");
        public static final /* enum */ Encoding UTF8_KDDI = new Encoding(78, "UTF8_KDDI");
        public static final /* enum */ Encoding UTF8_MAC = new Encoding(79, "UTF8_MAC");
        public static final /* enum */ Encoding UTF8_SoftBank = new Encoding(80, "UTF8_SoftBank");
        public static final /* enum */ Encoding Windows_1250 = new Encoding(81, "Windows_1250");
        public static final /* enum */ Encoding Windows_1251 = new Encoding(82, "Windows_1251");
        public static final /* enum */ Encoding Windows_1252 = new Encoding(83, "Windows_1252");
        public static final /* enum */ Encoding Windows_1253 = new Encoding(84, "Windows_1253");
        public static final /* enum */ Encoding Windows_1254 = new Encoding(85, "Windows_1254");
        public static final /* enum */ Encoding Windows_1255 = new Encoding(86, "Windows_1255");
        public static final /* enum */ Encoding Windows_1256 = new Encoding(87, "Windows_1256");
        public static final /* enum */ Encoding Windows_1257 = new Encoding(88, "Windows_1257");
        public static final /* enum */ Encoding Windows_1258 = new Encoding(89, "Windows_1258");
        public static final /* enum */ Encoding Windows_31J = new Encoding(90, "Windows_31J");
        public static final /* enum */ Encoding Windows_874 = new Encoding(91, "Windows_874");
        public static final /* enum */ Encoding CP50220 = new Encoding(92, "CP50220");
        public static final /* enum */ Encoding CP50221 = new Encoding(93, "CP50221");
        public static final /* enum */ Encoding IBM037 = new Encoding(94, "IBM037");
        public static final /* enum */ Encoding ISO_2022_JP = new Encoding(95, "ISO_2022_JP");
        public static final /* enum */ Encoding ISO_2022_JP_2 = new Encoding(96, "ISO_2022_JP_2");
        public static final /* enum */ Encoding ISO_2022_JP_KDDI = new Encoding(97, "ISO_2022_JP_KDDI");
        public static final /* enum */ Encoding UTF_7 = new Encoding(98, "UTF_7");
        public static final Encoding UTF_32;
        public static final Encoding UTF_16;
        final byte id;
        final String name;
        final JCodings.Encoding jCoding;
        final byte maxCompatibleCodeRange;
        final byte naturalStride;
        final boolean fixedWidth;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final Encoding[] ENCODINGS_TABLE;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final JCodings.Encoding[] J_CODINGS_TABLE;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final byte[] MAX_COMPATIBLE_CODE_RANGE;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final TruffleString[] EMPTY_STRINGS;
        private static final EconomicMap<String, Encoding> J_CODINGS_NAME_MAP;
        private static final /* synthetic */ Encoding[] $VALUES;

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String name) {
            return Enum.valueOf(Encoding.class, name);
        }

        private Encoding(int id, String name) {
            this(id, name, 0, JCodings.ENABLED && JCodings.getInstance().isFixedWidth(JCodings.getInstance().get(name)));
        }

        private Encoding(int id, String name, int naturalStride, boolean fixedWidth) {
            assert (id <= 127);
            assert (Stride.isStride(naturalStride));
            this.id = (byte)id;
            this.name = name;
            JCodings.Encoding encoding = this.jCoding = JCodings.ENABLED ? JCodings.getInstance().get(name) : null;
            this.maxCompatibleCodeRange = this.is16BitCompatible() ? (byte)(TSCodeRange.get16Bit() + 1) : (this.is8BitCompatible() ? (byte)(TSCodeRange.get8Bit() + 1) : (this.is7BitCompatible() ? (byte)(TSCodeRange.get7Bit() + 1) : (byte)0));
            this.naturalStride = (byte)naturalStride;
            this.fixedWidth = fixedWidth;
        }

        private static TruffleString createEmpty(Encoding encoding) {
            if (encoding.is7BitCompatible() && !AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS || encoding == US_ASCII) {
                return EMPTY_STRINGS[Encoding.US_ASCII.id];
            }
            TruffleString ret = TruffleString.createConstant(new byte[0], 0, 0, encoding, 0, TSCodeRange.getAsciiCodeRange(encoding), false);
            EMPTY_STRINGS[Encoding.US_ASCII.id].cacheInsert(ret);
            return ret;
        }

        public TruffleString getEmpty() {
            return EMPTY_STRINGS[this.id];
        }

        @CompilerDirectives.TruffleBoundary
        public static Encoding fromJCodingName(String name) {
            Encoding encoding = (Encoding)((Object)J_CODINGS_NAME_MAP.get((Object)name, null));
            if (encoding == null) {
                throw InternalErrors.unknownEncoding(name);
            }
            return encoding;
        }

        static Encoding get(int encoding) {
            return ENCODINGS_TABLE[encoding];
        }

        static JCodings.Encoding getJCoding(int encoding) {
            assert (J_CODINGS_TABLE[encoding] == Encoding.get((int)encoding).jCoding);
            return J_CODINGS_TABLE[encoding];
        }

        static int getMaxCompatibleCodeRange(int encoding) {
            return MAX_COMPATIBLE_CODE_RANGE[encoding];
        }

        boolean is7BitCompatible() {
            return Encoding.is7BitCompatible(this.id);
        }

        boolean is8BitCompatible() {
            return Encoding.is8BitCompatible(this.id);
        }

        boolean is16BitCompatible() {
            return Encoding.is16BitCompatible(this.id);
        }

        boolean isSupported() {
            return Encoding.isSupported(this.id);
        }

        boolean isUnsupported() {
            return Encoding.isUnsupported(this.id);
        }

        static boolean is7BitCompatible(int encoding) {
            return encoding < 92;
        }

        static boolean is8BitCompatible(int encoding) {
            return encoding < 3;
        }

        static boolean is16BitCompatible(int encoding) {
            return encoding < 2;
        }

        static boolean isSupported(int encoding) {
            return encoding < 6;
        }

        static boolean isUnsupported(int encoding) {
            return encoding >= 6;
        }

        boolean isFixedWidth() {
            return this.fixedWidth;
        }

        static boolean isFixedWidth(int encoding) {
            return Encoding.get(encoding).isFixedWidth();
        }

        private static /* synthetic */ Encoding[] $values() {
            return new Encoding[]{UTF_32LE, UTF_32BE, UTF_16LE, UTF_16BE, ISO_8859_1, UTF_8, US_ASCII, BYTES, Big5, Big5_HKSCS, Big5_UAO, CESU_8, CP51932, CP850, CP852, CP855, CP949, CP950, CP951, EUC_JIS_2004, EUC_JP, EUC_KR, EUC_TW, Emacs_Mule, EucJP_ms, GB12345, GB18030, GB1988, GB2312, GBK, IBM437, IBM720, IBM737, IBM775, IBM852, IBM855, IBM857, IBM860, IBM861, IBM862, IBM863, IBM864, IBM865, IBM866, IBM869, ISO_8859_10, ISO_8859_11, ISO_8859_13, ISO_8859_14, ISO_8859_15, ISO_8859_16, ISO_8859_2, ISO_8859_3, ISO_8859_4, ISO_8859_5, ISO_8859_6, ISO_8859_7, ISO_8859_8, ISO_8859_9, KOI8_R, KOI8_U, MacCentEuro, MacCroatian, MacCyrillic, MacGreek, MacIceland, MacJapanese, MacRoman, MacRomania, MacThai, MacTurkish, MacUkraine, SJIS_DoCoMo, SJIS_KDDI, SJIS_SoftBank, Shift_JIS, Stateless_ISO_2022_JP, Stateless_ISO_2022_JP_KDDI, TIS_620, UTF8_DoCoMo, UTF8_KDDI, UTF8_MAC, UTF8_SoftBank, Windows_1250, Windows_1251, Windows_1252, Windows_1253, Windows_1254, Windows_1255, Windows_1256, Windows_1257, Windows_1258, Windows_31J, Windows_874, CP50220, CP50221, IBM037, ISO_2022_JP, ISO_2022_JP_2, ISO_2022_JP_KDDI, UTF_7};
        }

        static {
            $VALUES = Encoding.$values();
            UTF_32 = TStringGuards.littleEndian() ? UTF_32LE : UTF_32BE;
            UTF_16 = TStringGuards.littleEndian() ? UTF_16LE : UTF_16BE;
            ENCODINGS_TABLE = new Encoding[Encoding.values().length];
            J_CODINGS_TABLE = new JCodings.Encoding[Encoding.values().length];
            MAX_COMPATIBLE_CODE_RANGE = new byte[Encoding.values().length];
            EMPTY_STRINGS = new TruffleString[Encoding.values().length];
            J_CODINGS_NAME_MAP = EconomicMap.create((int)Encoding.values().length);
            for (Encoding e : Encoding.values()) {
                assert (ENCODINGS_TABLE[e.id] == null);
                Encoding.ENCODINGS_TABLE[e.id] = e;
                assert (J_CODINGS_TABLE[e.id] == null);
                Encoding.J_CODINGS_TABLE[e.id] = e.jCoding;
                Encoding.MAX_COMPATIBLE_CODE_RANGE[e.id] = e.maxCompatibleCodeRange;
                if (!JCodings.ENABLED) continue;
                J_CODINGS_NAME_MAP.put((Object)JCodings.getInstance().name(e.jCoding), (Object)e);
            }
            assert (Encoding.UTF_16.naturalStride == 1);
            assert (Encoding.UTF_32.naturalStride == 2);
            Encoding.EMPTY_STRINGS[Encoding.US_ASCII.id] = TruffleString.createConstant(new byte[0], 0, 0, US_ASCII, 0, TSCodeRange.get7Bit());
            for (Encoding e : Encoding.values()) {
                if (e == US_ASCII) continue;
                assert (EMPTY_STRINGS[e.id] == null);
                if (!e.isSupported() && !JCodings.ENABLED) continue;
                Encoding.EMPTY_STRINGS[e.id] = Encoding.createEmpty(e);
            }
        }
    }

    public static abstract class FromCodePointNode
    extends AbstractPublicNode {
        FromCodePointNode() {
        }

        public final TruffleString execute(int codepoint, Encoding encoding) {
            return this.execute(codepoint, encoding, encoding == Encoding.UTF_16);
        }

        public abstract TruffleString execute(int var1, Encoding var2, boolean var3);

        /*
         * Enabled aggressive block sorting
         */
        @Specialization
        final TruffleString fromCodePoint(int c, Encoding enc, boolean allowUTF16Surrogates, @Cached InlinedConditionProfile bytesProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile exoticProfile, @Cached InlinedConditionProfile bmpProfile, @Cached InlinedBranchProfile invalidCodePoint) {
            int codeRange;
            int stride;
            int length;
            byte[] bytes;
            assert (!allowUTF16Surrogates || TStringGuards.isUTF16Or32(enc)) : "allowUTF16Surrogates is only supported on UTF-16 and UTF-32";
            CompilerAsserts.partialEvaluationConstant(allowUTF16Surrogates);
            if (TStringGuards.is7BitCompatible(enc) && Integer.compareUnsigned(c, 127) <= 0) {
                return TStringConstants.getSingleByteAscii(enc, c);
            }
            if (TStringGuards.is8BitCompatible(enc) && Integer.compareUnsigned(c, 255) <= 0) {
                if ($assertionsDisabled) return TStringConstants.getSingleByte(enc, c);
                if (TStringGuards.isSupportedEncoding(enc)) return TStringConstants.getSingleByte(enc, c);
                throw new AssertionError();
            }
            if (bytesProfile.profile(this, TStringGuards.isBytes(enc))) {
                if (Integer.compareUnsigned(c, 255) <= 0) return TStringConstants.getSingleByte(Encoding.BYTES, c);
                invalidCodePoint.enter(this);
                return null;
            }
            if (utf8Profile.profile(this, TStringGuards.isUTF8(enc))) {
                if (!Encodings.isValidUnicodeCodepoint(c)) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 127);
                bytes = Encodings.utf8Encode(c);
                length = bytes.length;
                stride = 0;
                codeRange = TSCodeRange.getValidMultiByte();
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf16Profile.profile(this, TStringGuards.isUTF16(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 255);
                bytes = new byte[c <= 65535 ? 2 : 4];
                stride = 1;
                if (!bmpProfile.profile(this, c <= 65535)) {
                    length = 2;
                    codeRange = TSCodeRange.getValidMultiByte();
                    Encodings.utf16EncodeSurrogatePair(c, bytes, 0);
                    return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                length = 1;
                if (Encodings.isUTF16Surrogate(c)) {
                    if (!allowUTF16Surrogates) {
                        invalidCodePoint.enter(this);
                        return null;
                    }
                    codeRange = TSCodeRange.getBrokenMultiByte();
                } else {
                    codeRange = TSCodeRange.get16Bit();
                }
                TStringOps.writeToByteArray(bytes, 1, 0, c);
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (utf32Profile.profile(this, TStringGuards.isUTF32(enc))) {
                if (Integer.toUnsignedLong(c) > 0x10FFFFL) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                assert (c > 255);
                if (c <= 65535) {
                    if (Encodings.isUTF16Surrogate(c)) {
                        if (!allowUTF16Surrogates) {
                            invalidCodePoint.enter(this);
                            return null;
                        }
                        codeRange = TSCodeRange.getBrokenFixedWidth();
                    } else {
                        codeRange = TSCodeRange.get16Bit();
                    }
                } else {
                    codeRange = TSCodeRange.getValidFixedWidth();
                }
                boolean compact1 = TSCodeRange.is16Bit(codeRange);
                bytes = new byte[compact1 ? 2 : 4];
                length = 1;
                if (bmpProfile.profile(this, compact1)) {
                    stride = 1;
                    TStringOps.writeToByteArray(bytes, 1, 0, c);
                    return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                stride = 2;
                TStringOps.writeToByteArray(bytes, 2, 0, c);
                return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
            }
            if (exoticProfile.profile(this, !TStringGuards.isSupportedEncoding(enc))) {
                assert (!TStringGuards.isBytes(enc));
                JCodings.Encoding jCodingsEnc = JCodings.getInstance().get(enc);
                length = JCodings.getInstance().getCodePointLength(jCodingsEnc, c);
                stride = 0;
                codeRange = TSCodeRange.getValid(JCodings.getInstance().isSingleByte(jCodingsEnc));
                if (length < 1) {
                    invalidCodePoint.enter(this);
                    return null;
                }
                bytes = new byte[length];
                int ret = JCodings.getInstance().writeCodePoint(jCodingsEnc, c, bytes, 0);
                if (ret == length && JCodings.getInstance().getCodePointLength(jCodingsEnc, bytes, 0, length) == ret) {
                    if (JCodings.getInstance().readCodePoint(jCodingsEnc, bytes, 0, length, DecodingErrorHandler.RETURN_NEGATIVE) == c) return TruffleString.createFromByteArray(bytes, length, stride, enc, 1, codeRange);
                }
                invalidCodePoint.enter(this);
                return null;
            }
            if (!($assertionsDisabled || TStringGuards.isAscii(enc) && Integer.compareUnsigned(c, 127) > 0)) {
                if (!TStringGuards.isLatin1(enc)) throw new AssertionError();
                if (Integer.compareUnsigned(c, 255) <= 0) {
                    throw new AssertionError();
                }
            }
            invalidCodePoint.enter(this);
            return null;
        }

        @NeverDefault
        public static FromCodePointNode create() {
            return TruffleStringFactory.FromCodePointNodeGen.create();
        }

        public static FromCodePointNode getUncached() {
            return TruffleStringFactory.FromCodePointNodeGen.getUncached();
        }
    }

    public static abstract class FromLongNode
    extends AbstractPublicNode {
        FromLongNode() {
        }

        public abstract TruffleString execute(long var1, Encoding var3, boolean var4);

        @Specialization(guards={"is7BitCompatible(enc)", "lazy"})
        static TruffleString doLazy(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            return TruffleString.createLazyLong(value, enc);
        }

        @Specialization(guards={"is7BitCompatible(enc)", "!lazy"})
        static TruffleString doEager(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            int length = NumberConversion.stringLengthLong(value);
            return TruffleString.createFromByteArray(NumberConversion.longToString(value, length), length, 0, enc, length, TSCodeRange.get7Bit());
        }

        @Specialization(guards={"!is7BitCompatible(enc)"})
        static TruffleString unsupported(long value, Encoding enc, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            throw InternalErrors.unsupportedOperation(FromLongNode.nonAsciiCompatibleMessage(enc));
        }

        @CompilerDirectives.TruffleBoundary
        private static String nonAsciiCompatibleMessage(Encoding enc) {
            return "Encoding " + enc + " is not ASCII-compatible";
        }

        @NeverDefault
        public static FromLongNode create() {
            return TruffleStringFactory.FromLongNodeGen.create();
        }

        public static FromLongNode getUncached() {
            return TruffleStringFactory.FromLongNodeGen.getUncached();
        }
    }

    public static abstract class FromByteArrayNode
    extends AbstractPublicNode {
        FromByteArrayNode() {
        }

        public final TruffleString execute(byte[] value, Encoding encoding) {
            return this.execute(value, encoding, true);
        }

        public final TruffleString execute(byte[] value, Encoding encoding, boolean copy) {
            return this.execute(value, 0, value.length, encoding, copy);
        }

        public abstract TruffleString execute(byte[] var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString fromByteArray(byte[] value, int byteOffset, int byteLength, Encoding enc, boolean copy, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.checkArrayRange(value, byteOffset, byteLength);
            return fromBufferWithStringCompactionNode.execute(this, value, byteOffset, byteLength, enc, copy, true);
        }

        @NeverDefault
        public static FromByteArrayNode create() {
            return TruffleStringFactory.FromByteArrayNodeGen.create();
        }

        public static FromByteArrayNode getUncached() {
            return TruffleStringFactory.FromByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class FromCharArrayUTF16Node
    extends AbstractPublicNode {
        FromCharArrayUTF16Node() {
        }

        public final TruffleString execute(char[] value) {
            return this.execute(value, 0, value.length);
        }

        public abstract TruffleString execute(char[] var1, int var2, int var3);

        @Specialization
        final TruffleString doNonEmpty(char[] value, int charOffset, int charLength, @Cached InlinedConditionProfile utf16CompactProfile, @Cached InlinedBranchProfile outOfMemoryProfile) {
            AbstractTruffleString.checkArrayRange(value.length, charOffset, charLength);
            if (charLength == 0) {
                return Encoding.UTF_16.getEmpty();
            }
            if (charLength == 1 && value[charOffset] <= '\u00ff') {
                return TStringConstants.getSingleByte(Encoding.UTF_16, value[charOffset]);
            }
            int offsetV = charOffset << 1;
            if (value.length > 0x3FFFFFFB || offsetV < 0) {
                outOfMemoryProfile.enter(this);
                throw InternalErrors.outOfMemory();
            }
            long attrs = TStringOps.calcStringAttributesUTF16C(this, value, offsetV, charLength);
            int codePointLength = StringAttributes.getCodePointLength(attrs);
            int codeRange = StringAttributes.getCodeRange(attrs);
            int stride = Stride.fromCodeRangeUTF16(codeRange);
            byte[] array = new byte[charLength << stride];
            if (utf16CompactProfile.profile(this, stride == 0)) {
                TStringOps.arraycopyWithStrideCB(this, value, offsetV, array, 0, 0, charLength);
            } else {
                TStringOps.arraycopyWithStrideCB(this, value, offsetV, array, 0, 1, charLength);
            }
            return TruffleString.createFromArray(array, 0, charLength, stride, Encoding.UTF_16, codePointLength, codeRange);
        }

        @NeverDefault
        public static FromCharArrayUTF16Node create() {
            return TruffleStringFactory.FromCharArrayUTF16NodeGen.create();
        }

        public static FromCharArrayUTF16Node getUncached() {
            return TruffleStringFactory.FromCharArrayUTF16NodeGen.getUncached();
        }
    }

    public static abstract class FromJavaStringNode
    extends AbstractPublicNode {
        FromJavaStringNode() {
        }

        public final TruffleString execute(String value, Encoding encoding) {
            return this.execute(value, 0, value.length(), encoding, false);
        }

        public abstract TruffleString execute(String var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString doUTF16(String javaString, int charOffset, int length, Encoding encoding, boolean copy, @Cached TStringInternalNodes.FromJavaStringUTF16Node fromJavaStringUTF16Node, @Cached InternalSwitchEncodingNode switchEncodingNode, @Cached InlinedConditionProfile utf16Profile) {
            if (javaString.isEmpty()) {
                return encoding.getEmpty();
            }
            TruffleString utf16String = fromJavaStringUTF16Node.execute(this, javaString, charOffset, length, copy);
            if (utf16Profile.profile(this, encoding == Encoding.UTF_16)) {
                return utf16String;
            }
            return switchEncodingNode.execute(this, utf16String, encoding, TranscodingErrorHandler.DEFAULT);
        }

        @NeverDefault
        public static FromJavaStringNode create() {
            return TruffleStringFactory.FromJavaStringNodeGen.create();
        }

        public static FromJavaStringNode getUncached() {
            return TruffleStringFactory.FromJavaStringNodeGen.getUncached();
        }
    }

    public static final class CodeRange
    extends Enum<CodeRange> {
        public static final /* enum */ CodeRange ASCII = new CodeRange();
        public static final /* enum */ CodeRange LATIN_1 = new CodeRange();
        public static final /* enum */ CodeRange BMP = new CodeRange();
        public static final /* enum */ CodeRange VALID = new CodeRange();
        public static final /* enum */ CodeRange BROKEN = new CodeRange();
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final CodeRange[] BYTE_CODE_RANGES;
        private static final /* synthetic */ CodeRange[] $VALUES;

        public static CodeRange[] values() {
            return (CodeRange[])$VALUES.clone();
        }

        public static CodeRange valueOf(String name) {
            return Enum.valueOf(CodeRange.class, name);
        }

        public boolean isSubsetOf(CodeRange other) {
            return this.ordinal() <= other.ordinal();
        }

        public boolean isSupersetOf(CodeRange other) {
            return this.ordinal() >= other.ordinal();
        }

        static CodeRange get(int codeRange) {
            assert (TSCodeRange.ordinal(TSCodeRange.get7Bit()) == 0);
            assert (TSCodeRange.ordinal(TSCodeRange.get8Bit()) == 1);
            assert (TSCodeRange.ordinal(TSCodeRange.get16Bit()) == 2);
            assert (TSCodeRange.ordinal(TSCodeRange.getValidFixedWidth()) == 3);
            assert (TSCodeRange.ordinal(TSCodeRange.getValidMultiByte()) == 3);
            assert (TSCodeRange.ordinal(TSCodeRange.getBrokenFixedWidth()) == 4);
            assert (TSCodeRange.ordinal(TSCodeRange.getBrokenMultiByte()) == 4);
            int ordinal = TSCodeRange.ordinal(codeRange);
            switch (ordinal) {
                case 0: {
                    return ASCII;
                }
                case 1: {
                    return LATIN_1;
                }
                case 2: {
                    return BMP;
                }
                case 3: {
                    return VALID;
                }
            }
            assert (ordinal == 4);
            return BROKEN;
        }

        static CodeRange getByteCodeRange(int codeRange, Encoding encoding) {
            return TSCodeRange.is7Bit(codeRange) && TStringGuards.isUTF16Or32(encoding) ? VALID : BYTE_CODE_RANGES[TSCodeRange.ordinal(codeRange)];
        }

        static boolean equals(int codeRange, CodeRange codeRangeEnum) {
            return TSCodeRange.ordinal(codeRange) == codeRangeEnum.ordinal();
        }

        private static /* synthetic */ CodeRange[] $values() {
            return new CodeRange[]{ASCII, LATIN_1, BMP, VALID, BROKEN};
        }

        static {
            $VALUES = CodeRange.$values();
            BYTE_CODE_RANGES = new CodeRange[]{ASCII, VALID, VALID, VALID, BROKEN};
            assert (CodeRange.get(TSCodeRange.get7Bit()) == ASCII);
            assert (CodeRange.get(TSCodeRange.get8Bit()) == LATIN_1);
            assert (CodeRange.get(TSCodeRange.get16Bit()) == BMP);
            assert (CodeRange.get(TSCodeRange.getValidFixedWidth()) == VALID);
            assert (CodeRange.get(TSCodeRange.getBrokenFixedWidth()) == BROKEN);
            assert (CodeRange.get(TSCodeRange.getValidMultiByte()) == VALID);
            assert (CodeRange.get(TSCodeRange.getBrokenMultiByte()) == BROKEN);
            assert (CodeRange.equals(TSCodeRange.get7Bit(), ASCII));
            assert (CodeRange.equals(TSCodeRange.get8Bit(), LATIN_1));
            assert (CodeRange.equals(TSCodeRange.get16Bit(), BMP));
            assert (CodeRange.equals(TSCodeRange.getValidFixedWidth(), VALID));
            assert (CodeRange.equals(TSCodeRange.getBrokenFixedWidth(), BROKEN));
            assert (CodeRange.equals(TSCodeRange.getValidMultiByte(), VALID));
            assert (CodeRange.equals(TSCodeRange.getBrokenMultiByte(), BROKEN));
        }
    }

    public static abstract class FromIntArrayUTF32Node
    extends AbstractPublicNode {
        FromIntArrayUTF32Node() {
        }

        public final TruffleString execute(int[] value) {
            return this.execute(value, 0, value.length);
        }

        public abstract TruffleString execute(int[] var1, int var2, int var3);

        @Specialization
        final TruffleString doNonEmpty(int[] value, int intOffset, int length, @Cached InlinedConditionProfile utf32Compact0Profile, @Cached InlinedConditionProfile utf32Compact1Profile, @Cached InlinedBranchProfile outOfMemoryProfile) {
            AbstractTruffleString.checkArrayRange(value.length, intOffset, length);
            if (length == 0) {
                return Encoding.UTF_32.getEmpty();
            }
            if (length == 1 && value[intOffset] <= 255) {
                return TStringConstants.getSingleByte(Encoding.UTF_32, value[intOffset]);
            }
            int offsetV = intOffset << 2;
            if (length > 0x1FFFFFFD || offsetV < 0) {
                outOfMemoryProfile.enter(this);
                throw InternalErrors.outOfMemory();
            }
            int codeRange = TStringOps.calcStringAttributesUTF32I(this, value, offsetV, length);
            int stride = Stride.fromCodeRangeUTF32(codeRange);
            byte[] array = new byte[length << stride];
            if (utf32Compact0Profile.profile(this, stride == 0)) {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, 0, 0, length);
            } else if (utf32Compact1Profile.profile(this, stride == 1)) {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, 0, 1, length);
            } else {
                TStringOps.arraycopyWithStrideIB(this, value, offsetV, array, 0, 2, length);
            }
            return TruffleString.createFromArray(array, 0, length, stride, Encoding.UTF_32, length, codeRange);
        }

        @NeverDefault
        public static FromIntArrayUTF32Node create() {
            return TruffleStringFactory.FromIntArrayUTF32NodeGen.create();
        }

        public static FromIntArrayUTF32Node getUncached() {
            return TruffleStringFactory.FromIntArrayUTF32NodeGen.getUncached();
        }
    }

    public static abstract class FromNativePointerNode
    extends AbstractPublicNode {
        FromNativePointerNode() {
        }

        public abstract TruffleString execute(Object var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString fromNativePointer(Object pointerObject, int byteOffset, int byteLength, Encoding enc, boolean copy, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached TStringInternalNodes.FromNativePointerNode fromNativePointerNode, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            AbstractTruffleString.NativePointer pointer = AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary);
            if (copy) {
                return fromBufferWithStringCompactionNode.execute(this, pointer, byteOffset, byteLength, enc, true, true);
            }
            return fromNativePointerNode.execute(this, pointer, byteOffset, byteLength, enc, true);
        }

        @NeverDefault
        public static FromNativePointerNode create() {
            return TruffleStringFactory.FromNativePointerNodeGen.create();
        }

        public static FromNativePointerNode getUncached() {
            return TruffleStringFactory.FromNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class AsNativeNode
    extends AbstractPublicNode {
        private static final int NULL_TERMINATION_BYTES = 4;

        AsNativeNode() {
        }

        public abstract TruffleString execute(TruffleString var1, NativeAllocator var2, Encoding var3, boolean var4, boolean var5);

        @Specialization
        static TruffleString asNative(TruffleString a, NativeAllocator allocator, Encoding encoding, boolean useCompaction, boolean cacheResult, @Bind(value="this") Node node, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile cacheHit, @Cached InlinedIntValueProfile inflateStrideProfile, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            a.checkEncoding(encoding);
            CompilerAsserts.partialEvaluationConstant(allocator);
            CompilerAsserts.partialEvaluationConstant(useCompaction);
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            int strideA = inflateStrideProfile.profile(node, a.stride());
            int codeRangeA = getPreciseCodeRangeNode.execute(node, a, encoding);
            if (isNativeProfile.profile(node, a.isNative() && strideA == (useCompaction ? Stride.fromCodeRange(codeRangeA, encoding) : encoding.naturalStride))) {
                return a;
            }
            TruffleString cur = a.next;
            assert (!a.isJavaString());
            if (cacheResult && cur != null) {
                while (!(cur == a || cur.isNative() && cur.isCompatibleToIntl(encoding) && cur.stride() == (useCompaction ? strideA : (int)encoding.naturalStride))) {
                    cur = cur.next;
                }
                if (cacheHit.profile(node, cur != a)) {
                    assert (cur.isCompatibleToIntl(encoding) && cur.isNative() && !cur.isJavaString() && cur.stride() == (useCompaction ? strideA : (int)encoding.naturalStride));
                    return cur;
                }
            }
            int length = a.length();
            int stride = useCompaction ? Stride.fromCodeRange(codeRangeA, encoding) : encoding.naturalStride;
            int byteSize = length << stride;
            Object buffer = allocator.allocate(byteSize + 4);
            AbstractTruffleString.NativePointer nativePointer = AbstractTruffleString.NativePointer.create(node, buffer, interopLibrary);
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            int offsetA = a.offset();
            if (useCompaction) {
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, nativePointer, 0, stride, 0, length);
            } else if (TStringGuards.isUTF16(encoding)) {
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, nativePointer, 0, 1, 0, length);
            } else if (TStringGuards.isUTF32(encoding)) {
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, strideA, 0, nativePointer, 0, 2, 0, length);
            } else {
                TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, 0, nativePointer, 0, 0, 0, byteSize);
            }
            AsNativeNode.checkIntSize();
            TStringUnsafe.putIntNative(nativePointer.pointer, byteSize, 0);
            TruffleString nativeString = TruffleString.createFromArray(nativePointer, 0, length, stride, encoding, a.codePointLength(), codeRangeA, !cacheResult);
            if (cacheResult) {
                a.cacheInsert(nativeString);
            }
            return nativeString;
        }

        private static void checkIntSize() {
        }

        @NeverDefault
        public static AsNativeNode create() {
            return TruffleStringFactory.AsNativeNodeGen.create();
        }

        public static AsNativeNode getUncached() {
            return TruffleStringFactory.AsNativeNodeGen.getUncached();
        }
    }

    public static abstract class CreateBackwardCodePointIteratorNode
    extends AbstractPublicNode {
        CreateBackwardCodePointIteratorNode() {
        }

        public final TruffleStringIterator execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract TruffleStringIterator execute(AbstractTruffleString var1, Encoding var2, ErrorHandling var3);

        @Specialization
        final TruffleStringIterator createIterator(AbstractTruffleString a, Encoding encoding, ErrorHandling errorHandling, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            return AbstractTruffleString.backwardIterator(a, toIndexableNode.execute(this, a, a.data()), getCodeRangeANode.execute(this, a, encoding), encoding, errorHandling);
        }

        @NeverDefault
        public static CreateBackwardCodePointIteratorNode create() {
            return TruffleStringFactory.CreateBackwardCodePointIteratorNodeGen.create();
        }

        public static CreateBackwardCodePointIteratorNode getUncached() {
            return TruffleStringFactory.CreateBackwardCodePointIteratorNodeGen.getUncached();
        }
    }

    public static abstract class CreateCodePointIteratorNode
    extends AbstractPublicNode {
        CreateCodePointIteratorNode() {
        }

        public final TruffleStringIterator execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract TruffleStringIterator execute(AbstractTruffleString var1, Encoding var2, ErrorHandling var3);

        @Specialization
        final TruffleStringIterator createIterator(AbstractTruffleString a, Encoding encoding, ErrorHandling errorHandling, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            return AbstractTruffleString.forwardIterator(a, toIndexableNode.execute(this, a, a.data()), getCodeRangeANode.execute(this, a, encoding), encoding, errorHandling);
        }

        @NeverDefault
        public static CreateCodePointIteratorNode create() {
            return TruffleStringFactory.CreateCodePointIteratorNodeGen.create();
        }

        public static CreateCodePointIteratorNode getUncached() {
            return TruffleStringFactory.CreateCodePointIteratorNodeGen.getUncached();
        }
    }

    public static abstract class ForceEncodingNode
    extends AbstractPublicNode {
        ForceEncodingNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, Encoding var3);

        @Specialization(guards={"isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        static TruffleString compatibleImmutable(TruffleString a, Encoding expectedEncoding, Encoding targetEncoding) {
            assert (!a.isJavaString());
            return a;
        }

        @Specialization(guards={"isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        final TruffleString compatibleMutable(MutableTruffleString a, Encoding expectedEncoding, Encoding targetEncoding, @Cached InternalAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute(this, a, targetEncoding);
        }

        @Specialization(guards={"!isCompatibleAndNotCompacted(a, expectedEncoding, targetEncoding)"})
        final TruffleString reinterpret(AbstractTruffleString a, Encoding expectedEncoding, Encoding targetEncoding, @Cached ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile inflateProfile, @Cached InternalCopyToByteArrayNode copyToByteArrayNode, @Cached TStringInternalNodes.FromBufferWithStringCompactionNode fromBufferWithStringCompactionNode) {
            int offset;
            Object arrayNoCompaction;
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int byteLength = a.length() << expectedEncoding.naturalStride;
            if (inflateProfile.profile(this, TStringGuards.isUTF16Or32(expectedEncoding) && a.stride() != expectedEncoding.naturalStride)) {
                byte[] inflated = new byte[byteLength];
                copyToByteArrayNode.execute(this, a, 0, inflated, 0, byteLength, expectedEncoding);
                arrayNoCompaction = inflated;
                offset = 0;
            } else {
                arrayNoCompaction = arrayA;
                offset = a.offset();
            }
            return fromBufferWithStringCompactionNode.execute(this, arrayNoCompaction, offset, byteLength, targetEncoding, a.isMutable(), true);
        }

        static boolean isCompatibleAndNotCompacted(AbstractTruffleString a, Encoding expectedEncoding, Encoding targetEncoding) {
            return expectedEncoding.naturalStride == targetEncoding.naturalStride && (a.encoding() == targetEncoding.id || a.stride() == targetEncoding.naturalStride && a.isCompatibleToIntl(targetEncoding));
        }

        @NeverDefault
        public static ForceEncodingNode create() {
            return TruffleStringFactory.ForceEncodingNodeGen.create();
        }

        public static ForceEncodingNode getUncached() {
            return TruffleStringFactory.ForceEncodingNodeGen.getUncached();
        }
    }

    static abstract class InternalSwitchEncodingNode
    extends AbstractInternalNode {
        InternalSwitchEncodingNode() {
        }

        public abstract TruffleString execute(Node var1, AbstractTruffleString var2, Encoding var3, TranscodingErrorHandler var4);

        @Specialization(guards={"a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString compatibleImmutable(TruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler) {
            assert (!a.isJavaString());
            return a;
        }

        @Specialization(guards={"a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString compatibleMutable(Node node, MutableTruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached InternalAsTruffleStringNode asTruffleStringNode) {
            return asTruffleStringNode.execute(node, a, targetEncoding);
        }

        @Specialization(guards={"!a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString transCode(Node node, TruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached InlinedConditionProfile preciseCodeRangeIsCompatibleProfile, @Cached.Exclusive @Cached InlinedConditionProfile cacheHit, @Cached ToIndexableNode toIndexableNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode) {
            TruffleString transCoded;
            if (a.isEmpty()) {
                return targetEncoding.getEmpty();
            }
            Encoding encodingA = Encoding.get(a.encoding());
            int preciseCodeRangeA = getPreciseCodeRangeNode.execute(node, a, encodingA);
            if (preciseCodeRangeIsCompatibleProfile.profile(node, a.isCodeRangeCompatibleTo(preciseCodeRangeA, targetEncoding))) {
                return a;
            }
            TruffleString cur = a.next;
            assert (!a.isJavaString());
            if (cur != null) {
                while (cur != a && cur.encoding() != targetEncoding.id || TStringGuards.isUTF16(targetEncoding) && cur.isJavaString()) {
                    cur = cur.next;
                }
                if (cacheHit.profile(node, cur.encoding() == targetEncoding.id)) {
                    assert (!cur.isJavaString());
                    return cur;
                }
            }
            if (!(transCoded = transCodeNode.execute(node, a, toIndexableNode.execute(node, a, a.data()), a.codePointLength(), preciseCodeRangeA, targetEncoding, errorHandler)).isCacheHead()) {
                a.cacheInsert(transCoded);
            }
            return transCoded;
        }

        @Specialization(guards={"!a.isCompatibleToIntl(targetEncoding)"})
        static TruffleString transCodeMutable(Node node, MutableTruffleString a, Encoding targetEncoding, TranscodingErrorHandler errorHandler, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached.Exclusive @Cached InlinedConditionProfile isCompatibleProfile) {
            if (a.isEmpty()) {
                return targetEncoding.getEmpty();
            }
            Encoding encodingA = Encoding.get(a.encoding());
            int codePointLengthA = getCodePointLengthNode.execute(node, a, encodingA);
            int codeRangeA = getPreciseCodeRangeNode.execute(node, a, encodingA);
            if (isCompatibleProfile.profile(node, TSCodeRange.isMoreRestrictiveThan(codeRangeA, targetEncoding.maxCompatibleCodeRange))) {
                int strideDst = Stride.fromCodeRange(codeRangeA, targetEncoding);
                byte[] arrayDst = new byte[a.length() << strideDst];
                TStringOps.arraycopyWithStride(node, a.data(), a.offset(), a.stride(), 0, arrayDst, 0, strideDst, 0, a.length());
                return TruffleString.createFromByteArray(arrayDst, a.length(), strideDst, targetEncoding, codePointLengthA, codeRangeA);
            }
            return transCodeNode.execute(node, a, a.data(), codePointLengthA, codeRangeA, targetEncoding, errorHandler);
        }
    }

    public static abstract class SwitchEncodingNode
    extends AbstractPublicNode {
        SwitchEncodingNode() {
        }

        public final TruffleString execute(AbstractTruffleString a, Encoding encoding) {
            return this.execute(a, encoding, TranscodingErrorHandler.DEFAULT);
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, TranscodingErrorHandler var3);

        @Specialization
        final TruffleString switchEncoding(AbstractTruffleString a, Encoding encoding, TranscodingErrorHandler errorHandler, @Cached InternalSwitchEncodingNode internalNode) {
            return internalNode.execute(this, a, encoding, errorHandler);
        }

        @NeverDefault
        public static SwitchEncodingNode create() {
            return TruffleStringFactory.SwitchEncodingNodeGen.create();
        }

        public static SwitchEncodingNode getUncached() {
            return TruffleStringFactory.SwitchEncodingNodeGen.getUncached();
        }
    }

    public static abstract class ToJavaStringNode
    extends AbstractPublicNode {
        ToJavaStringNode() {
        }

        public abstract String execute(AbstractTruffleString var1);

        @Specialization
        static String doUTF16(TruffleString a, @Bind(value="this") Node node, @Cached InlinedConditionProfile cacheHit, @Cached ToIndexableNode toIndexableNode, @Cached @Cached.Shared TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached @Cached.Shared TStringInternalNodes.CreateJavaStringNode createJavaStringNode, @Cached @Cached.Shared InlinedConditionProfile noTranscodeProfile) {
            Object utf16Array;
            TruffleString utf16String;
            if (a.isEmpty()) {
                return "";
            }
            TruffleString cur = a.next;
            if (cur != null) {
                while (cur != a && !cur.isJavaString()) {
                    cur = cur.next;
                }
                if (cacheHit.profile(node, cur.isJavaString())) {
                    return (String)cur.data();
                }
            }
            if ((cur = a.next) != null) {
                while (cur != a && !cur.isCompatibleToIntl(Encoding.UTF_16)) {
                    cur = cur.next;
                }
            } else {
                cur = a;
            }
            if (cur.isJavaString()) {
                return (String)cur.data();
            }
            Encoding encodingA = Encoding.get(cur.encoding());
            Object arrayCur = toIndexableNode.execute(node, cur, cur.data());
            if (noTranscodeProfile.profile(node, ToJavaStringNode.doesNotNeedTranscoding(node, cur, encodingA, getPreciseCodeRangeNode))) {
                utf16String = cur;
                utf16Array = arrayCur;
            } else {
                assert (TSCodeRange.isPrecise(cur.codeRange()));
                TruffleString transCoded = transCodeNode.execute(node, cur, arrayCur, getCodePointLengthNode.execute(node, cur, encodingA), cur.codeRange(), Encoding.UTF_16, TranscodingErrorHandler.DEFAULT);
                if (!transCoded.isCacheHead()) {
                    a.cacheInsert(transCoded);
                }
                utf16String = transCoded;
                utf16Array = transCoded.data();
            }
            String javaString = createJavaStringNode.execute(node, utf16String, utf16Array);
            a.cacheInsert(TruffleString.createWrapJavaString(javaString, utf16String.codePointLength(), utf16String.codeRange()));
            return javaString;
        }

        @Specialization
        static String doMutable(MutableTruffleString a, @Bind(value="this") Node node, @Cached @Cached.Shared TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached @Cached.Shared TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached @Cached.Shared TStringInternalNodes.TransCodeNode transCodeNode, @Cached @Cached.Shared TStringInternalNodes.CreateJavaStringNode createJavaStringNode, @Cached @Cached.Shared InlinedConditionProfile noTranscodeProfile) {
            AbstractTruffleString utf16String;
            if (a.isEmpty()) {
                return "";
            }
            Encoding encodingA = Encoding.get(a.encoding());
            if (noTranscodeProfile.profile(node, ToJavaStringNode.doesNotNeedTranscoding(node, a, encodingA, getPreciseCodeRangeNode))) {
                utf16String = a;
            } else {
                assert (TSCodeRange.isPrecise(a.codeRange()));
                utf16String = transCodeNode.execute(node, a, a.data(), getCodePointLengthNode.execute(node, a, encodingA), a.codeRange(), Encoding.UTF_16, TranscodingErrorHandler.DEFAULT);
            }
            return createJavaStringNode.execute(node, utf16String, utf16String.data());
        }

        private static boolean doesNotNeedTranscoding(Node node, AbstractTruffleString a, Encoding encodingA, TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            return TStringGuards.is7Or8Bit(a.codeRange()) || TSCodeRange.isMoreRestrictiveThan(getPreciseCodeRangeNode.execute(node, a, encodingA), Encoding.UTF_16.maxCompatibleCodeRange) || TStringGuards.isUTF16(a.encoding());
        }

        @NeverDefault
        public static ToJavaStringNode create() {
            return TruffleStringFactory.ToJavaStringNodeGen.create();
        }

        public static ToJavaStringNode getUncached() {
            return TruffleStringFactory.ToJavaStringNodeGen.getUncached();
        }
    }

    public static abstract class CopyToNativeMemoryNode
    extends AbstractPublicNode {
        CopyToNativeMemoryNode() {
        }

        public abstract void execute(AbstractTruffleString var1, int var2, Object var3, int var4, int var5, Encoding var6);

        @Specialization
        void doCopy(AbstractTruffleString a, int byteFromIndexA, Object pointerObject, int byteFromIndexB, int byteLength, Encoding expectedEncoding, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary, @Cached ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile) {
            InternalCopyToByteArrayNode.doCopyInternal(this, a, byteFromIndexA, AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary), byteFromIndexB, byteLength, expectedEncoding, toIndexableNode, utf16Profile, utf16S0Profile, utf32Profile, utf32S0Profile, utf32S1Profile);
        }

        @NeverDefault
        public static CopyToNativeMemoryNode create() {
            return TruffleStringFactory.CopyToNativeMemoryNodeGen.create();
        }

        public static CopyToNativeMemoryNode getUncached() {
            return TruffleStringFactory.CopyToNativeMemoryNodeGen.getUncached();
        }
    }

    static abstract class InternalCopyToByteArrayNode
    extends AbstractInternalNode {
        InternalCopyToByteArrayNode() {
        }

        abstract void execute(Node var1, AbstractTruffleString var2, int var3, byte[] var4, int var5, int var6, Encoding var7);

        @Specialization
        static void doCopy(Node node, AbstractTruffleString a, int byteFromIndexA, byte[] arrayB, int byteFromIndexB, int byteLength, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile) {
            AbstractTruffleString.boundsCheckRegionI(byteFromIndexB, byteLength, arrayB.length);
            InternalCopyToByteArrayNode.doCopyInternal(node, a, byteFromIndexA, arrayB, byteFromIndexB, byteLength, expectedEncoding, toIndexableNode, utf16Profile, utf16S0Profile, utf32Profile, utf32S0Profile, utf32S1Profile);
        }

        private static void doCopyInternal(Node node, AbstractTruffleString a, int byteFromIndexA, Object arrayB, int byteFromIndexB, int byteLength, Encoding expectedEncoding, ToIndexableNode toIndexableNode, InlinedConditionProfile utf16Profile, InlinedConditionProfile utf16S0Profile, InlinedConditionProfile utf32Profile, InlinedConditionProfile utf32S0Profile, InlinedConditionProfile utf32S1Profile) {
            if (byteLength == 0) {
                return;
            }
            a.checkEncoding(expectedEncoding);
            int offsetA = a.offset();
            boolean offsetB = false;
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            if (utf16Profile.profile(node, TStringGuards.isUTF16(expectedEncoding))) {
                a.boundsCheckByteIndexUTF16(byteFromIndexA);
                AbstractTruffleString.checkByteLengthUTF16(byteLength);
                fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
                int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
                int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
                a.boundsCheckRegionRaw(fromIndexA, length);
                if (utf16S0Profile.profile(node, TStringGuards.isStride0(a))) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, fromIndexA, arrayB, 0, 1, fromIndexB, length);
                    return;
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(expectedEncoding))) {
                a.boundsCheckByteIndexUTF32(byteFromIndexA);
                AbstractTruffleString.checkByteLengthUTF32(byteLength);
                fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
                int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
                int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
                a.boundsCheckRegionRaw(fromIndexA, length);
                if (utf32S0Profile.profile(node, TStringGuards.isStride0(a))) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, fromIndexA, arrayB, 0, 2, fromIndexB, length);
                    return;
                }
                if (utf32S1Profile.profile(node, TStringGuards.isStride1(a))) {
                    TStringOps.arraycopyWithStride(node, arrayA, offsetA, 1, fromIndexA, arrayB, 0, 2, fromIndexB, length);
                    return;
                }
            }
            assert (a.stride() == expectedEncoding.naturalStride);
            int byteLengthA = a.length() << a.stride();
            AbstractTruffleString.boundsCheckRegionI(byteFromIndexA, byteLength, byteLengthA);
            TStringOps.arraycopyWithStride(node, arrayA, offsetA, 0, byteFromIndexA, arrayB, 0, 0, byteFromIndexB, byteLength);
        }
    }

    public static abstract class CopyToByteArrayNode
    extends AbstractPublicNode {
        CopyToByteArrayNode() {
        }

        public final byte[] execute(AbstractTruffleString string, Encoding expectedEncoding) {
            int byteLength = string.byteLength(expectedEncoding);
            byte[] copy = new byte[byteLength];
            this.execute(string, 0, copy, 0, byteLength, expectedEncoding);
            return copy;
        }

        public abstract void execute(AbstractTruffleString var1, int var2, byte[] var3, int var4, int var5, Encoding var6);

        @Specialization
        final void doCopy(AbstractTruffleString a, int byteFromIndexA, byte[] dst, int byteFromIndexDst, int byteLength, Encoding expectedEncoding, @Cached InternalCopyToByteArrayNode internalNode) {
            internalNode.execute(this, a, byteFromIndexA, dst, byteFromIndexDst, byteLength, expectedEncoding);
        }

        @NeverDefault
        public static CopyToByteArrayNode create() {
            return TruffleStringFactory.CopyToByteArrayNodeGen.create();
        }

        public static CopyToByteArrayNode getUncached() {
            return TruffleStringFactory.CopyToByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class GetInternalNativePointerNode
    extends AbstractPublicNode {
        GetInternalNativePointerNode() {
        }

        public abstract Object execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static Object getNativePointer(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            if (!a.isNative()) {
                throw InternalErrors.unsupportedOperation("string is not backed by a native pointer!");
            }
            return ((AbstractTruffleString.NativePointer)a.data()).getPointerObject();
        }

        @NeverDefault
        public static GetInternalNativePointerNode create() {
            return TruffleStringFactory.GetInternalNativePointerNodeGen.create();
        }

        public static GetInternalNativePointerNode getUncached() {
            return TruffleStringFactory.GetInternalNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class GetInternalByteArrayNode
    extends AbstractPublicNode {
        GetInternalByteArrayNode() {
        }

        public abstract InternalByteArray execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        InternalByteArray getInternalByteArray(AbstractTruffleString a, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile, @Cached InlinedConditionProfile isByteArrayProfile) {
            if (a.isEmpty()) {
                return InternalByteArray.EMPTY;
            }
            a.checkEncoding(expectedEncoding);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            if (utf16Profile.profile(this, TStringGuards.isUTF16(expectedEncoding))) {
                if (utf16S0Profile.profile(this, TStringGuards.isStride0(a))) {
                    return this.inflate(a, arrayA, 0, 1);
                }
            } else if (utf32Profile.profile(this, TStringGuards.isUTF32(expectedEncoding))) {
                if (utf32S0Profile.profile(this, TStringGuards.isStride0(a))) {
                    return this.inflate(a, arrayA, 0, 2);
                }
                if (utf32S1Profile.profile(this, TStringGuards.isStride1(a))) {
                    return this.inflate(a, arrayA, 1, 2);
                }
            }
            int byteLength = a.length() << a.stride();
            if (isByteArrayProfile.profile(this, arrayA instanceof byte[])) {
                return new InternalByteArray((byte[])arrayA, a.offset(), byteLength);
            }
            return new InternalByteArray(TStringOps.arraycopyOfWithStride(this, arrayA, a.offset(), byteLength, 0, byteLength, 0), 0, byteLength);
        }

        private InternalByteArray inflate(AbstractTruffleString a, Object arrayA, int strideA, int strideB) {
            assert (a.stride() == strideA);
            CompilerAsserts.partialEvaluationConstant(strideA);
            CompilerAsserts.partialEvaluationConstant(strideB);
            return new InternalByteArray(TStringOps.arraycopyOfWithStride(this, arrayA, a.offset(), a.length(), strideA, a.length(), strideB), 0, a.length() << strideB);
        }

        @NeverDefault
        public static GetInternalByteArrayNode create() {
            return TruffleStringFactory.GetInternalByteArrayNodeGen.create();
        }

        public static GetInternalByteArrayNode getUncached() {
            return TruffleStringFactory.GetInternalByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class ParseDoubleNode
    extends AbstractPublicNode {
        ParseDoubleNode() {
        }

        public abstract double execute(AbstractTruffleString var1) throws NumberFormatException;

        @Specialization(guards={"isLazyLongSafeInteger(a)"})
        static double doLazyLong(AbstractTruffleString a) {
            return ((AbstractTruffleString.LazyLong)a.data()).value;
        }

        @Specialization(guards={"!isLazyLongSafeInteger(a)"})
        final double parseDouble(AbstractTruffleString a, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.ParseDoubleNode parseDoubleNode) throws NumberFormatException {
            return parseDoubleNode.execute(this, a, toIndexableNode.execute(this, a, a.data()));
        }

        static boolean isLazyLongSafeInteger(AbstractTruffleString a) {
            return a.isLazyLong() && NumberConversion.isSafeInteger(((AbstractTruffleString.LazyLong)a.data()).value);
        }

        @NeverDefault
        public static ParseDoubleNode create() {
            return TruffleStringFactory.ParseDoubleNodeGen.create();
        }

        public static ParseDoubleNode getUncached() {
            return TruffleStringFactory.ParseDoubleNodeGen.getUncached();
        }
    }

    public static abstract class ParseLongNode
    extends AbstractPublicNode {
        ParseLongNode() {
        }

        public abstract long execute(AbstractTruffleString var1, int var2) throws NumberFormatException;

        @Specialization(guards={"a.isLazyLong()", "radix == 10"})
        static long doLazyLong(AbstractTruffleString a, int radix) {
            return ((AbstractTruffleString.LazyLong)a.data()).value;
        }

        @Specialization(guards={"!a.isLazyLong() || radix != 10"})
        final long doParse(AbstractTruffleString a, int radix, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeANode, @Cached TStringInternalNodes.ParseLongNode parseLongNode, @Cached InlinedIntValueProfile radixProfile) throws NumberFormatException {
            Encoding encodingA = Encoding.get(a.encoding());
            int codeRangeA = getCodeRangeANode.execute(this, a, encodingA);
            return parseLongNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), codeRangeA, encodingA, radixProfile.profile(this, radix));
        }

        @NeverDefault
        public static ParseLongNode create() {
            return TruffleStringFactory.ParseLongNodeGen.create();
        }

        public static ParseLongNode getUncached() {
            return TruffleStringFactory.ParseLongNodeGen.getUncached();
        }
    }

    public static abstract class ParseIntNode
    extends AbstractPublicNode {
        ParseIntNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2) throws NumberFormatException;

        @Specialization(guards={"a.isLazyLong()", "radix == 10"})
        final int doLazyLong(AbstractTruffleString a, int radix, @Cached InlinedBranchProfile errorProfile) throws NumberFormatException {
            long value = ((AbstractTruffleString.LazyLong)a.data()).value;
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                errorProfile.enter(this);
                throw NumberConversion.numberFormatException(a, NumberFormatException.Reason.OVERFLOW);
            }
            return (int)value;
        }

        @Specialization(guards={"!a.isLazyLong() || radix != 10"})
        final int doParse(AbstractTruffleString a, int radix, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeANode, @Cached TStringInternalNodes.ParseIntNode parseIntNode, @Cached InlinedIntValueProfile radixProfile) throws NumberFormatException {
            Encoding encodingA = Encoding.get(a.encoding());
            int codeRangeA = getCodeRangeANode.execute(this, a, encodingA);
            return parseIntNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), codeRangeA, encodingA, radixProfile.profile(this, radix));
        }

        @NeverDefault
        public static ParseIntNode create() {
            return TruffleStringFactory.ParseIntNodeGen.create();
        }

        public static ParseIntNode getUncached() {
            return TruffleStringFactory.ParseIntNodeGen.getUncached();
        }
    }

    public static final class IllegalByteArrayLengthException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 2871353611734808666L;

        IllegalByteArrayLengthException(String msg) {
            super(msg);
        }
    }

    public static final class NumberFormatException
    extends Exception {
        private static final long serialVersionUID = 102938855488837538L;
        private final AbstractTruffleString string;
        private final int regionOffset;
        private final int regionLength;
        private final Reason reason;

        NumberFormatException(AbstractTruffleString string, Reason reason) {
            this(string, -1, -1, reason);
        }

        NumberFormatException(AbstractTruffleString string, int regionOffset, int regionLength, Reason reason) {
            this.string = string;
            this.regionOffset = regionOffset;
            this.regionLength = regionLength;
            this.reason = reason;
        }

        Reason getReason() {
            return this.reason;
        }

        AbstractTruffleString getString() {
            return this.string;
        }

        int getRegionByteOffset() {
            return this.regionOffset < 0 ? this.regionOffset : this.regionOffset << this.string.stride();
        }

        int getRegionByteLength() {
            return this.regionLength < 0 ? this.regionLength : this.regionLength << this.string.stride();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            sb.append("error parsing \"").append(this.getString()).append("\": ");
            sb.append(this.getReason().message);
            if (this.regionOffset >= 0) {
                if (this.regionLength == 1) {
                    sb.append(" at byte index ").append(this.getRegionByteOffset());
                } else {
                    sb.append(" from byte index ").append(this.getRegionByteOffset()).append(" to ").append(this.getRegionByteOffset() + this.getRegionByteLength());
                }
            }
            return sb.toString();
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static enum Reason {
            EMPTY("no digits found"),
            INVALID_CODEPOINT("invalid codepoint"),
            LONE_SIGN("lone '+' or '-'"),
            OVERFLOW("overflow"),
            MALFORMED_HEX_ESCAPE("malformed hex escape sequence"),
            MULTIPLE_DECIMAL_POINTS("multiple decimal points"),
            UNSUPPORTED_RADIX("unsupported radix");

            private final String message;

            private Reason(String message) {
                this.message = message;
            }

            public String getMessage() {
                return this.message;
            }
        }
    }

    public static abstract class EqualNode
    extends AbstractPublicNode {
        EqualNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3);

        @Specialization(guards={"identical(a, b)"})
        static boolean sameObject(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding) {
            return true;
        }

        @Specialization(guards={"!identical(a, b)"})
        final boolean check(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached InlinedConditionProfile lengthAndCodeRangeCheckProfile, @Cached InlinedBranchProfile compareHashProfile, @Cached InlinedConditionProfile checkFirstByteProfile) {
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            return EqualNode.checkContentEquals(this, a, b, toIndexableNodeA, toIndexableNodeB, lengthAndCodeRangeCheckProfile, compareHashProfile, checkFirstByteProfile);
        }

        static boolean checkContentEquals(Node node, AbstractTruffleString a, AbstractTruffleString b, ToIndexableNode toIndexableNodeA, ToIndexableNode toIndexableNodeB, InlinedConditionProfile lengthAndCodeRangeCheckProfile, InlinedBranchProfile compareHashProfile, InlinedConditionProfile checkFirstByteProfile) {
            int codeRangeA = a.codeRange();
            int codeRangeB = b.codeRange();
            int lengthCMP = a.length();
            if (lengthAndCodeRangeCheckProfile.profile(node, lengthCMP != b.length() || TSCodeRange.isPrecise(codeRangeA, codeRangeB) && codeRangeA != codeRangeB)) {
                return false;
            }
            if (a.isHashCodeCalculated() && b.isHashCodeCalculated()) {
                compareHashProfile.enter(node);
                if (a.getHashCodeUnsafe() != b.getHashCodeUnsafe()) {
                    return false;
                }
            }
            if (lengthCMP == 0) {
                return true;
            }
            Object arrayA = toIndexableNodeA.execute(node, a, a.data());
            Object arrayB = toIndexableNodeB.execute(node, b, b.data());
            int strideA = a.stride();
            int strideB = b.stride();
            if (checkFirstByteProfile.profile(node, arrayA instanceof byte[] && arrayB instanceof byte[] && (strideA | strideB) == 0)) {
                if (((byte[])arrayA)[a.offset()] != ((byte[])arrayB)[b.offset()]) {
                    return false;
                }
                if (lengthCMP == 1) {
                    return true;
                }
            }
            return TStringOps.regionEqualsWithOrMaskWithStride(node, a, arrayA, strideA, 0, b, arrayB, strideB, 0, null, lengthCMP);
        }

        @NeverDefault
        public static EqualNode create() {
            return TruffleStringFactory.EqualNodeGen.create();
        }

        public static EqualNode getUncached() {
            return TruffleStringFactory.EqualNodeGen.getUncached();
        }
    }

    public static abstract class SubstringByteIndexNode
    extends AbstractPublicNode {
        SubstringByteIndexNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, int var3, Encoding var4, boolean var5);

        static boolean isSame(int v0, int v1) {
            return v0 == v1;
        }

        @Specialization(guards={"isSame(byteLength, 0)"})
        static TruffleString substringEmpty(AbstractTruffleString a, int fromByteIndex, int byteLength, Encoding expectedEncoding, boolean lazy) {
            a.checkEncoding(expectedEncoding);
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndex, 0);
            return expectedEncoding.getEmpty();
        }

        @Specialization(guards={"byteLength != 0"})
        final TruffleString substringRaw(AbstractTruffleString a, int fromByteIndex, int byteLength, Encoding expectedEncoding, boolean lazy, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.SubstringNode substringNode) {
            a.checkEncoding(expectedEncoding);
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, expectedEncoding);
            int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndex, length);
            return substringNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), a.codeRange(), expectedEncoding, fromIndex, length, lazy && a.isImmutable());
        }

        @NeverDefault
        public static SubstringByteIndexNode create() {
            return TruffleStringFactory.SubstringByteIndexNodeGen.create();
        }

        public static SubstringByteIndexNode getUncached() {
            return TruffleStringFactory.SubstringByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class SubstringNode
    extends AbstractPublicNode {
        SubstringNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, int var3, Encoding var4, boolean var5);

        @Specialization
        final TruffleString substring(AbstractTruffleString a, int fromIndex, int length, Encoding encoding, boolean lazy, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CodePointIndexToRawNode translateIndexNode, @Cached TStringInternalNodes.SubstringNode substringNode) {
            a.checkEncoding(encoding);
            a.boundsCheckRegion(this, fromIndex, length, encoding, getCodePointLengthNode);
            if (length == 0) {
                return encoding.getEmpty();
            }
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int fromIndexRaw = translateIndexNode.execute(this, a, arrayA, codeRangeA, encoding, 0, fromIndex, false);
            int lengthRaw = translateIndexNode.execute(this, a, arrayA, codeRangeA, encoding, fromIndexRaw, length, true);
            return substringNode.execute(this, a, arrayA, codeRangeA, encoding, fromIndexRaw, lengthRaw, lazy && a.isImmutable());
        }

        @NeverDefault
        public static SubstringNode create() {
            return TruffleStringFactory.SubstringNodeGen.create();
        }

        public static SubstringNode getUncached() {
            return TruffleStringFactory.SubstringNodeGen.getUncached();
        }
    }

    public static abstract class RepeatNode
    extends AbstractPublicNode {
        RepeatNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, int var2, Encoding var3);

        @Specialization
        final TruffleString repeat(AbstractTruffleString a, int n, Encoding expectedEncoding, @Cached AsTruffleStringNode asTruffleStringNode, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode, @Cached InlinedConditionProfile brokenProfile, @Cached InlinedBranchProfile outOfMemoryProfile) {
            a.checkEncoding(expectedEncoding);
            if (n < 0) {
                throw InternalErrors.illegalArgument("n must be positive");
            }
            if (a.isEmpty() || n == 0) {
                return expectedEncoding.getEmpty();
            }
            if (n == 1) {
                return asTruffleStringNode.execute(a, expectedEncoding);
            }
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getPreciseCodeRangeNode.execute(this, a, expectedEncoding);
            int codePointLengthA = getCodePointLengthNode.execute(this, a, expectedEncoding);
            int byteLengthA = a.length() << a.stride();
            long byteLength = (long)byteLengthA * (long)n;
            if (Long.compareUnsigned(byteLength, 0x7FFFFFF7L) > 0) {
                outOfMemoryProfile.enter(this);
                throw InternalErrors.outOfMemory();
            }
            byte[] array = new byte[(int)byteLength];
            int offsetB = 0;
            for (int i = 0; i < n; ++i) {
                TStringOps.arraycopyWithStride(this, arrayA, a.offset(), 0, 0, array, offsetB, 0, 0, byteLengthA);
                offsetB += byteLengthA;
                TStringConstants.truffleSafePointPoll(this, i + 1);
            }
            int length = (int)(byteLength >> a.stride());
            if (brokenProfile.profile(this, TStringGuards.isBroken(codeRangeA))) {
                long attrs = calcStringAttributesNode.execute(this, null, array, 0, length, a.stride(), expectedEncoding, 0, codeRangeA);
                codeRangeA = StringAttributes.getCodeRange(attrs);
                codePointLengthA = StringAttributes.getCodePointLength(attrs);
            } else {
                codePointLengthA *= n;
            }
            return TruffleString.createFromByteArray(array, length, a.stride(), expectedEncoding, codePointLengthA, codeRangeA);
        }

        @NeverDefault
        public static RepeatNode create() {
            return TruffleStringFactory.RepeatNodeGen.create();
        }

        public static RepeatNode getUncached() {
            return TruffleStringFactory.RepeatNodeGen.getUncached();
        }
    }

    public static abstract class ConcatNode
    extends AbstractPublicNode {
        ConcatNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3, boolean var4);

        @Specialization(guards={"isEmpty(a)"})
        static TruffleString aEmpty(AbstractTruffleString a, TruffleString b, Encoding expectedEncoding, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                b.looseCheckEncoding(expectedEncoding, b.codeRange());
                return b.switchEncodingUncached(expectedEncoding);
            }
            b.checkEncoding(expectedEncoding);
            return b;
        }

        @Specialization(guards={"isEmpty(a)"})
        TruffleString aEmptyMutable(AbstractTruffleString a, MutableTruffleString b, Encoding expectedEncoding, boolean lazy, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                b.looseCheckEncoding(expectedEncoding, b.codeRange());
                return b.switchEncodingUncached(expectedEncoding);
            }
            return attributesNode.execute(this, b, expectedEncoding);
        }

        @Specialization(guards={"isEmpty(b)"})
        static TruffleString bEmpty(TruffleString a, AbstractTruffleString b, Encoding expectedEncoding, boolean lazy) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                a.looseCheckEncoding(expectedEncoding, a.codeRange());
                return a.switchEncodingUncached(expectedEncoding);
            }
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization(guards={"isEmpty(b)"})
        static TruffleString bEmptyMutable(MutableTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, boolean lazy, @Bind(value="this") Node node, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                a.looseCheckEncoding(expectedEncoding, a.codeRange());
                return a.switchEncodingUncached(expectedEncoding);
            }
            return attributesNode.execute(node, a, expectedEncoding);
        }

        @Specialization(guards={"!isEmpty(a)", "!isEmpty(b)"})
        static TruffleString doConcat(AbstractTruffleString a, AbstractTruffleString b, Encoding encoding, boolean lazy, @Bind(value="this") Node node, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeANode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getCodeRangeBNode, @Cached TStringInternalNodes.StrideFromCodeRangeNode getStrideNode, @Cached TStringInternalNodes.ConcatEagerNode concatEagerNode, @Cached AsTruffleStringNode asTruffleStringANode, @Cached AsTruffleStringNode asTruffleStringBNode, @Cached InlinedBranchProfile outOfMemoryProfile, @Cached InlinedConditionProfile lazyProfile) {
            CompilerAsserts.partialEvaluationConstant(lazy);
            int codeRangeA = getCodeRangeANode.execute(node, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(node, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            int commonCodeRange = TSCodeRange.commonCodeRange(codeRangeA, codeRangeB);
            assert (!TStringGuards.isBrokenMultiByte(codeRangeA) && !TStringGuards.isBrokenMultiByte(codeRangeB) || TStringGuards.isBrokenMultiByte(commonCodeRange));
            int targetStride = getStrideNode.execute(node, commonCodeRange, encoding);
            int length = ConcatNode.addByteLengths(node, a, b, targetStride, outOfMemoryProfile);
            boolean valid = !TStringGuards.isBrokenMultiByte(commonCodeRange);
            if (lazyProfile.profile(node, lazy && valid && (a.isImmutable() || b.isImmutable()) && length << targetStride >= 40)) {
                if (AbstractTruffleString.DEBUG_STRICT_ENCODING_CHECKS) {
                    return TruffleString.createLazyConcat(ConcatNode.asTruffleStringLoose(a, encoding), ConcatNode.asTruffleStringLoose(b, encoding), encoding, length, targetStride, commonCodeRange);
                }
                return TruffleString.createLazyConcat(asTruffleStringANode.execute(a, encoding), asTruffleStringBNode.execute(b, encoding), encoding, length, targetStride, commonCodeRange);
            }
            return concatEagerNode.execute(node, a, b, encoding, length, targetStride, commonCodeRange);
        }

        static int addByteLengths(Node node, AbstractTruffleString a, AbstractTruffleString b, int targetStride, InlinedBranchProfile outOfMemoryProfile) {
            long length = (long)a.length() + (long)b.length();
            if (length << targetStride > 0x7FFFFFF7L) {
                outOfMemoryProfile.enter(node);
                throw InternalErrors.outOfMemory();
            }
            return (int)length;
        }

        private static TruffleString asTruffleStringLoose(AbstractTruffleString a, Encoding encoding) {
            if (a.isImmutable()) {
                return (TruffleString)a;
            }
            return TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.getUncached().execute(TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.getUncached(), a, encoding);
        }

        @NeverDefault
        public static ConcatNode create() {
            return TruffleStringFactory.ConcatNodeGen.create();
        }

        public static ConcatNode getUncached() {
            return TruffleStringFactory.ConcatNodeGen.getUncached();
        }
    }

    public static abstract class RegionEqualByteIndexNode
    extends AbstractPublicNode {
        RegionEqualByteIndexNode() {
        }

        public final boolean execute(AbstractTruffleString a, int fromByteIndexA, AbstractTruffleString b, int fromByteIndexB, int length, Encoding expectedEncoding) {
            return this.execute(a, fromByteIndexA, b, fromByteIndexB, length, null, expectedEncoding);
        }

        public final boolean execute(AbstractTruffleString a, int fromByteIndexA, WithMask b, int fromByteIndexB, int length, Encoding expectedEncoding) {
            return this.execute(a, fromByteIndexA, b.string, fromByteIndexB, length, b.mask, expectedEncoding);
        }

        abstract boolean execute(AbstractTruffleString var1, int var2, AbstractTruffleString var3, int var4, int var5, byte[] var6, Encoding var7);

        @Specialization
        boolean regionEquals(AbstractTruffleString a, int byteFromIndexA, AbstractTruffleString b, int byteFromIndexB, int byteLength, byte[] mask, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB) {
            if (byteLength == 0) {
                return true;
            }
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            int fromIndexA = AbstractTruffleString.rawIndex(byteFromIndexA, expectedEncoding);
            int fromIndexB = AbstractTruffleString.rawIndex(byteFromIndexB, expectedEncoding);
            int length = AbstractTruffleString.rawIndex(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(fromIndexA, length);
            b.boundsCheckRegionRaw(fromIndexB, length);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            return TStringOps.regionEqualsWithOrMaskWithStride(this, a, arrayA, a.stride(), fromIndexA, b, arrayB, b.stride(), fromIndexB, mask, length);
        }

        @NeverDefault
        public static RegionEqualByteIndexNode create() {
            return TruffleStringFactory.RegionEqualByteIndexNodeGen.create();
        }

        public static RegionEqualByteIndexNode getUncached() {
            return TruffleStringFactory.RegionEqualByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class RegionEqualNode
    extends AbstractPublicNode {
        RegionEqualNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, int var2, AbstractTruffleString var3, int var4, int var5, Encoding var6);

        @Specialization
        final boolean regionEquals(AbstractTruffleString a, int fromIndexA, AbstractTruffleString b, int fromIndexB, int length, Encoding encoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.RegionEqualsNode regionEqualsNode) {
            if (length == 0) {
                return true;
            }
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(this, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            a.boundsCheckRegion(this, fromIndexA, length, encoding, getCodePointLengthANode);
            b.boundsCheckRegion(this, fromIndexB, length, encoding, getCodePointLengthBNode);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            return regionEqualsNode.execute(this, a, arrayA, codeRangeA, fromIndexA, b, arrayB, codeRangeB, fromIndexB, length, encoding);
        }

        @NeverDefault
        public static RegionEqualNode create() {
            return TruffleStringFactory.RegionEqualNodeGen.create();
        }

        public static RegionEqualNode getUncached() {
            return TruffleStringFactory.RegionEqualNodeGen.getUncached();
        }
    }

    public static abstract class CompareIntsUTF32Node
    extends AbstractPublicNode {
        CompareIntsUTF32Node() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2);

        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB) {
            int cmp;
            a.looseCheckEncoding(Encoding.UTF_32, a.codeRange());
            b.looseCheckEncoding(Encoding.UTF_32, b.codeRange());
            Object aData = toIndexableNodeA.execute(this, a, a.data());
            Object bData = toIndexableNodeB.execute(this, b, b.data());
            if (aData instanceof byte[] && bData instanceof byte[] && (a.stride() | b.stride()) == 0 && a.length() != 0 && b.length() != 0 && (cmp = Byte.compareUnsigned(((byte[])aData)[a.offset()], ((byte[])bData)[b.offset()])) != 0) {
                return cmp;
            }
            if (a == b) {
                return 0;
            }
            return TStringOpsNodes.memcmp(this, a, aData, b, bData);
        }

        @NeverDefault
        public static CompareIntsUTF32Node create() {
            return TruffleStringFactory.CompareIntsUTF32NodeGen.create();
        }

        public static CompareIntsUTF32Node getUncached() {
            return TruffleStringFactory.CompareIntsUTF32NodeGen.getUncached();
        }
    }

    public static abstract class CompareCharsUTF16Node
    extends AbstractPublicNode {
        CompareCharsUTF16Node() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2);

        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB) {
            int cmp;
            a.looseCheckEncoding(Encoding.UTF_16, a.codeRange());
            b.looseCheckEncoding(Encoding.UTF_16, b.codeRange());
            Object aData = toIndexableNodeA.execute(this, a, a.data());
            Object bData = toIndexableNodeB.execute(this, b, b.data());
            if (aData instanceof byte[] && bData instanceof byte[] && (a.stride() | b.stride()) == 0 && a.length() != 0 && b.length() != 0 && (cmp = Byte.compareUnsigned(((byte[])aData)[a.offset()], ((byte[])bData)[b.offset()])) != 0) {
                return cmp;
            }
            if (a == b) {
                return 0;
            }
            return TStringOpsNodes.memcmp(this, a, aData, b, bData);
        }

        @NeverDefault
        public static CompareCharsUTF16Node create() {
            return TruffleStringFactory.CompareCharsUTF16NodeGen.create();
        }

        public static CompareCharsUTF16Node getUncached() {
            return TruffleStringFactory.CompareCharsUTF16NodeGen.getUncached();
        }
    }

    public static abstract class CompareBytesNode
    extends AbstractPublicNode {
        CompareBytesNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, Encoding var3);

        @Specialization
        int compare(AbstractTruffleString a, AbstractTruffleString b, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB) {
            int cmp;
            AbstractTruffleString.nullCheck((Object)expectedEncoding);
            a.looseCheckEncoding(expectedEncoding, a.codeRange());
            b.looseCheckEncoding(expectedEncoding, b.codeRange());
            Object aData = toIndexableNodeA.execute(this, a, a.data());
            Object bData = toIndexableNodeB.execute(this, b, b.data());
            if (aData instanceof byte[] && bData instanceof byte[] && (a.stride() | b.stride()) == 0 && a.length() != 0 && b.length() != 0 && (cmp = Byte.compareUnsigned(((byte[])aData)[a.offset()], ((byte[])bData)[b.offset()])) != 0) {
                return cmp;
            }
            if (a == b) {
                return 0;
            }
            return TStringOpsNodes.memcmpBytes(this, a, aData, b, bData);
        }

        @NeverDefault
        public static CompareBytesNode create() {
            return TruffleStringFactory.CompareBytesNodeGen.create();
        }

        public static CompareBytesNode getUncached() {
            return TruffleStringFactory.CompareBytesNodeGen.getUncached();
        }
    }

    public static abstract class LastByteIndexOfStringNode
    extends AbstractPublicNode {
        LastByteIndexOfStringNode() {
        }

        public final int execute(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding expectedEncoding) {
            return this.execute(a, b, fromIndex, toIndex, null, expectedEncoding);
        }

        public final int execute(AbstractTruffleString a, WithMask b, int fromIndex, int toIndex, Encoding expectedEncoding) {
            return this.execute(a, b.string, fromIndex, toIndex, b.mask, expectedEncoding);
        }

        abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, byte[] var5, Encoding var6);

        @Specialization
        final int lastByteIndexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndexB, int toIndexB, byte[] mask, Encoding encoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.LastIndexOfStringRawNode indexOfStringNode) {
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(this, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            if (mask != null && TStringGuards.isUnsupportedEncoding(encoding) && !TStringGuards.isFixedWidth(codeRangeA)) {
                throw InternalErrors.unsupportedOperation();
            }
            if (b.isEmpty()) {
                return fromIndexB;
            }
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromIndexB, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toIndexB, encoding);
            a.boundsCheckRaw(toIndex, fromIndex);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            if (TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, fromIndex - toIndex)) {
                return -1;
            }
            return AbstractTruffleString.byteIndex(indexOfStringNode.execute(this, a, arrayA, codeRangeA, b, arrayB, codeRangeB, fromIndex, toIndex, mask, encoding), encoding);
        }

        @NeverDefault
        public static LastByteIndexOfStringNode create() {
            return TruffleStringFactory.LastByteIndexOfStringNodeGen.create();
        }

        public static LastByteIndexOfStringNode getUncached() {
            return TruffleStringFactory.LastByteIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class LastIndexOfStringNode
    extends AbstractPublicNode {
        LastIndexOfStringNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, Encoding var5);

        @Specialization
        final int lastIndexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.LastIndexOfStringNode indexOfStringNode) {
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(this, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            if (b.isEmpty()) {
                return fromIndex;
            }
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheck(this, toIndex, fromIndex, encoding, getCodePointLengthANode);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            if (TStringGuards.indexOfCannotMatch(this, codeRangeA, b, codeRangeB, fromIndex - toIndex, encoding, getCodePointLengthBNode)) {
                return -1;
            }
            return indexOfStringNode.execute(this, a, arrayA, codeRangeA, b, arrayB, codeRangeB, fromIndex, toIndex, encoding);
        }

        @NeverDefault
        public static LastIndexOfStringNode create() {
            return TruffleStringFactory.LastIndexOfStringNodeGen.create();
        }

        public static LastIndexOfStringNode getUncached() {
            return TruffleStringFactory.LastIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfStringNode
    extends AbstractPublicNode {
        ByteIndexOfStringNode() {
        }

        public final int execute(AbstractTruffleString a, AbstractTruffleString b, int fromByteIndex, int toByteIndex, Encoding expectedEncoding) {
            return this.execute(a, b, fromByteIndex, toByteIndex, null, expectedEncoding);
        }

        public final int execute(AbstractTruffleString a, WithMask b, int fromByteIndex, int toByteIndex, Encoding expectedEncoding) {
            return this.execute(a, b.string, fromByteIndex, toByteIndex, b.mask, expectedEncoding);
        }

        abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, byte[] var5, Encoding var6);

        @Specialization
        final int indexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromByteIndex, int toByteIndex, byte[] mask, Encoding encoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.IndexOfStringRawNode indexOfStringNode) {
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(this, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            if (mask != null && TStringGuards.isUnsupportedEncoding(encoding) && !TStringGuards.isFixedWidth(codeRangeA)) {
                throw InternalErrors.unsupportedOperation();
            }
            if (b.isEmpty()) {
                return fromByteIndex;
            }
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            if (TStringGuards.indexOfCannotMatch(codeRangeA, b, codeRangeB, mask, toIndex - fromIndex)) {
                return -1;
            }
            return AbstractTruffleString.byteIndex(indexOfStringNode.execute(this, a, arrayA, codeRangeA, b, arrayB, codeRangeB, fromIndex, toIndex, mask, encoding), encoding);
        }

        @NeverDefault
        public static ByteIndexOfStringNode create() {
            return TruffleStringFactory.ByteIndexOfStringNodeGen.create();
        }

        public static ByteIndexOfStringNode getUncached() {
            return TruffleStringFactory.ByteIndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class IndexOfStringNode
    extends AbstractPublicNode {
        IndexOfStringNode() {
        }

        public abstract int execute(AbstractTruffleString var1, AbstractTruffleString var2, int var3, int var4, Encoding var5);

        @Specialization
        final int indexOfString(AbstractTruffleString a, AbstractTruffleString b, int fromIndex, int toIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNodeA, @Cached ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeBNode, @Cached TStringInternalNodes.InternalIndexOfStringNode indexOfStringNode) {
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int codeRangeB = getCodeRangeBNode.execute(this, b, encoding);
            a.looseCheckEncoding(encoding, codeRangeA);
            b.looseCheckEncoding(encoding, codeRangeB);
            if (b.isEmpty()) {
                return fromIndex;
            }
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheck(this, fromIndex, toIndex, encoding, getCodePointLengthANode);
            Object arrayA = toIndexableNodeA.execute(this, a, a.data());
            Object arrayB = toIndexableNodeB.execute(this, b, b.data());
            if (TStringGuards.indexOfCannotMatch(this, codeRangeA, b, codeRangeB, toIndex - fromIndex, encoding, getCodePointLengthBNode)) {
                return -1;
            }
            return indexOfStringNode.execute(this, a, arrayA, codeRangeA, b, arrayB, codeRangeB, fromIndex, toIndex, encoding);
        }

        @NeverDefault
        public static IndexOfStringNode create() {
            return TruffleStringFactory.IndexOfStringNodeGen.create();
        }

        public static IndexOfStringNode getUncached() {
            return TruffleStringFactory.IndexOfStringNodeGen.getUncached();
        }
    }

    public static abstract class LastByteIndexOfCodePointNode
    extends AbstractPublicNode {
        LastByteIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromByteIndex, int toByteIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.LastIndexOfCodePointRawNode lastIndexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(toIndex, fromIndex);
            return AbstractTruffleString.byteIndex(lastIndexOfNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), getCodeRangeNode.execute(this, a, encoding), encoding, codepoint, fromIndex, toIndex), encoding);
        }

        @NeverDefault
        public static LastByteIndexOfCodePointNode create() {
            return TruffleStringFactory.LastByteIndexOfCodePointNodeGen.create();
        }

        public static LastByteIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.LastByteIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class LastIndexOfCodePointNode
    extends AbstractPublicNode {
        LastIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromIndex, int toIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.LastIndexOfCodePointNode lastIndexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheck(this, toIndex, fromIndex, encoding, getCodePointLengthNode);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            return lastIndexOfNode.execute(this, a, arrayA, getCodeRangeNode.execute(this, a, encoding), encoding, codepoint, fromIndex, toIndex);
        }

        @NeverDefault
        public static LastIndexOfCodePointNode create() {
            return TruffleStringFactory.LastIndexOfCodePointNodeGen.create();
        }

        public static LastIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.LastIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfCodePointNode
    extends AbstractPublicNode {
        ByteIndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromByteIndex, int toByteIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.IndexOfCodePointRawNode indexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            return AbstractTruffleString.byteIndex(indexOfNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), getCodeRangeNode.execute(this, a, encoding), encoding, codepoint, fromIndex, toIndex), encoding);
        }

        @NeverDefault
        public static ByteIndexOfCodePointNode create() {
            return TruffleStringFactory.ByteIndexOfCodePointNodeGen.create();
        }

        public static ByteIndexOfCodePointNode getUncached() {
            return TruffleStringFactory.ByteIndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class IndexOfCodePointNode
    extends AbstractPublicNode {
        IndexOfCodePointNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int var4, Encoding var5);

        @Specialization
        final int doIndexOf(AbstractTruffleString a, int codepoint, int fromIndex, int toIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.IndexOfCodePointNode indexOfNode) {
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheck(this, fromIndex, toIndex, encoding, getCodePointLengthNode);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            return indexOfNode.execute(this, a, arrayA, getCodeRangeNode.execute(this, a, encoding), encoding, codepoint, fromIndex, toIndex);
        }

        @NeverDefault
        public static IndexOfCodePointNode create() {
            return TruffleStringFactory.IndexOfCodePointNodeGen.create();
        }

        public static IndexOfCodePointNode getUncached() {
            return TruffleStringFactory.IndexOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfCodePointSetNode
    extends AbstractPublicNode {
        ByteIndexOfCodePointSetNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, CodePointSet var4);

        @Specialization(guards={"codePointSet == cachedCodePointSet"}, limit="1")
        static int indexOfSpecialized(AbstractTruffleString a, int fromByteIndex, int toByteIndex, CodePointSet codePointSet, @Bind(value="this") Node node, @Cached @Cached.Shared ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode, @Cached(value="codePointSet") CodePointSet cachedCodePointSet, @Cached(value="cachedCodePointSet.createNode()") TStringInternalNodes.IndexOfCodePointSetNode internalNode) {
            Encoding encoding = cachedCodePointSet.encoding;
            CompilerAsserts.partialEvaluationConstant(codePointSet);
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return -1;
            }
            Object arrayA = toIndexableNode.execute(node, a, a.data());
            return AbstractTruffleString.byteIndex(internalNode.execute(arrayA, a.offset(), a.length(), a.stride(), getPreciseCodeRangeNode.execute(node, a, encoding), fromIndex, toIndex), encoding);
        }

        @Specialization(replaces={"indexOfSpecialized"})
        int indexOfUncached(AbstractTruffleString a, int fromByteIndex, int toByteIndex, CodePointSet codePointSet, @Cached @Cached.Shared ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TruffleStringIterator.InternalNextNode nextNode) {
            Encoding encoding = codePointSet.encoding;
            CompilerAsserts.partialEvaluationConstant(codePointSet);
            CompilerAsserts.partialEvaluationConstant((Object)encoding);
            a.checkEncoding(encoding);
            if (a.isEmpty()) {
                return -1;
            }
            int fromIndex = AbstractTruffleString.rawIndex(fromByteIndex, encoding);
            int toIndex = AbstractTruffleString.rawIndex(toByteIndex, encoding);
            a.boundsCheckRaw(fromIndex, toIndex);
            if (fromIndex == toIndex) {
                return -1;
            }
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeNode.execute(this, a, encoding);
            TruffleStringIterator it = AbstractTruffleString.forwardIterator(a, arrayA, codeRangeA, encoding);
            it.setRawIndex(fromIndex);
            while (it.getRawIndex() < toIndex) {
                assert (it.hasNext());
                int index = it.getByteIndex();
                if (!IndexOfCodePointSet.IndexOfRangesNode.rangesContain(codePointSet.ranges, nextNode.execute(this, it))) continue;
                return index;
            }
            return -1;
        }

        public static ByteIndexOfCodePointSetNode create() {
            return TruffleStringFactory.ByteIndexOfCodePointSetNodeGen.create();
        }

        public static ByteIndexOfCodePointSetNode getUncached() {
            return TruffleStringFactory.ByteIndexOfCodePointSetNodeGen.getUncached();
        }
    }

    public static final class CodePointSet {
        private final int[] ranges;
        private final Encoding encoding;
        private final IndexOfCodePointSet.IndexOfNode[] indexOfNodes;

        CodePointSet(int[] ranges, Encoding encoding, IndexOfCodePointSet.IndexOfNode[] indexOfNodes) {
            this.ranges = ranges;
            this.encoding = encoding;
            this.indexOfNodes = indexOfNodes;
        }

        @CompilerDirectives.TruffleBoundary
        public static CodePointSet fromRanges(int[] ranges, Encoding encoding) {
            int[] rangesDefensiveCopy = Arrays.copyOf(ranges, ranges.length);
            return new CodePointSet(rangesDefensiveCopy, encoding, IndexOfCodePointSet.fromRanges(rangesDefensiveCopy, encoding));
        }

        TStringInternalNodes.IndexOfCodePointSetNode createNode() {
            IndexOfCodePointSet.IndexOfNode[] nodesCopy = new IndexOfCodePointSet.IndexOfNode[this.indexOfNodes.length];
            for (int i = 0; i < this.indexOfNodes.length; ++i) {
                nodesCopy[i] = this.indexOfNodes[i].shallowCopy();
            }
            return TStringInternalNodesFactory.IndexOfCodePointSetNodeGen.create(nodesCopy, this.encoding);
        }

        public boolean isIntrinsicCandidate(CodeRange codeRange) {
            for (int i = 0; i < this.indexOfNodes.length - 1; ++i) {
                IndexOfCodePointSet.IndexOfNode node = this.indexOfNodes[i];
                if (TSCodeRange.ordinal(node.maxCodeRange) < codeRange.ordinal()) continue;
                return node.isFast();
            }
            return this.indexOfNodes[this.indexOfNodes.length - 1].isFast();
        }
    }

    public static abstract class IntIndexOfAnyIntUTF32Node
    extends AbstractPublicNode {
        IntIndexOfAnyIntUTF32Node() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, int[] var4);

        @Specialization
        int indexOfRaw(AbstractTruffleString a, int fromIntIndex, int maxIntIndex, int[] values, @Cached ToIndexableNode toIndexableNode, @Cached TStringOpsNodes.IndexOfAnyIntNode indexOfNode) {
            a.checkEncoding(Encoding.UTF_32);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromIntIndex, maxIntIndex);
            if (fromIntIndex == maxIntIndex || TruffleString.noneInCodeRange((Node)this, a.codeRange(), values)) {
                return -1;
            }
            return indexOfNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), fromIntIndex, maxIntIndex, values);
        }

        @NeverDefault
        public static IntIndexOfAnyIntUTF32Node create() {
            return TruffleStringFactory.IntIndexOfAnyIntUTF32NodeGen.create();
        }

        public static IntIndexOfAnyIntUTF32Node getUncached() {
            return TruffleStringFactory.IntIndexOfAnyIntUTF32NodeGen.getUncached();
        }
    }

    public static abstract class CharIndexOfAnyCharUTF16Node
    extends AbstractPublicNode {
        CharIndexOfAnyCharUTF16Node() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, char[] var4);

        @Specialization
        final int indexOfRaw(AbstractTruffleString a, int fromCharIndex, int maxCharIndex, char[] values, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringOpsNodes.IndexOfAnyCharNode indexOfNode) {
            a.checkEncoding(Encoding.UTF_16);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromCharIndex, maxCharIndex);
            int codeRangeA = getCodeRangeNode.execute(this, a, Encoding.UTF_16);
            if (fromCharIndex == maxCharIndex || TSCodeRange.isFixedWidth(codeRangeA) && TruffleString.noneInCodeRange((Node)this, codeRangeA, values)) {
                return -1;
            }
            return indexOfNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), fromCharIndex, maxCharIndex, values);
        }

        @NeverDefault
        public static CharIndexOfAnyCharUTF16Node create() {
            return TruffleStringFactory.CharIndexOfAnyCharUTF16NodeGen.create();
        }

        public static CharIndexOfAnyCharUTF16Node getUncached() {
            return TruffleStringFactory.CharIndexOfAnyCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexOfAnyByteNode
    extends AbstractPublicNode {
        ByteIndexOfAnyByteNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, byte[] var4, Encoding var5);

        @Specialization
        int indexOfRaw(AbstractTruffleString a, int fromByteIndex, int maxByteIndex, byte[] values, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNode) {
            if (TStringGuards.isUTF16Or32(expectedEncoding)) {
                throw InternalErrors.illegalArgument("UTF-16 and UTF-32 not supported!");
            }
            a.checkEncoding(expectedEncoding);
            if (a.isEmpty()) {
                return -1;
            }
            a.boundsCheckRaw(fromByteIndex, maxByteIndex);
            if (fromByteIndex == maxByteIndex || TSCodeRange.is7Bit(a.codeRange()) && TruffleString.noneIsAscii(this, values)) {
                return -1;
            }
            assert (TStringGuards.isStride0(a));
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            return TStringOps.indexOfAnyByte(this, a, arrayA, fromByteIndex, maxByteIndex, values);
        }

        @NeverDefault
        public static ByteIndexOfAnyByteNode create() {
            return TruffleStringFactory.ByteIndexOfAnyByteNodeGen.create();
        }

        public static ByteIndexOfAnyByteNode getUncached() {
            return TruffleStringFactory.ByteIndexOfAnyByteNodeGen.getUncached();
        }
    }

    public static abstract class CodePointAtByteIndexNode
    extends AbstractPublicNode {
        CodePointAtByteIndexNode() {
        }

        public final int execute(AbstractTruffleString a, int i, Encoding expectedEncoding) {
            return this.execute(a, i, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        @Specialization
        final int readCodePoint(AbstractTruffleString a, int byteIndex, Encoding encoding, ErrorHandling errorHandling, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointAtRawNode readCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            int i = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.checkEncoding(encoding);
            a.boundsCheckRaw(i);
            return readCodePointNode.execute(this, a, toIndexableNode.execute(this, a, a.data()), getCodeRangeNode.execute(this, a, encoding), encoding, i, errorHandling);
        }

        @NeverDefault
        public static CodePointAtByteIndexNode create() {
            return TruffleStringFactory.CodePointAtByteIndexNodeGen.create();
        }

        public static CodePointAtByteIndexNode getUncached() {
            return TruffleStringFactory.CodePointAtByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class CodePointAtIndexNode
    extends AbstractPublicNode {
        CodePointAtIndexNode() {
        }

        public final int execute(AbstractTruffleString a, int i, Encoding expectedEncoding) {
            return this.execute(a, i, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        @Specialization
        final int readCodePoint(AbstractTruffleString a, int i, Encoding encoding, ErrorHandling errorHandling, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointAtNode readCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            a.boundsCheck(this, i, encoding, getCodePointLengthNode);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            return readCodePointNode.execute(this, a, arrayA, getCodeRangeNode.execute(this, a, encoding), encoding, i, errorHandling);
        }

        @NeverDefault
        public static CodePointAtIndexNode create() {
            return TruffleStringFactory.CodePointAtIndexNodeGen.create();
        }

        public static CodePointAtIndexNode getUncached() {
            return TruffleStringFactory.CodePointAtIndexNodeGen.getUncached();
        }
    }

    public static abstract class CodePointIndexToByteIndexNode
    extends AbstractPublicNode {
        CodePointIndexToByteIndexNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, Encoding var4);

        @Specialization
        final int translate(AbstractTruffleString a, int byteOffset, int codepointIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.CodePointIndexToRawNode codePointIndexToRawNode) {
            a.checkEncoding(encoding);
            a.boundsCheckRegion(this, 0, codepointIndex, encoding, getCodePointLengthNode);
            int rawOffset = AbstractTruffleString.rawIndex(byteOffset, encoding);
            a.boundsCheckRawLength(rawOffset);
            if (codepointIndex == 0) {
                return 0;
            }
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeNode.execute(this, a, encoding);
            return codePointIndexToRawNode.execute(this, a, arrayA, codeRangeA, encoding, rawOffset, codepointIndex, true) << encoding.naturalStride;
        }

        @NeverDefault
        public static CodePointIndexToByteIndexNode create() {
            return TruffleStringFactory.CodePointIndexToByteIndexNodeGen.create();
        }

        public static CodePointIndexToByteIndexNode getUncached() {
            return TruffleStringFactory.CodePointIndexToByteIndexNodeGen.getUncached();
        }
    }

    public static abstract class ByteIndexToCodePointIndexNode
    extends AbstractPublicNode {
        ByteIndexToCodePointIndexNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, int var3, Encoding var4);

        @Specialization
        final int translate(AbstractTruffleString a, int byteOffset, int byteIndex, Encoding encoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.RawIndexToCodePointIndexNode rawIndexToCodePointIndexNode) {
            a.checkEncoding(encoding);
            int rawOffset = AbstractTruffleString.rawIndex(byteOffset, encoding);
            int rawIndex = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.boundsCheckRegionRaw(rawOffset, rawIndex);
            if (byteIndex == 0) {
                return 0;
            }
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeNode.execute(this, a, encoding);
            return rawIndexToCodePointIndexNode.execute(this, a, arrayA, codeRangeA, encoding, byteOffset, rawIndex);
        }

        @NeverDefault
        public static ByteIndexToCodePointIndexNode create() {
            return TruffleStringFactory.ByteIndexToCodePointIndexNodeGen.create();
        }

        public static ByteIndexToCodePointIndexNode getUncached() {
            return TruffleStringFactory.ByteIndexToCodePointIndexNodeGen.getUncached();
        }
    }

    public static abstract class ByteLengthOfCodePointNode
    extends AbstractPublicNode {
        ByteLengthOfCodePointNode() {
        }

        public final int execute(AbstractTruffleString a, int byteIndex, Encoding expectedEncoding) {
            return this.execute(a, byteIndex, expectedEncoding, ErrorHandling.BEST_EFFORT);
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3, ErrorHandling var4);

        @Specialization
        final int translate(AbstractTruffleString a, int byteIndex, Encoding encoding, ErrorHandling errorHandling, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeNode, @Cached TStringInternalNodes.ByteLengthOfCodePointNode byteLengthOfCodePointNode) {
            CompilerAsserts.partialEvaluationConstant((Object)errorHandling);
            a.checkEncoding(encoding);
            int rawIndex = AbstractTruffleString.rawIndex(byteIndex, encoding);
            a.boundsCheckRaw(rawIndex);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeNode.execute(this, a, encoding);
            return byteLengthOfCodePointNode.execute(this, a, arrayA, codeRangeA, encoding, rawIndex, errorHandling);
        }

        @NeverDefault
        public static ByteLengthOfCodePointNode create() {
            return TruffleStringFactory.ByteLengthOfCodePointNodeGen.create();
        }

        public static ByteLengthOfCodePointNode getUncached() {
            return TruffleStringFactory.ByteLengthOfCodePointNodeGen.getUncached();
        }
    }

    public static abstract class ReadCharUTF16Node
    extends AbstractPublicNode {
        ReadCharUTF16Node() {
        }

        public abstract char execute(AbstractTruffleString var1, int var2);

        @Specialization
        final char doRead(AbstractTruffleString a, int i, @Cached ToIndexableNode toIndexableNode, @Cached InlinedConditionProfile utf16S0Profile) {
            a.checkEncoding(Encoding.UTF_16);
            a.boundsCheckRaw(i);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            if (utf16S0Profile.profile(this, TStringGuards.isStride0(a))) {
                return (char)TStringOps.readS0(a, arrayA, i);
            }
            assert (TStringGuards.isStride1(a));
            return TStringOps.readS1(a, arrayA, i);
        }

        @NeverDefault
        public static ReadCharUTF16Node create() {
            return TruffleStringFactory.ReadCharUTF16NodeGen.create();
        }

        public static ReadCharUTF16Node getUncached() {
            return TruffleStringFactory.ReadCharUTF16NodeGen.getUncached();
        }
    }

    public static abstract class ReadByteNode
    extends AbstractPublicNode {
        ReadByteNode() {
        }

        public abstract int execute(AbstractTruffleString var1, int var2, Encoding var3);

        @Specialization
        final int doRead(AbstractTruffleString a, int i, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.ReadByteNode readByteNode) {
            a.checkEncoding(expectedEncoding);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            return readByteNode.execute(this, a, arrayA, i, expectedEncoding);
        }

        @NeverDefault
        public static ReadByteNode create() {
            return TruffleStringFactory.ReadByteNodeGen.create();
        }

        public static ReadByteNode getUncached() {
            return TruffleStringFactory.ReadByteNodeGen.getUncached();
        }
    }

    public static abstract class HashCodeNode
    extends AbstractPublicNode {
        HashCodeNode() {
        }

        public abstract int execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final int calculateHash(AbstractTruffleString a, Encoding expectedEncoding, @Cached InlinedConditionProfile cacheMiss, @Cached ToIndexableNode toIndexableNode, @Cached TStringOpsNodes.CalculateHashCodeNode calculateHashCodeNode) {
            a.checkEncoding(expectedEncoding);
            int h = a.hashCode;
            if (cacheMiss.profile(this, h == 0)) {
                h = calculateHashCodeNode.execute(this, a, toIndexableNode.execute(this, a, a.data()));
                if (h == 0) {
                    --h;
                }
                a.hashCode = h;
            }
            return h;
        }

        @NeverDefault
        public static HashCodeNode create() {
            return TruffleStringFactory.HashCodeNodeGen.create();
        }

        public static HashCodeNode getUncached() {
            return TruffleStringFactory.HashCodeNodeGen.getUncached();
        }
    }

    public static abstract class CodePointLengthNode
    extends AbstractPublicNode {
        CodePointLengthNode() {
        }

        public abstract int execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final int get(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode) {
            a.checkEncoding(expectedEncoding);
            return getCodePointLengthNode.execute(this, a, expectedEncoding);
        }

        @NeverDefault
        public static CodePointLengthNode create() {
            return TruffleStringFactory.CodePointLengthNodeGen.create();
        }

        public static CodePointLengthNode getUncached() {
            return TruffleStringFactory.CodePointLengthNodeGen.getUncached();
        }
    }

    public static abstract class GetStringCompactionLevelNode
    extends AbstractPublicNode {
        GetStringCompactionLevelNode() {
        }

        public abstract CompactionLevel execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static CompactionLevel getStringCompactionLevel(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            int stride = a.stride();
            if (CompilerDirectives.isPartialEvaluationConstant((Object)expectedEncoding)) {
                if (TStringGuards.isUTF16(expectedEncoding)) {
                    return stride == 0 ? CompactionLevel.S1 : CompactionLevel.S2;
                }
                if (TStringGuards.isUTF32(expectedEncoding)) {
                    return CompactionLevel.fromStride(stride);
                }
                return CompactionLevel.S1;
            }
            return CompactionLevel.fromStride(stride);
        }

        @NeverDefault
        public static GetStringCompactionLevelNode create() {
            return TruffleStringFactory.GetStringCompactionLevelNodeGen.create();
        }

        public static GetStringCompactionLevelNode getUncached() {
            return TruffleStringFactory.GetStringCompactionLevelNodeGen.getUncached();
        }
    }

    public static final class CompactionLevel
    extends Enum<CompactionLevel> {
        public static final /* enum */ CompactionLevel S1 = new CompactionLevel(1, 0);
        public static final /* enum */ CompactionLevel S2 = new CompactionLevel(2, 1);
        public static final /* enum */ CompactionLevel S4 = new CompactionLevel(4, 2);
        private final int bytes;
        private final int log2;
        private static final /* synthetic */ CompactionLevel[] $VALUES;

        public static CompactionLevel[] values() {
            return (CompactionLevel[])$VALUES.clone();
        }

        public static CompactionLevel valueOf(String name) {
            return Enum.valueOf(CompactionLevel.class, name);
        }

        private CompactionLevel(int bytes, int log2) {
            this.bytes = bytes;
            this.log2 = log2;
        }

        int getStride() {
            return this.log2;
        }

        public final int getBytes() {
            return this.bytes;
        }

        public final int getLog2() {
            return this.log2;
        }

        static CompactionLevel fromStride(int stride) {
            assert (Stride.isStride(stride));
            if (stride == 0) {
                return S1;
            }
            if (stride == 1) {
                return S2;
            }
            assert (stride == 2);
            return S4;
        }

        private static /* synthetic */ CompactionLevel[] $values() {
            return new CompactionLevel[]{S1, S2, S4};
        }

        static {
            $VALUES = CompactionLevel.$values();
        }
    }

    public static abstract class IsValidNode
    extends AbstractPublicNode {
        IsValidNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final boolean isValid(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return !TStringGuards.isBroken(getPreciseCodeRangeNode.execute(this, a, expectedEncoding));
        }

        @NeverDefault
        public static IsValidNode create() {
            return TruffleStringFactory.IsValidNodeGen.create();
        }

        public static IsValidNode getUncached() {
            return TruffleStringFactory.IsValidNodeGen.getUncached();
        }
    }

    public static abstract class CodeRangeEqualsNode
    extends AbstractPublicNode {
        CodeRangeEqualsNode() {
        }

        public abstract boolean execute(AbstractTruffleString var1, CodeRange var2);

        @Specialization
        final boolean codeRangeEquals(AbstractTruffleString a, CodeRange codeRange, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            return CodeRange.equals(getPreciseCodeRangeNode.execute(this, a, Encoding.get(a.encoding())), codeRange);
        }

        @NeverDefault
        public static CodeRangeEqualsNode create() {
            return TruffleStringFactory.CodeRangeEqualsNodeGen.create();
        }

        public static CodeRangeEqualsNode getUncached() {
            return TruffleStringFactory.CodeRangeEqualsNodeGen.getUncached();
        }
    }

    public static abstract class GetByteCodeRangeNode
    extends AbstractPublicNode {
        GetByteCodeRangeNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.getByteCodeRange(getPreciseCodeRangeNode.execute(this, a, expectedEncoding), expectedEncoding);
        }

        @NeverDefault
        public static GetByteCodeRangeNode create() {
            return TruffleStringFactory.GetByteCodeRangeNodeGen.create();
        }

        public static GetByteCodeRangeNode getUncached() {
            return TruffleStringFactory.GetByteCodeRangeNodeGen.getUncached();
        }
    }

    public static abstract class GetCodeRangeImpreciseNode
    extends AbstractPublicNode {
        GetCodeRangeImpreciseNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        static CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.get(a.codeRange());
        }

        @NeverDefault
        public static GetCodeRangeImpreciseNode create() {
            return TruffleStringFactory.GetCodeRangeImpreciseNodeGen.create();
        }

        public static GetCodeRangeImpreciseNode getUncached() {
            return TruffleStringFactory.GetCodeRangeImpreciseNodeGen.getUncached();
        }
    }

    public static abstract class GetCodeRangeNode
    extends AbstractPublicNode {
        GetCodeRangeNode() {
        }

        public abstract CodeRange execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final CodeRange getCodeRange(AbstractTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode) {
            a.checkEncoding(expectedEncoding);
            return CodeRange.get(getPreciseCodeRangeNode.execute(this, a, expectedEncoding));
        }

        @NeverDefault
        public static GetCodeRangeNode create() {
            return TruffleStringFactory.GetCodeRangeNodeGen.create();
        }

        public static GetCodeRangeNode getUncached() {
            return TruffleStringFactory.GetCodeRangeNodeGen.getUncached();
        }
    }

    public static abstract class MaterializeNode
    extends AbstractPublicNode {
        MaterializeNode() {
        }

        public abstract void execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final void doMaterialize(AbstractTruffleString a, Encoding expectedEncoding, @Cached ToIndexableNode toIndexableNode) {
            a.checkEncoding(expectedEncoding);
            toIndexableNode.execute(this, a, a.data());
            assert (a.isMaterialized(expectedEncoding));
        }

        @NeverDefault
        public static MaterializeNode create() {
            return TruffleStringFactory.MaterializeNodeGen.create();
        }

        public static MaterializeNode getUncached() {
            return TruffleStringFactory.MaterializeNodeGen.getUncached();
        }
    }

    static abstract class ToIndexableNode
    extends AbstractInternalNode {
        ToIndexableNode() {
        }

        abstract Object execute(Node var1, AbstractTruffleString var2, Object var3);

        @Specialization
        static byte[] doByteArray(AbstractTruffleString a, byte[] data) {
            return data;
        }

        @Specialization(guards={"isSupportedEncoding(a.encoding())"})
        static AbstractTruffleString.NativePointer doNativeSupported(AbstractTruffleString a, AbstractTruffleString.NativePointer data) {
            return data;
        }

        @Specialization(guards={"!isSupportedEncoding(a.encoding())"})
        static AbstractTruffleString.NativePointer doNativeUnsupported(Node node, AbstractTruffleString a, AbstractTruffleString.NativePointer data, @Cached.Shared(value="materializeProfile") @Cached InlinedConditionProfile materializeProfile) {
            data.materializeByteArray(node, a, materializeProfile);
            return data;
        }

        @Specialization
        byte[] doLazyConcat(AbstractTruffleString a, AbstractTruffleString.LazyConcat data) {
            return ToIndexableNode.doLazyConcatIntl(this, a);
        }

        private static byte[] doLazyConcatIntl(ToIndexableNode location, AbstractTruffleString a) {
            a.setData(AbstractTruffleString.LazyConcat.flatten(location, (TruffleString)a));
            return (byte[])a.data();
        }

        @Specialization
        static byte[] doLazyLong(Node node, AbstractTruffleString a, AbstractTruffleString.LazyLong data, @Cached.Shared(value="materializeProfile") @Cached InlinedConditionProfile materializeProfile) {
            if (materializeProfile.profile(node, data.bytes == null)) {
                data.setBytes((TruffleString)a, NumberConversion.longToString(data.value, a.length()));
            }
            return data.bytes;
        }
    }

    public static abstract class AsManagedNode
    extends AbstractPublicNode {
        AsManagedNode() {
        }

        public final TruffleString execute(AbstractTruffleString a, Encoding expectedEncoding) {
            return this.execute(a, expectedEncoding, false);
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2, boolean var3);

        @Specialization(guards={"!a.isNative()"})
        static TruffleString managedImmutable(TruffleString a, Encoding expectedEncoding, boolean cacheResult) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(expectedEncoding);
            assert (!(a.data() instanceof AbstractTruffleString.NativePointer));
            return a;
        }

        @Specialization(guards={"a.isNative()"})
        TruffleString nativeImmutable(TruffleString a, Encoding encoding, boolean cacheResult, @Cached InlinedConditionProfile cacheHit, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(encoding);
            TruffleString cur = a.next;
            assert (!a.isJavaString());
            if (cacheResult && cur != null) {
                while (cur != a && (cur.isNative() || cur.isJavaString() || !cur.isCompatibleToIntl(encoding))) {
                    cur = cur.next;
                }
                if (cacheHit.profile(this, cur != a)) {
                    assert (cur.isCompatibleToIntl(encoding) && cur.isManaged() && !cur.isJavaString());
                    return cur;
                }
            }
            TruffleString managed = attributesNode.execute(this, a, !cacheResult, encoding);
            if (cacheResult) {
                a.cacheInsert(managed);
            }
            return managed;
        }

        @Specialization
        TruffleString mutable(MutableTruffleString a, Encoding expectedEncoding, boolean cacheResult, @Cached.Shared(value="attributesNode") @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode attributesNode) {
            CompilerAsserts.partialEvaluationConstant(cacheResult);
            a.checkEncoding(expectedEncoding);
            return attributesNode.execute(this, a, expectedEncoding);
        }

        @NeverDefault
        public static AsManagedNode create() {
            return TruffleStringFactory.AsManagedNodeGen.create();
        }

        public static AsManagedNode getUncached() {
            return TruffleStringFactory.AsManagedNodeGen.getUncached();
        }
    }

    static abstract class InternalAsTruffleStringNode
    extends AbstractInternalNode {
        InternalAsTruffleStringNode() {
        }

        abstract TruffleString execute(Node var1, AbstractTruffleString var2, Encoding var3);

        @Specialization
        static TruffleString immutable(TruffleString a, Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization
        static TruffleString fromMutableString(Node node, MutableTruffleString a, Encoding expectedEncoding, @Cached TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode fromBufferWithStringCompactionNode) {
            return fromBufferWithStringCompactionNode.execute(node, a, expectedEncoding);
        }
    }

    public static abstract class AsTruffleStringNode
    extends AbstractPublicNode {
        AsTruffleStringNode() {
        }

        public abstract TruffleString execute(AbstractTruffleString var1, Encoding var2);

        @Specialization
        final TruffleString doDefault(AbstractTruffleString value, Encoding expectedEncoding, @Cached InternalAsTruffleStringNode internalNode) {
            return internalNode.execute(this, value, expectedEncoding);
        }

        @NeverDefault
        public static AsTruffleStringNode create() {
            return TruffleStringFactory.AsTruffleStringNodeGen.create();
        }

        public static AsTruffleStringNode getUncached() {
            return TruffleStringFactory.AsTruffleStringNodeGen.getUncached();
        }
    }

    public static enum ErrorHandling {
        BEST_EFFORT(DecodingErrorHandler.DEFAULT),
        RETURN_NEGATIVE(DecodingErrorHandler.RETURN_NEGATIVE);

        final DecodingErrorHandler errorHandler;

        private ErrorHandling(DecodingErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
        }
    }

    public static final class WithMask {
        final AbstractTruffleString string;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        final byte[] mask;

        WithMask(AbstractTruffleString string, byte[] mask) {
            this.string = string;
            this.mask = mask;
        }

        public static WithMask createUncached(AbstractTruffleString a, byte[] mask, Encoding expectedEncoding) {
            return CreateNode.getUncached().execute(a, mask, expectedEncoding);
        }

        public static WithMask createUTF16Uncached(AbstractTruffleString a, char[] mask) {
            return CreateUTF16Node.getUncached().execute(a, mask);
        }

        public static WithMask createUTF32Uncached(AbstractTruffleString a, int[] mask) {
            return CreateUTF32Node.getUncached().execute(a, mask);
        }

        private static void checkMaskLength(AbstractTruffleString string, int length) {
            if (length != string.length()) {
                throw InternalErrors.illegalArgument("mask length does not match string length!");
            }
        }

        public static abstract class CreateNode
        extends AbstractPublicNode {
            CreateNode() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, byte[] var2, Encoding var3);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, byte[] mask, Encoding expectedEncoding) {
                if (expectedEncoding == Encoding.UTF_16 || expectedEncoding == Encoding.UTF_32) {
                    throw InternalErrors.illegalArgument("use a CreateUTF16Node for UTF-16, and CreateUTF32Node for UTF-32");
                }
                a.checkEncoding(expectedEncoding);
                WithMask.checkMaskLength(a, mask.length);
                assert (TStringGuards.isStride0(a));
                return new WithMask(a, Arrays.copyOf(mask, mask.length));
            }

            @NeverDefault
            public static CreateNode create() {
                return TruffleStringFactory.WithMaskFactory.CreateNodeGen.create();
            }

            public static CreateNode getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateNodeGen.getUncached();
            }
        }

        public static abstract class CreateUTF16Node
        extends AbstractPublicNode {
            CreateUTF16Node() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, char[] var2);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, char[] mask) {
                a.checkEncoding(Encoding.UTF_16);
                WithMask.checkMaskLength(a, mask.length);
                byte[] maskBytes = new byte[a.length() << a.stride()];
                if (a.stride() == 0) {
                    TStringOps.arraycopyWithStrideCB(this, mask, 0, maskBytes, 0, 0, mask.length);
                } else {
                    TStringOps.arraycopyWithStrideCB(this, mask, 0, maskBytes, 0, 1, mask.length);
                }
                return new WithMask(a, maskBytes);
            }

            @NeverDefault
            public static CreateUTF16Node create() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF16NodeGen.create();
            }

            public static CreateUTF16Node getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF16NodeGen.getUncached();
            }
        }

        public static abstract class CreateUTF32Node
        extends AbstractPublicNode {
            CreateUTF32Node() {
            }

            public abstract WithMask execute(AbstractTruffleString var1, int[] var2);

            @Specialization
            WithMask doCreate(AbstractTruffleString a, int[] mask) {
                a.checkEncoding(Encoding.UTF_32);
                WithMask.checkMaskLength(a, mask.length);
                byte[] maskBytes = new byte[a.length() << a.stride()];
                if (a.stride() == 0) {
                    TStringOps.arraycopyWithStrideIB(this, mask, 0, maskBytes, 0, 0, mask.length);
                } else if (a.stride() == 1) {
                    TStringOps.arraycopyWithStrideIB(this, mask, 0, maskBytes, 0, 1, mask.length);
                } else {
                    TStringOps.arraycopyWithStrideIB(this, mask, 0, maskBytes, 0, 2, mask.length);
                }
                return new WithMask(a, maskBytes);
            }

            @NeverDefault
            public static CreateUTF32Node create() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF32NodeGen.create();
            }

            public static CreateUTF32Node getUncached() {
                return TruffleStringFactory.WithMaskFactory.CreateUTF32NodeGen.getUncached();
            }
        }
    }
}

