/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.CoreLocations;
import com.oracle.truffle.object.DynamicObjectImpl;
import com.oracle.truffle.object.LayoutImpl;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ObjectStorageOptions;
import com.oracle.truffle.object.ShapeImpl;
import java.io.PrintStream;

public class DynamicObjectBasic
extends DynamicObjectImpl {
    long primitive1;
    long primitive2;
    long primitive3;
    Object object1;
    Object object2;
    Object object3;
    Object object4;
    static final BasicObjectFieldLocation[] OBJECT_FIELD_LOCATIONS;
    static final BasicLongFieldLocation[] PRIMITIVE_FIELD_LOCATIONS;

    protected DynamicObjectBasic(Shape shape) {
        super(shape);
    }

    @Override
    protected final void initialize(Shape shape) {
        assert (this.getObjectStore(shape) == null);
        int capacity = ((ShapeImpl)shape).getObjectArrayCapacity();
        if (capacity != 0) {
            this.setObjectStore(new Object[capacity], shape);
        }
        if (((ShapeImpl)shape).getPrimitiveArrayCapacity() != 0) {
            this.setPrimitiveStore(new int[((ShapeImpl)shape).getPrimitiveArrayCapacity()], shape);
        }
    }

    private Object[] getObjectStore(Shape currentShape) {
        return LayoutImpl.ACCESS.getObjectArray(this);
    }

    private void setObjectStore(Object[] newArray, Shape currentShape) {
        LayoutImpl.ACCESS.setObjectArray(this, newArray);
    }

    private int[] getPrimitiveStore(Shape currentShape) {
        return LayoutImpl.ACCESS.getPrimitiveArray(this);
    }

    private void setPrimitiveStore(int[] newArray, Shape currentShape) {
        LayoutImpl.ACCESS.setPrimitiveArray(this, newArray);
    }

    private boolean checkSetShape(Shape oldShape, Shape newShape) {
        Shape currentShape = this.getShape();
        assert (oldShape != newShape) : "Wrong old shape assumption?";
        assert (newShape != currentShape) : "Redundant shape change? shape=" + currentShape;
        assert (oldShape == currentShape || oldShape.getParent() == currentShape) : "Out-of-order shape change?\nparentShape=" + currentShape + "\noldShape=" + oldShape + "\nnewShape=" + newShape;
        return true;
    }

    @Override
    protected final boolean checkExtensionArrayInvariants(Shape newShape) {
        assert (this.getShape() == newShape);
        assert (this.getObjectStore(newShape) == null && ((ShapeImpl)newShape).getObjectArrayCapacity() == 0 || this.getObjectStore(newShape) != null && this.getObjectStore(newShape).length == ((ShapeImpl)newShape).getObjectArrayCapacity());
        if (((ShapeImpl)newShape).hasPrimitiveArray()) assert (this.getPrimitiveStore(newShape) == null && ((ShapeImpl)newShape).getPrimitiveArrayCapacity() == 0 || this.getPrimitiveStore(newShape) != null && this.getPrimitiveStore(newShape).length == ((ShapeImpl)newShape).getPrimitiveArrayCapacity());
        return true;
    }

    @Override
    protected final DynamicObject cloneWithShape(Shape currentShape) {
        assert (this.getShape() == currentShape);
        DynamicObjectBasic clone = (DynamicObjectBasic)super.clone();
        if (this.getObjectStore(currentShape) != null) {
            clone.setObjectStore((Object[])this.getObjectStore(currentShape).clone(), currentShape);
        }
        if (((ShapeImpl)currentShape).hasPrimitiveArray() && this.getPrimitiveStore(currentShape) != null) {
            clone.setPrimitiveStore((int[])this.getPrimitiveStore(currentShape).clone(), currentShape);
        }
        return clone;
    }

    @Override
    protected final void reshape(ShapeImpl newShape) {
        ShapeImpl oldShape = (ShapeImpl)this.getShape();
        ShapeImpl commonAncestor = ShapeImpl.findCommonAncestor(oldShape, newShape);
        if (ObjectStorageOptions.TraceReshape) {
            int limit = 200;
            PrintStream out = System.out;
            out.printf("RESHAPE\nOLD %s\nNEW %s\nLCA %s\nDIFF %s\n---\n", oldShape.toStringLimit(limit), newShape.toStringLimit(limit), commonAncestor.toStringLimit(limit), ShapeImpl.diff(oldShape, newShape));
        }
        DynamicObject original = this.cloneWithShape(oldShape);
        this.setShapeAndGrow(oldShape, newShape);
        assert (!newShape.hasPrimitiveArray() || newShape.getPrimitiveArrayCapacity() != 0 || this.getPrimitiveStore(newShape) == null);
        this.copyProperties(original, commonAncestor);
        assert (this.checkExtensionArrayInvariants(newShape));
    }

    static {
        int index = 0;
        PRIMITIVE_FIELD_LOCATIONS = new BasicLongFieldLocation[]{new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).primitive1;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).primitive1 = value;
            }
        }, new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).primitive2;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).primitive2 = value;
            }
        }, new BasicLongFieldLocation(index++){

            @Override
            public long getLong(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).primitive3;
            }

            @Override
            public void setLong(DynamicObject store, long value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).primitive3 = value;
            }
        }};
        index = 0;
        OBJECT_FIELD_LOCATIONS = new BasicObjectFieldLocation[]{new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).object1;
            }

            @Override
            public void set(DynamicObject store, Object value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).object1 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).object2;
            }

            @Override
            public void set(DynamicObject store, Object value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).object2 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).object3;
            }

            @Override
            public void set(DynamicObject store, Object value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).object3 = value;
            }
        }, new BasicObjectFieldLocation(index++){

            @Override
            public Object get(DynamicObject store, boolean guard) {
                return ((DynamicObjectBasic)store).object4;
            }

            @Override
            public void set(DynamicObject store, Object value, boolean guard, boolean init) {
                ((DynamicObjectBasic)store).object4 = value;
            }
        }};
    }

    static abstract class BasicObjectFieldLocation
    extends CoreLocations.SimpleObjectFieldLocation {
        protected BasicObjectFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Class<? extends DynamicObject> getDeclaringClass() {
            return DynamicObjectBasic.class;
        }
    }

    static abstract class BasicLongFieldLocation
    extends CoreLocations.SimpleLongFieldLocation {
        protected BasicLongFieldLocation(int index) {
            super(index);
        }

        @Override
        public final Class<? extends DynamicObject> getDeclaringClass() {
            return DynamicObjectBasic.class;
        }

        @Override
        public final int primitiveFieldCount() {
            return 1;
        }

        @Override
        public final void accept(LocationImpl.LocationVisitor locationVisitor) {
            locationVisitor.visitPrimitiveField(this.getIndex(), 1);
        }
    }
}

