/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotFunctionProxyHandler;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotIterable;
import com.oracle.truffle.polyglot.PolyglotIterator;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.PolyglotMapEntry;
import com.oracle.truffle.polyglot.PolyglotObjectProxyHandler;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotHostAccess
extends AbstractPolyglotImpl.AbstractHostAccess {
    final AbstractPolyglotImpl polyglot;

    protected PolyglotHostAccess(AbstractPolyglotImpl polyglot) {
        super(polyglot);
        this.polyglot = polyglot;
    }

    public Object toGuestValue(Object polyglotContext, Object node, Object hostValue) {
        Node parentNode = (Node)node;
        PolyglotContextImpl internalContext = (PolyglotContextImpl)polyglotContext;
        if (hostValue instanceof Value) {
            Value receiverValue = (Value)hostValue;
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)this.polyglot.getAPIAccess().getContext(receiverValue);
            PolyglotContextImpl valueContext = languageContext != null ? languageContext.context : null;
            Object valueReceiver = this.polyglot.getAPIAccess().getReceiver(receiverValue);
            if (valueContext != internalContext) {
                valueReceiver = internalContext.migrateValue(parentNode, valueReceiver, valueContext);
            }
            return valueReceiver;
        }
        if (PolyglotWrapper.isInstance(hostValue)) {
            return internalContext.migrateHostWrapper(parentNode, PolyglotWrapper.asInstance(hostValue));
        }
        if (hostValue instanceof Proxy) {
            return PolyglotHostAccess.toGuestProxy(hostValue);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object toGuestProxy(Object hostValue) {
        if (Proxy.isProxyClass(hostValue.getClass())) {
            InvocationHandler h = Proxy.getInvocationHandler(hostValue);
            if (h instanceof PolyglotFunctionProxyHandler) {
                return ((PolyglotFunctionProxyHandler)h).functionObj;
            }
            if (h instanceof PolyglotObjectProxyHandler) {
                return ((PolyglotObjectProxyHandler)h).obj;
            }
        }
        return null;
    }

    public <T> List<T> toList(Object internalContext, Object guestValue, boolean implementFunction, Class<T> elementClass, Type elementType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotList.create(context.getHostContext(), guestValue, implementFunction, elementClass, elementType);
    }

    public <K, V> Map<K, V> toMap(Object internalContext, Object foreignObject, boolean implementsFunction, Class<K> keyClass, Type keyType, Class<V> valueClass, Type valueType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotMap.create(context.getHostContext(), foreignObject, implementsFunction, keyClass, keyType, valueClass, valueType);
    }

    public <K, V> Map.Entry<K, V> toMapEntry(Object internalContext, Object foreignObject, boolean implementsFunction, Class<K> keyClass, Type keyType, Class<V> valueClass, Type valueType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotMapEntry.create(context.getHostContext(), foreignObject, implementsFunction, keyClass, keyType, valueClass, valueType);
    }

    public <T> Function<?, ?> toFunction(Object internalContext, Object function, Class<?> returnClass, Type returnType, Class<?> paramClass, Type paramType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotFunction.create(context.getHostContext(), function, returnClass, returnType, paramClass, paramType);
    }

    public Object toObjectProxy(Object internalContext, Class<?> clazz, Object obj) throws IllegalArgumentException {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotObjectProxyHandler.newProxyInstance(clazz, obj, context.getHostContext());
    }

    public <T> T toFunctionProxy(Object internalContext, Class<T> functionalType, Object function) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotFunctionProxyHandler.create(functionalType, function, context.getHostContext());
    }

    public <T> Iterable<T> toIterable(Object internalContext, Object iterable, boolean implementFunction, Class<T> elementClass, Type elementType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotIterable.create(context.getHostContext(), iterable, implementFunction, elementClass, elementType);
    }

    public <T> Iterator<T> toIterator(Object internalContext, Object iterable, boolean implementFunction, Class<T> elementClass, Type elementType) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotIterator.create(context.getHostContext(), iterable, implementFunction, elementClass, elementType);
    }

    public PolyglotException toPolyglotException(Object internalContext, Throwable e) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotImpl.guestToHostException(context.getHostContext(), e, true);
    }

    public Value toValue(Object internalContext, Object receiver) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return context.getHostContext().asValue(receiver);
    }

    public String getValueInfo(Object internalContext, Object value) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        return PolyglotValueDispatch.getValueInfo(context, value);
    }

    @CompilerDirectives.TruffleBoundary
    public Value[] toValues(Object internalContext, Object[] values, int startIndex) {
        return ((PolyglotContextImpl)internalContext).getHostContext().toHostValues(values, startIndex);
    }

    @CompilerDirectives.TruffleBoundary
    public Value[] toValues(Object internalContext, Object[] values) {
        return ((PolyglotContextImpl)internalContext).getHostContext().toHostValues(values);
    }

    public boolean isEngineException(RuntimeException e) {
        return e instanceof PolyglotEngineException;
    }

    public RuntimeException toEngineException(RuntimeException e) {
        return new PolyglotEngineException(e);
    }

    public RuntimeException unboxEngineException(RuntimeException e) {
        return ((PolyglotEngineException)e).e;
    }

    public void rethrowPolyglotException(Object internalContext, PolyglotException e) {
        PolyglotContextImpl context = (PolyglotContextImpl)internalContext;
        AbstractPolyglotImpl.APIAccess api = this.polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = (PolyglotExceptionImpl)api.getReceiver(e);
        if (exceptionImpl.context == context || exceptionImpl.context == null || exceptionImpl.isHostException()) {
            Throwable original = ((PolyglotExceptionImpl)api.getReceiver((PolyglotException)e)).exception;
            if (original instanceof RuntimeException) {
                throw (RuntimeException)original;
            }
            if (original instanceof Error) {
                throw (Error)original;
            }
        }
    }
}

