/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Option;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;

@Option.Group(value={"engine"})
final class PolyglotEngineOptions {
    static final String PREINITIALIZE_CONTEXT_NAME = "PreinitializeContexts";
    private static final String INSTRUMENT_EXCEPTIONS_ARE_THROWN_NAME = "InstrumentExceptionsAreThrown";
    @Option(name="PreinitializeContexts", category=OptionCategory.EXPERT, deprecated=true, help="Preinitialize language contexts for given languages.")
    static final OptionKey<String> PreinitializeContexts = new OptionKey((Object)"");
    @Option(name="InstrumentExceptionsAreThrown", category=OptionCategory.INTERNAL, help="Propagates exceptions thrown by instruments.")
    static final OptionKey<Boolean> InstrumentExceptionsAreThrown = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Propagates cancel execution exception into UncaughtExceptionHandler. For testing purposes only.")
    static final OptionKey<Boolean> TriggerUncaughtExceptionHandlerForCancel = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Show internal frames specific to the language implementation in stack traces.")
    static final OptionKey<Boolean> ShowInternalStackFrames = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Enables conservative context references. This allows invalid sharing between contexts. For testing purposes only.")
    static final OptionKey<Boolean> UseConservativeContextReferences = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Enables specialization statistics for nodes generated with Truffle DSL and prints the result on exit. In order for this flag to be functional -Atruffle.dsl.GenerateSpecializationStatistics=true needs to be set at build time.Enabling this flag and the compiler option has major implications on the performance and footprint of the interpreter.Do not use in production environments.")
    static final OptionKey<Boolean> SpecializationStatistics = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Traces thread local events and when they are processed on the individual threads.Prints messages with the [engine] [tl] prefix. ")
    static final OptionKey<Boolean> TraceThreadLocalActions = new OptionKey((Object)false);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Repeadly submits thread local actions and collects statistics about safepoint intervals in the process. Prints event and interval statistics when the context is closed for each thread. This option significantly slows down execution and is therefore intended for testing purposes only.")
    static final OptionKey<Boolean> SafepointALot = new OptionKey((Object)false);
    @Option(category=OptionCategory.EXPERT, stability=OptionStability.EXPERIMENTAL, help="Prints the stack trace for all threads for a time interval. By default 0, which disables the output.")
    static final OptionKey<Long> TraceStackTraceInterval = new OptionKey((Object)0L);
    @Option(category=OptionCategory.USER, stability=OptionStability.STABLE, help="Print warning when the engine is using a default Truffle runtime.")
    static final OptionKey<Boolean> WarnInterpreterOnly = new OptionKey((Object)true);
    @Option(category=OptionCategory.INTERNAL, stability=OptionStability.EXPERIMENTAL, help="Use pre-initialized context when it's available.")
    static final OptionKey<Boolean> UsePreInitializedContext = new OptionKey((Object)true);

    PolyglotEngineOptions() {
    }
}

