/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.host.GuestToHostCodeCache;
import com.oracle.truffle.host.HostClassCache;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostLanguageService;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostToTypeNode;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class HostLanguage
extends TruffleLanguage<HostContext> {
    @CompilerDirectives.CompilationFinal
    private GuestToHostCodeCache guestToHostCache;
    @CompilerDirectives.CompilationFinal
    HostClassCache hostClassCache;
    final AbstractPolyglotImpl.AbstractHostAccess access;
    final AbstractPolyglotImpl polyglot;
    final AbstractPolyglotImpl.APIAccess api;
    final HostLanguageService service;

    HostLanguage(AbstractPolyglotImpl polyglot, AbstractPolyglotImpl.AbstractHostAccess hostAccess) {
        this.polyglot = polyglot;
        this.access = hostAccess;
        this.api = polyglot.getAPIAccess();
        this.service = new HostLanguageService(polyglot, this);
    }

    @Override
    protected boolean patchContext(HostContext context, TruffleLanguage.Env newEnv) {
        return true;
    }

    @Override
    protected HostContext createContext(TruffleLanguage.Env env) {
        env.registerService((Object)this.service);
        return new HostContext(this);
    }

    @Override
    protected Object getScope(HostContext context) {
        return context.topScope;
    }

    @Override
    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    GuestToHostCodeCache getGuestToHostCache() {
        GuestToHostCodeCache cache = this.guestToHostCache;
        if (cache == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.guestToHostCache = cache = new GuestToHostCodeCache(this);
        }
        return cache;
    }

    void initializeHostAccess(HostAccess policy, ClassLoader cl) {
        if (policy == null) {
            return;
        }
        HostClassCache cache = HostClassCache.findOrInitialize(this.access, this.api, policy, cl);
        if (this.hostClassCache != null) {
            if (!this.hostClassCache.hostAccess.equals((Object)cache.hostAccess)) {
                throw new IllegalStateException("Found different host access configuration for a context with a shared engine. The host access configuration must be the same for all contexts of an engine. Provide the same host access configuration using the Context.Builder.allowHostAccess method when constructing the context.");
            }
        } else {
            this.hostClassCache = cache;
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getLanguageView(HostContext hostContext, Object value) {
        Object wrapped;
        if (value instanceof TruffleObject) {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(value);
            try {
                assert (!lib.hasLanguage(value) || lib.getLanguage(value) != HostLanguage.class);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
            wrapped = HostToTypeNode.convertToObject(hostContext, value, lib);
        } else {
            wrapped = value;
        }
        return HostObject.forObject(wrapped, hostContext);
    }

    @Override
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) throws Exception {
        final String sourceString = request.getSource().getCharacters().toString();
        return Truffle.getRuntime().createCallTarget(new RootNode(this){
            @CompilerDirectives.CompilationFinal
            TruffleLanguage.ContextReference<HostContext> contextRef;

            @Override
            public Object execute(VirtualFrame frame) {
                if (this.contextRef == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.contextRef = this.lookupContextReference(HostLanguage.class);
                }
                HostContext context = this.contextRef.get();
                return HostLanguage.this.service.findDynamicClass(context, sourceString);
            }
        });
    }

    @Override
    protected void disposeContext(HostContext context) {
        context.disposeClassLoader();
    }

    static class HostLanguageException
    extends AbstractTruffleException {
        HostLanguageException(String message) {
            super(message);
        }
    }
}

