/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.ExecutionSignature;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeAccessor;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.ReentrantLock;

public abstract class RootNode
extends ExecutableNode {
    private static final AtomicReferenceFieldUpdater<RootNode, ReentrantLock> LOCK_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RootNode.class, ReentrantLock.class, "lock");
    @CompilerDirectives.CompilationFinal
    private volatile RootCallTarget callTarget;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;
    private volatile ReentrantLock lock;
    volatile byte instrumentationBits;

    protected RootNode(TruffleLanguage<?> language) {
        this(language, null);
    }

    protected RootNode(TruffleLanguage<?> language, FrameDescriptor frameDescriptor) {
        super(language);
        CompilerAsserts.neverPartOfCompilation();
        this.frameDescriptor = frameDescriptor == null ? new FrameDescriptor() : frameDescriptor;
    }

    @Deprecated
    public final <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
        if (this.getLanguage() == null) {
            return null;
        }
        return ((TruffleLanguage)this.getLanguage(languageClass)).getContextReference().get();
    }

    @Override
    public Node copy() {
        RootNode root = (RootNode)super.copy();
        root.frameDescriptor = this.frameDescriptor;
        return root;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public String getName() {
        return null;
    }

    public boolean isInternal() {
        if (this.getLanguageInfo() == null) {
            return true;
        }
        SourceSection sc = this.materializeSourceSection();
        if (sc != null) {
            return sc.getSource().isInternal();
        }
        return false;
    }

    protected boolean countsTowardsStackTraceLimit() {
        return !this.isInternal();
    }

    @CompilerDirectives.TruffleBoundary
    private SourceSection materializeSourceSection() {
        return this.getSourceSection();
    }

    public boolean isCaptureFramesForTrace() {
        return false;
    }

    public boolean isCloningAllowed() {
        return false;
    }

    protected boolean isCloneUninitializedSupported() {
        return false;
    }

    protected RootNode cloneUninitialized() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract Object execute(VirtualFrame var1);

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    protected final void setCallTarget(RootCallTarget callTarget) {
        this.callTarget = callTarget;
    }

    public CompilerOptions getCompilerOptions() {
        return DefaultCompilerOptions.INSTANCE;
    }

    protected boolean isInstrumentable() {
        return true;
    }

    protected boolean isTrivial() {
        return false;
    }

    protected List<TruffleStackTraceElement> findAsynchronousFrames(Frame frame) {
        return null;
    }

    protected Object translateStackTraceElement(TruffleStackTraceElement element) {
        Node location = element.getLocation();
        return NodeAccessor.EXCEPTION.createDefaultStackTraceElementObject(element.getTarget().getRootNode(), location != null ? location.getEncapsulatingSourceSection() : null);
    }

    protected ExecutionSignature prepareForAOT() {
        return null;
    }

    public static RootNode createConstantNode(Object constant) {
        return new Constant(constant);
    }

    final ReentrantLock getLazyLock() {
        ReentrantLock l = this.lock;
        if (l == null) {
            l = this.initializeLock();
        }
        return l;
    }

    private ReentrantLock initializeLock() {
        ReentrantLock l = new ReentrantLock();
        if (!LOCK_UPDATER.compareAndSet(this, null, l)) {
            l = Objects.requireNonNull(this.lock);
        }
        return l;
    }

    private static final class Constant
    extends RootNode {
        private final Object value;

        Constant(Object value) {
            super(null);
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.value;
        }
    }
}

