/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import java.util.concurrent.Callable;

final class AssertUtils {
    private AssertUtils() {
    }

    private static String formatArgs(Object[] args) {
        if (args == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder("[");
        String sep = "";
        for (Object arg : args) {
            b.append(sep);
            b.append(AssertUtils.formatValue(arg));
            sep = ", ";
        }
        b.append("]");
        return b.toString();
    }

    private static String formatValue(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (arg instanceof TruffleObject) {
            return arg.toString() + "(" + arg.getClass().getName() + ")";
        }
        if (arg instanceof String) {
            return "\"" + arg.toString() + "\"";
        }
        if (arg instanceof Character) {
            return "'" + arg.toString() + "'";
        }
        if (arg instanceof Boolean) {
            return arg.toString();
        }
        return arg.toString() + "(" + arg.getClass().getSimpleName() + ")";
    }

    private static String violationPre(Object receiver) {
        return String.format("Pre-condition contract violation for receiver %s.", AssertUtils.formatValue(receiver));
    }

    static String violationPost(Object receiver, Object returnValue) {
        return String.format("Post-condition contract violation for receiver %s and return value %s.", AssertUtils.formatValue(receiver), AssertUtils.formatValue(returnValue));
    }

    static String violationPost(Object receiver, Throwable t) {
        return String.format("Post-condition contract violation for receiver %s. Thrown unexpected error %s.", AssertUtils.formatValue(receiver), t.getClass().getName());
    }

    static String violationInvariant(Object receiver) {
        return String.format("Invariant contract violation for receiver %s.", AssertUtils.formatValue(receiver));
    }

    static String violationInvariant(Object receiver, Object[] args) {
        return String.format("Invariant contract violation for receiver %s and arguments %s.", AssertUtils.formatValue(receiver), AssertUtils.formatArgs(args));
    }

    static String violationInvariant(Object receiver, Object arg) {
        return String.format("Invariant contract violation for receiver %s and argument %s.", AssertUtils.formatValue(receiver), AssertUtils.formatValue(arg));
    }

    static String violationInvariant(Object receiver, String arg) {
        return String.format("Invariant contract violation for receiver %s and identifier %s.", AssertUtils.formatValue(receiver), arg);
    }

    static String violationInvariant(Object receiver, long arg) {
        return String.format("Invariant contract violation for receiver %s and index %s.", AssertUtils.formatValue(receiver), arg);
    }

    private static String violationReturn(Object receiver, Object returnValue) {
        return String.format("Post-condition contract violation for receiver %s and return value %s.", AssertUtils.formatValue(receiver), AssertUtils.formatValue(returnValue));
    }

    private static String violationArgument(Object receiver, Object arg) {
        return String.format("Pre-condition contract violation for receiver %s and argument %s. Valid arguments must be of type Boolean, Byte, Short, Integer, Long,  Float, Double, Character, String or implement TruffleObject.", AssertUtils.formatValue(receiver), AssertUtils.formatValue(arg));
    }

    static boolean validReturn(Object receiver, Object arg) {
        assert (AssertUtils.isInteropValue(arg)) : AssertUtils.violationReturn(receiver, arg);
        return true;
    }

    static boolean validArgument(Object receiver, Object arg) {
        if (arg == null) {
            throw new NullPointerException(AssertUtils.violationArgument(receiver, arg));
        }
        if (!AssertUtils.isInteropValue(arg)) {
            throw new ClassCastException(AssertUtils.violationArgument(receiver, arg));
        }
        return true;
    }

    static boolean isInteropValue(Object o) {
        return o instanceof TruffleObject || o instanceof Boolean || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double || o instanceof Character || o instanceof String;
    }

    static boolean validArguments(Object receiver, Object[] args) {
        assert (args != null) : AssertUtils.violationPre(receiver);
        for (Object arg : args) {
            assert (AssertUtils.validArgument(receiver, arg));
        }
        return true;
    }

    static boolean preCondition(Object receiver) {
        assert (receiver != null) : AssertUtils.violationPre(receiver);
        assert (AssertUtils.validArgument(receiver, receiver));
        return true;
    }

    static boolean notThrows(Callable<?> r) {
        try {
            r.call();
            return true;
        }
        catch (InteropException e) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

