/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.LanguageAccessor;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleSecurityException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.ReadOnlyArrayList;
import com.oracle.truffle.api.io.TruffleProcessBuilder;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.io.FileSystem;

public abstract class TruffleLanguage<C> {
    @CompilerDirectives.CompilationFinal
    LanguageInfo languageInfo;
    @CompilerDirectives.CompilationFinal
    ContextReference<Object> reference;
    @CompilerDirectives.CompilationFinal
    Object vmObject;

    protected TruffleLanguage() {
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return true;
    }

    protected abstract C createContext(Env var1);

    protected void initializeContext(C context) throws Exception {
    }

    protected void finalizeContext(C context) {
    }

    @Deprecated
    protected boolean initializeMultiContext() {
        return false;
    }

    protected void initializeMultipleContexts() {
    }

    protected void disposeContext(C context) {
    }

    protected CallTarget parse(ParsingRequest request) throws Exception {
        throw new UnsupportedOperationException(String.format("Override parse method of %s, it will be made abstract in future version of Truffle API!", this.getClass().getName()));
    }

    protected ExecutableNode parse(InlineParsingRequest request) throws Exception {
        return null;
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    protected boolean patchContext(C context, Env newEnv) {
        return false;
    }

    @Deprecated
    protected Object findExportedSymbol(C context, String globalName, boolean onlyExplicit) {
        return null;
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return singleThreaded;
    }

    protected void initializeMultiThreading(C context) {
    }

    protected void initializeThread(C context, Thread thread) {
    }

    protected void disposeThread(C context, Thread thread) {
    }

    @Deprecated
    protected Object getLanguageGlobal(C context) {
        return null;
    }

    protected abstract boolean isObjectOfLanguage(Object var1);

    protected Iterable<Scope> findLocalScopes(C context, Node node, Frame frame) {
        assert (node != null);
        return LanguageAccessor.engineAccess().createDefaultLexicalScope(node, frame);
    }

    protected Iterable<Scope> findTopScopes(C context) {
        Object global = this.getLanguageGlobal(context);
        return LanguageAccessor.engineAccess().createDefaultTopScope(global);
    }

    protected String toString(C context, Object value) {
        return Objects.toString(value);
    }

    protected boolean isVisible(C context, Object value) {
        return true;
    }

    protected Object findMetaObject(C context, Object value) {
        return null;
    }

    protected SourceSection findSourceLocation(C context, Object value) {
        return null;
    }

    @Deprecated
    public final ContextReference<C> getContextReference() {
        if (this.reference == null) {
            throw new IllegalStateException("TruffleLanguage instance is not initialized. Cannot get the current context reference.");
        }
        return this.reference;
    }

    CallTarget parse(Source source, String ... argumentNames) {
        CallTarget target;
        ParsingRequest request = new ParsingRequest(source, argumentNames);
        try {
            target = request.parse(this);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            request.dispose();
        }
        return target;
    }

    ExecutableNode parseInline(Source source, Node context, MaterializedFrame frame) {
        ExecutableNode snippet;
        assert (context != null);
        InlineParsingRequest request = new InlineParsingRequest(source, context, frame);
        try {
            snippet = request.parse(this);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            request.dispose();
        }
        return snippet;
    }

    protected static <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> languageClass) {
        return LanguageAccessor.engineAccess().getCurrentLanguage(languageClass);
    }

    protected static <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
        return LanguageAccessor.engineAccess().getCurrentContext(languageClass);
    }

    protected final String getLanguageHome() {
        return LanguageAccessor.engineAccess().getLanguageHome(LanguageAccessor.nodesAccess().getEngineObject(this.languageInfo));
    }

    public static enum ContextPolicy {
        EXCLUSIVE,
        REUSE,
        SHARED;

    }

    public static abstract class ContextReference<C> {
        protected ContextReference() {
        }

        public abstract C get();
    }

    public static abstract class LanguageReference<L extends TruffleLanguage> {
        protected LanguageReference() {
        }

        public abstract L get();
    }

    public static final class Env {
        static final Object UNSET_CONTEXT = new Object();
        final Object vmObject;
        final TruffleLanguage<Object> spi;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        private final Map<String, Object> config;
        private final OptionValues options;
        private final String[] applicationArguments;
        private final TruffleFile.FileSystemContext fileSystemContext;
        private final TruffleFile.FileSystemContext internalFileSystemContext;
        @CompilerDirectives.CompilationFinal
        volatile List<Object> services;
        @CompilerDirectives.CompilationFinal
        volatile Object context = UNSET_CONTEXT;
        @CompilerDirectives.CompilationFinal
        volatile Assumption contextUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context unchanged");
        @CompilerDirectives.CompilationFinal
        volatile boolean initialized = false;
        @CompilerDirectives.CompilationFinal
        private volatile Assumption initializedUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context initialized unchanged");
        @CompilerDirectives.CompilationFinal
        volatile boolean valid;
        volatile List<Object> languageServicesCollector;

        Env(Object vmObject, TruffleLanguage<?> language, OutputStream out, OutputStream err, InputStream in, Map<String, Object> config, OptionValues options, String[] applicationArguments, FileSystem fileSystem, FileSystem internalFileSystem, Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectors) {
            this.vmObject = vmObject;
            this.spi = language;
            this.in = in;
            this.err = err;
            this.out = out;
            this.config = config;
            this.options = options;
            this.applicationArguments = applicationArguments == null ? new String[]{} : applicationArguments;
            this.valid = true;
            this.fileSystemContext = new TruffleFile.FileSystemContext(fileSystem, fileTypeDetectors);
            this.internalFileSystemContext = new TruffleFile.FileSystemContext(internalFileSystem, fileTypeDetectors);
        }

        Object getVMObject() {
            return this.vmObject;
        }

        TruffleLanguage<Object> getSpi() {
            return this.spi;
        }

        void checkDisposed() {
            if (LanguageAccessor.engineAccess().isDisposed(this.vmObject)) {
                throw new IllegalStateException("Language environment is already disposed.");
            }
            if (!this.valid) {
                throw new IllegalStateException("Language environment is already invalidated.");
            }
        }

        public OptionValues getOptions() {
            return this.options;
        }

        public String[] getApplicationArguments() {
            return this.applicationArguments;
        }

        public boolean isCreateThreadAllowed() {
            return LanguageAccessor.engineAccess().isCreateThreadAllowed(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable) {
            return this.createThread(runnable, null);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable, TruffleContext context) {
            return this.createThread(runnable, context, null, 0L);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable, TruffleContext context, ThreadGroup group) {
            return this.createThread(runnable, context, group, 0L);
        }

        @CompilerDirectives.TruffleBoundary
        public Thread createThread(Runnable runnable, TruffleContext context, ThreadGroup group, long stackSize) {
            return LanguageAccessor.engineAccess().createThread(this.vmObject, runnable, context != null ? context.impl : null, group, stackSize);
        }

        public TruffleContext.Builder newContextBuilder() {
            TruffleContext truffleContext = TruffleContext.EMPTY;
            truffleContext.getClass();
            return truffleContext.new TruffleContext.Builder(this);
        }

        @CompilerDirectives.TruffleBoundary
        public Object getPolyglotBindings() {
            if (!this.isPolyglotBindingsAccessAllowed()) {
                throw new SecurityException("Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
            }
            return LanguageAccessor.engineAccess().getPolyglotBindingsForLanguage(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Object importSymbol(String symbolName) {
            if (!this.isPolyglotBindingsAccessAllowed()) {
                throw new SecurityException("Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
            }
            return LanguageAccessor.engineAccess().importSymbol(this.vmObject, this, symbolName);
        }

        @CompilerDirectives.TruffleBoundary
        public void exportSymbol(String symbolName, Object value) {
            if (!this.isPolyglotBindingsAccessAllowed()) {
                throw new SecurityException("Polyglot bindings are not accessible for this language. Use --polyglot or allowPolyglotAccess when building the context.");
            }
            LanguageAccessor.engineAccess().exportSymbol(this.vmObject, symbolName, value);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isHostLookupAllowed() {
            return LanguageAccessor.engineAccess().isHostAccessAllowed(this.vmObject, this);
        }

        @CompilerDirectives.TruffleBoundary
        public void addToHostClassPath(TruffleFile entry) {
            Objects.requireNonNull(entry);
            LanguageAccessor.engineAccess().addToHostClassPath(this.vmObject, entry);
        }

        @CompilerDirectives.TruffleBoundary
        public Object lookupHostSymbol(String symbolName) {
            return LanguageAccessor.engineAccess().lookupHostSymbol(this.vmObject, this, symbolName);
        }

        public boolean isHostObject(Object value) {
            return LanguageAccessor.engineAccess().isHostObject(value);
        }

        public Object asHostObject(Object value) {
            if (!this.isHostObject(value)) {
                CompilerDirectives.transferToInterpreter();
                throw new ClassCastException();
            }
            return LanguageAccessor.engineAccess().asHostObject(value);
        }

        public Object asGuestValue(Object hostObject) {
            return LanguageAccessor.engineAccess().toGuestValue(hostObject, this.vmObject);
        }

        public Object asBoxedGuestValue(Object guestObject) {
            return LanguageAccessor.engineAccess().asBoxedGuestValue(guestObject, this.vmObject);
        }

        public boolean isHostFunction(Object value) {
            return LanguageAccessor.engineAccess().isHostFunction(value);
        }

        public Object findMetaObject(Object value) {
            return LanguageAccessor.engineAccess().findMetaObjectForLanguage(this.vmObject, value);
        }

        public boolean isHostException(Throwable exception) {
            return LanguageAccessor.engineAccess().isHostException(exception);
        }

        public Throwable asHostException(Throwable exception) {
            return LanguageAccessor.engineAccess().asHostException(exception);
        }

        public boolean isHostSymbol(Object guestObject) {
            return LanguageAccessor.engineAccess().isHostSymbol(guestObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Object asHostSymbol(Class<?> symbolClass) {
            return LanguageAccessor.engineAccess().asHostSymbol(this.vmObject, symbolClass);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isNativeAccessAllowed() {
            return LanguageAccessor.engineAccess().isNativeAccessAllowed(this.vmObject, this);
        }

        @Deprecated
        public boolean isPolyglotAccessAllowed() {
            return this.isPolyglotEvalAllowed() || this.isPolyglotBindingsAccessAllowed();
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isPolyglotEvalAllowed() {
            return LanguageAccessor.engineAccess().isPolyglotEvalAllowed(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isPolyglotBindingsAccessAllowed() {
            return LanguageAccessor.engineAccess().isPolyglotBindingsAccessAllowed(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isMimeTypeSupported(String mimeType) {
            this.checkDisposed();
            return LanguageAccessor.engineAccess().isMimeTypeSupported(this.vmObject, mimeType);
        }

        @CompilerDirectives.TruffleBoundary
        @Deprecated
        public CallTarget parse(Source source, String ... argumentNames) {
            CompilerAsserts.neverPartOfCompilation();
            this.checkDisposed();
            return LanguageAccessor.engineAccess().parseForLanguage(this.vmObject, source, argumentNames, true);
        }

        @CompilerDirectives.TruffleBoundary
        public CallTarget parseInternal(Source source, String ... argumentNames) {
            CompilerAsserts.neverPartOfCompilation();
            this.checkDisposed();
            return LanguageAccessor.engineAccess().parseForLanguage(this.vmObject, source, argumentNames, true);
        }

        @CompilerDirectives.TruffleBoundary
        public CallTarget parsePublic(Source source, String ... argumentNames) {
            CompilerAsserts.neverPartOfCompilation();
            this.checkDisposed();
            return LanguageAccessor.engineAccess().parseForLanguage(this.vmObject, source, argumentNames, false);
        }

        @CompilerDirectives.TruffleBoundary
        public InputStream in() {
            this.checkDisposed();
            return this.in;
        }

        @CompilerDirectives.TruffleBoundary
        public OutputStream out() {
            this.checkDisposed();
            return this.out;
        }

        @CompilerDirectives.TruffleBoundary
        public OutputStream err() {
            this.checkDisposed();
            return this.err;
        }

        @CompilerDirectives.TruffleBoundary
        public <T> T lookup(Class<T> type) {
            this.checkDisposed();
            for (Object obj : this.services) {
                if (!type.isInstance(obj)) continue;
                return type.cast(obj);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        public <S> S lookup(InstrumentInfo instrument, Class<S> type) {
            return LanguageAccessor.engineAccess().lookup(instrument, type);
        }

        @CompilerDirectives.TruffleBoundary
        public <S> S lookup(LanguageInfo language, Class<S> type) {
            if (this.getSpi().languageInfo == language) {
                throw new IllegalArgumentException("Cannot request services from the current language.");
            }
            Objects.requireNonNull(language);
            return LanguageAccessor.engineAccess().lookupService(this.vmObject, language, this.getSpi().languageInfo, type);
        }

        @Deprecated
        @CompilerDirectives.TruffleBoundary
        public Map<String, LanguageInfo> getLanguages() {
            return LanguageAccessor.engineAccess().getInternalLanguages(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, LanguageInfo> getInternalLanguages() {
            return LanguageAccessor.engineAccess().getInternalLanguages(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, LanguageInfo> getPublicLanguages() {
            return LanguageAccessor.engineAccess().getPublicLanguages(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, InstrumentInfo> getInstruments() {
            return LanguageAccessor.engineAccess().getInstruments(this.vmObject);
        }

        public ZoneId getTimeZone() {
            this.checkDisposed();
            return LanguageAccessor.engineAccess().getTimeZone(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, Object> getConfig() {
            this.checkDisposed();
            return this.config;
        }

        public TruffleContext getContext() {
            return LanguageAccessor.engineAccess().getPolyglotContext(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean isPreInitialization() {
            return LanguageAccessor.engineAccess().inContextPreInitialization(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        @Deprecated
        public TruffleFile getTruffleFile(String path) {
            return this.getInternalTruffleFile(path);
        }

        @CompilerDirectives.TruffleBoundary
        @Deprecated
        public TruffleFile getTruffleFile(URI uri) {
            return this.getInternalTruffleFile(uri);
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getPublicTruffleFile(String path) {
            this.checkDisposed();
            try {
                return new TruffleFile(this.fileSystemContext, this.fileSystemContext.fileSystem.parsePath(path));
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getPublicTruffleFile(URI uri) {
            this.checkDisposed();
            try {
                return new TruffleFile(this.fileSystemContext, this.fileSystemContext.fileSystem.parsePath(uri));
            }
            catch (UnsupportedOperationException e) {
                throw new FileSystemNotFoundException("FileSystem for: " + uri.getScheme() + " scheme is not supported.");
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getInternalTruffleFile(String path) {
            this.checkDisposed();
            try {
                return new TruffleFile(this.internalFileSystemContext, this.internalFileSystemContext.fileSystem.parsePath(path));
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.internalFileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getInternalTruffleFile(URI uri) {
            this.checkDisposed();
            try {
                return new TruffleFile(this.internalFileSystemContext, this.internalFileSystemContext.fileSystem.parsePath(uri));
            }
            catch (UnsupportedOperationException e) {
                throw new FileSystemNotFoundException("FileSystem for: " + uri.getScheme() + " scheme is not supported.");
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.internalFileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile getCurrentWorkingDirectory() {
            return this.getPublicTruffleFile("").getAbsoluteFile();
        }

        @CompilerDirectives.TruffleBoundary
        public void setCurrentWorkingDirectory(TruffleFile currentWorkingDirectory) {
            this.checkDisposed();
            Objects.requireNonNull(currentWorkingDirectory, "Current working directory must be non null.");
            if (!currentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            if (!currentWorkingDirectory.isDirectory(new LinkOption[0])) {
                throw new IllegalArgumentException("Current working directory must be directory.");
            }
            try {
                this.fileSystemContext.fileSystem.setCurrentWorkingDirectory(currentWorkingDirectory.getSPIPath());
                if (this.fileSystemContext.fileSystem != this.internalFileSystemContext.fileSystem) {
                    this.internalFileSystemContext.fileSystem.setCurrentWorkingDirectory(currentWorkingDirectory.getSPIPath());
                }
            }
            catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public String getFileNameSeparator() {
            this.checkDisposed();
            try {
                return this.fileSystemContext.fileSystem.getSeparator();
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public String getPathSeparator() {
            this.checkDisposed();
            try {
                return this.fileSystemContext.fileSystem.getPathSeparator();
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        public void registerService(Object service) {
            if (this.languageServicesCollector == null) {
                throw new IllegalStateException("The registerService method can only be called during the execution of the Env.createContext method.");
            }
            this.languageServicesCollector.add(service);
        }

        public boolean isCreateProcessAllowed() {
            return LanguageAccessor.engineAccess().isCreateProcessAllowed(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleProcessBuilder newProcessBuilder(String ... command) {
            if (!this.isCreateProcessAllowed()) {
                throw new TruffleSecurityException("Process creation is not allowed, to enable it set Context.Builder.allowCreateProcess(true).");
            }
            ArrayList<String> cmd = new ArrayList<String>(command.length);
            Collections.addAll(cmd, command);
            return LanguageAccessor.ioAccess().createProcessBuilder(this.vmObject, this.fileSystemContext.fileSystem, cmd);
        }

        @CompilerDirectives.TruffleBoundary
        public Map<String, String> getEnvironment() {
            return LanguageAccessor.engineAccess().getProcessEnvironment(this.vmObject);
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile createTempFile(TruffleFile dir, String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
            try {
                TruffleFile useDir = dir == null ? new TruffleFile(this.fileSystemContext, this.fileSystemContext.fileSystem.getTempDirectory()) : dir;
                return TruffleFile.createTempFile(useDir, prefix, suffix, false, attrs);
            }
            catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleFile createTempDirectory(TruffleFile dir, String prefix, FileAttribute<?> ... attrs) throws IOException {
            try {
                TruffleFile useDir = dir == null ? new TruffleFile(this.fileSystemContext, this.fileSystemContext.fileSystem.getTempDirectory()) : dir;
                return TruffleFile.createTempFile(useDir, prefix, null, true, attrs);
            }
            catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
                throw e;
            }
            catch (Throwable t) {
                throw TruffleFile.wrapHostException(t, this.fileSystemContext.fileSystem);
            }
        }

        @CompilerDirectives.TruffleBoundary
        <E extends TruffleLanguage> E getLanguage(Class<E> languageClass) {
            this.checkDisposed();
            if (languageClass != this.getSpi().getClass()) {
                throw new IllegalArgumentException("Invalid access to language " + languageClass + ".");
            }
            return (E)((TruffleLanguage)languageClass.cast(this.getSpi()));
        }

        Object findExportedSymbol(String globalName, boolean onlyExplicit) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.getSpi().findExportedSymbol(c, globalName, onlyExplicit);
            }
            return null;
        }

        Object getLanguageGlobal() {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.getSpi().getLanguageGlobal(c);
            }
            return null;
        }

        Object findMetaObjectImpl(Object obj) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.getSpi().findMetaObject(c, obj);
            }
            return null;
        }

        SourceSection findSourceLocation(Object obj) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                return this.getSpi().findSourceLocation(c, obj);
            }
            return null;
        }

        boolean isObjectOfLanguage(Object obj) {
            return this.getSpi().isObjectOfLanguage(obj);
        }

        Iterable<Scope> findLocalScopes(Node node, Frame frame) {
            assert (node != null);
            return this.getSpi().findLocalScopes(this.context, node, frame);
        }

        Iterable<Scope> findTopScopes() {
            return this.getSpi().findTopScopes(this.context);
        }

        void dispose() {
            Object c = this.getLanguageContext();
            if (c == UNSET_CONTEXT) {
                throw new IllegalStateException("Disposing while context has not been set yet.");
            }
            this.getSpi().disposeContext(c);
        }

        @CompilerDirectives.TruffleBoundary
        void postInit() {
            try {
                this.getSpi().initializeContext(this.context);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.initialized = true;
                Assumption old = this.initializedUnchangedAssumption;
                this.initializedUnchangedAssumption = Truffle.getRuntime().createAssumption("Language context initialized unchanged");
                old.invalidate();
            }
        }

        boolean isInitialized() {
            if (CompilerDirectives.isPartialEvaluationConstant(this)) {
                boolean localInitialized = this.initialized;
                if (this.initializedUnchangedAssumption.isValid()) {
                    return localInitialized;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.initialized;
            }
            return this.initialized;
        }

        String toStringIfVisible(Object value, boolean checkVisibility) {
            Object c = this.getLanguageContext();
            if (c != UNSET_CONTEXT) {
                if (checkVisibility && !this.getSpi().isVisible(c, value)) {
                    return null;
                }
                return this.getSpi().toString(c, value);
            }
            return null;
        }

        Object getLanguageContext() {
            if (CompilerDirectives.isPartialEvaluationConstant(this)) {
                Object languageContext = this.context;
                if (this.contextUnchangedAssumption.isValid()) {
                    return languageContext;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.context;
            }
            return this.context;
        }
    }

    public static final class InlineParsingRequest {
        private final Node node;
        private final MaterializedFrame frame;
        private final Source source;
        private boolean disposed;

        InlineParsingRequest(Source source, Node node, MaterializedFrame frame) {
            Objects.requireNonNull(source);
            this.node = node;
            this.frame = frame;
            this.source = source;
        }

        public Source getSource() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.source;
        }

        public Node getLocation() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.node;
        }

        public MaterializedFrame getFrame() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.frame;
        }

        void dispose() {
            this.disposed = true;
        }

        ExecutableNode parse(TruffleLanguage<?> truffleLanguage) throws Exception {
            return truffleLanguage.parse(this);
        }
    }

    public static final class ParsingRequest {
        private final Source source;
        private final String[] argumentNames;
        private boolean disposed;

        ParsingRequest(Source source, String ... argumentNames) {
            Objects.requireNonNull(source);
            this.source = source;
            this.argumentNames = argumentNames;
        }

        public Source getSource() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.source;
        }

        public List<String> getArgumentNames() {
            if (this.disposed) {
                throw new IllegalStateException();
            }
            return this.argumentNames == null ? Collections.emptyList() : ReadOnlyArrayList.asList(this.argumentNames, 0, this.argumentNames.length);
        }

        void dispose() {
            this.disposed = true;
        }

        CallTarget parse(TruffleLanguage<?> truffleLanguage) throws Exception {
            return truffleLanguage.parse(this);
        }
    }

    public static interface Provider {
        public String getLanguageClassName();

        public TruffleLanguage<?> create();

        public List<TruffleFile.FileTypeDetector> createFileTypeDetectors();

        public Collection<String> getServicesClassNames();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String id() default "";

        public String name();

        public String implementationName() default "";

        public String version() default "inherit";

        @Deprecated
        public String[] mimeType() default {};

        public String defaultMimeType() default "";

        public String[] characterMimeTypes() default {};

        public String[] byteMimeTypes() default {};

        public boolean interactive() default true;

        public boolean internal() default false;

        public String[] dependentLanguages() default {};

        public ContextPolicy contextPolicy() default ContextPolicy.EXCLUSIVE;

        public Class<?>[] services() default {};

        public Class<? extends TruffleFile.FileTypeDetector>[] fileTypeDetectors() default {};
    }
}

