package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.ForeignAccess.Factory;
import com.oracle.truffle.api.interop.ForeignAccess.StandardFactory;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.RootNode;

/**
 * This foreign access factory is generated by {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution}.
 * You are supposed to use it for the receiver object {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings}.
 */
final class EmptyGlobalBindingsResolutionForeign implements StandardFactory, Factory {
    public static final ForeignAccess ACCESS = ForeignAccess.create(new EmptyGlobalBindingsResolutionForeign(), null);
    @Deprecated public static ForeignAccess createAccess() { return ForeignAccess.create(new EmptyGlobalBindingsResolutionForeign(), null); }

    private EmptyGlobalBindingsResolutionForeign() { }

    @Override
    public boolean canHandle(TruffleObject obj) {
        return com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.isInstance(obj);
    }

    @Override
    public CallTarget accessIsNull() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsExecutable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsInstantiable() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessIsBoxed() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessHasKeys() {
      return Truffle.getRuntime().createCallTarget(SymbolsHasKeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessHasSize() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessGetSize() {
      return null;
    }
    @Override
    public CallTarget accessUnbox() {
      return null;
    }
    @Override
    public CallTarget accessRead() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(ReadSubNode.createRoot());
    }
    @Override
    public CallTarget accessWrite() {
      return null;
    }
    @Override
    public CallTarget accessRemove() {
      return null;
    }
    @Override
    public CallTarget accessExecute(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessInvoke(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessNew(int argumentsLength) {
      return null;
    }
    @Override
    public CallTarget accessKeyInfo() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(SymbolsKeyInfoSubNode.createRoot());
    }
    @Override
    public CallTarget accessKeys() {
      return com.oracle.truffle.api.Truffle.getRuntime().createCallTarget(SymbolsKeysSubNode.createRoot());
    }
    @Override
    public CallTarget accessIsPointer() {
      return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
    }
    @Override
    public CallTarget accessAsPointer() {
      return null;
    }
    @Override
    public CallTarget accessToNative() {
      return null;
    }
    @Override
    public CallTarget accessMessage(Message unknown) {
      return null;
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsKeyInfoNode}.
     */
    abstract static class SymbolsKeyInfoSubNode extends com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsKeyInfoNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings obj, java.lang.String name) {
            return access(obj, name);
        }
        private static final class KEY_INFORootNode extends RootNode {
            protected KEY_INFORootNode() {
                super(null);
            }

            @Child private SymbolsKeyInfoSubNode node = com.oracle.truffle.polyglot.EmptyGlobalBindingsResolutionForeignFactory.SymbolsKeyInfoSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEY_INFO::" + com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof SymbolsKeyInfoSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEY_INFORootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsHasKeysNode}.
     */
    abstract static class SymbolsHasKeysSubNode extends com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsHasKeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings obj) {
            return access(obj);
        }
        private static final class HAS_KEYSRootNode extends RootNode {
            protected HAS_KEYSRootNode() {
                super(null);
            }

            @Child private SymbolsHasKeysSubNode node = com.oracle.truffle.polyglot.EmptyGlobalBindingsResolutionForeignFactory.SymbolsHasKeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::HAS_KEYS::" + com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof SymbolsHasKeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new HAS_KEYSRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.ReadNode}.
     */
    abstract static class ReadSubNode extends com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.ReadNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0, Object o1);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings obj, java.lang.String name) {
            return access(obj, name);
        }
        private static final class READRootNode extends RootNode {
            protected READRootNode() {
                super(null);
            }

            @Child private ReadSubNode node = com.oracle.truffle.polyglot.EmptyGlobalBindingsResolutionForeignFactory.ReadSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::READ::" + com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                Object identifier = frame.getArguments()[1];
                try {
                    return node.executeWithTarget(frame, receiver, identifier);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof ReadSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new READRootNode();
        }
    }

    /**
     * This message resolution is generated by {@link com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsKeysNode}.
     */
    abstract static class SymbolsKeysSubNode extends com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.EmptyGlobalBindingsResolution.SymbolsKeysNode {
        public abstract Object executeWithTarget(VirtualFrame frame, Object o0);
        @Specialization
        protected Object accessWithTarget(com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings obj) {
            return access(obj);
        }
        private static final class KEYSRootNode extends RootNode {
            protected KEYSRootNode() {
                super(null);
            }

            @Child private SymbolsKeysSubNode node = com.oracle.truffle.polyglot.EmptyGlobalBindingsResolutionForeignFactory.SymbolsKeysSubNodeGen.create();
            @Override
            public String getName() {
                return "Interop::KEYS::" + com.oracle.truffle.polyglot.DefaultScope.EmptyGlobalBindings.class.getName();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Object receiver = ForeignAccess.getReceiver(frame);
                try {
                    return node.executeWithTarget(frame, receiver);
                } catch (UnsupportedSpecializationException e) {
                    if (e.getNode() instanceof SymbolsKeysSubNode) {
                      throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                    } else {
                      throw e;
                    }
                }
            }

        }
        public static RootNode createRoot() {
            return new KEYSRootNode();
        }
    }
}
