// CheckStyle: start generated
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.ExplodeLoop.LoopExplosionKind;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InteropAccessNode.class)
final class InteropAccessNodeGen extends InteropAccessNode {

    @CompilationFinal private int state_;
    @Child private CachedData cached_cache;
    @Child private IndirectCallNode generic_indirectCall_;

    private InteropAccessNodeGen(Message message) {
        super(message);
    }

    @ExplodeLoop(kind = LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    @Override
    protected Object executeImpl(TruffleObject arg0Value, Object[] arg1Value) {
        int state = state_;
        if (state != 0 /* is-active doCached(TruffleObject, Object[], ForeignAccess, DirectCallNode, DirectCallNode) || doGeneric(TruffleObject, Object[], IndirectCallNode) */) {
            if ((state & 0b1) != 0 /* is-active doCached(TruffleObject, Object[], ForeignAccess, DirectCallNode, DirectCallNode) */) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if ((InteropAccessNode.acceptCached(arg0Value, s1_.foreignAccess_, s1_.canHandleCall_))) {
                        return InteropAccessNode.doCached(arg0Value, arg1Value, s1_.foreignAccess_, s1_.sendMessageCall_, s1_.canHandleCall_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doGeneric(TruffleObject, Object[], IndirectCallNode) */) {
                return doGeneric(arg0Value, arg1Value, this.generic_indirectCall_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value);
    }

    private Object executeAndSpecialize(TruffleObject arg0Value, Object[] arg1Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        try {
            int count1_ = 0;
            CachedData s1_ = this.cached_cache;
            if ((state & 0b1) != 0 /* is-active doCached(TruffleObject, Object[], ForeignAccess, DirectCallNode, DirectCallNode) */) {
                while (s1_ != null) {
                    if ((InteropAccessNode.acceptCached(arg0Value, s1_.foreignAccess_, s1_.canHandleCall_))) {
                        break;
                    }
                    s1_ = s1_.next_;
                    count1_++;
                }
            }
            if (s1_ == null) {
                {
                    ForeignAccess foreignAccess__ = (arg0Value.getForeignAccess());
                    DirectCallNode canHandleCall__ = (InteropAccessNode.createCanHandleInlinedCallNode(foreignAccess__, arg0Value));
                    if ((InteropAccessNode.acceptCached(arg0Value, foreignAccess__, canHandleCall__)) && count1_ < (InteropAccessNode.CACHE_SIZE)) {
                        s1_ = new CachedData(cached_cache);
                        s1_.foreignAccess_ = foreignAccess__;
                        s1_.sendMessageCall_ = (InteropAccessNode.createInlinedCallNode(createMessageTarget(foreignAccess__)));
                        s1_.canHandleCall_ = canHandleCall__;
                        this.cached_cache = super.insert(s1_);
                        this.state_ = state = state | 0b1 /* add-active doCached(TruffleObject, Object[], ForeignAccess, DirectCallNode, DirectCallNode) */;
                    }
                }
            }
            if (s1_ != null) {
                lock.unlock();
                hasLock = false;
                return InteropAccessNode.doCached(arg0Value, arg1Value, s1_.foreignAccess_, s1_.sendMessageCall_, s1_.canHandleCall_);
            }
            this.generic_indirectCall_ = super.insert((IndirectCallNode.create()));
            this.state_ = state = state | 0b10 /* add-active doGeneric(TruffleObject, Object[], IndirectCallNode) */;
            lock.unlock();
            hasLock = false;
            return doGeneric(arg0Value, arg1Value, this.generic_indirectCall_);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedData s1_ = this.cached_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static InteropAccessNode create(Message message) {
        return new InteropAccessNodeGen(message);
    }

    @GeneratedBy(InteropAccessNode.class)
    private static final class CachedData extends Node {

        @Child CachedData next_;
        @CompilationFinal ForeignAccess foreignAccess_;
        @Child DirectCallNode sendMessageCall_;
        @Child DirectCallNode canHandleCall_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
}
