/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.profiler.CPUSampler;
import com.oracle.truffle.tools.profiler.ProfilerNode;
import com.oracle.truffle.tools.profiler.impl.ProfilerCLI;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionStability;
import org.graalvm.options.OptionType;

@Option.Group(value={"cpusampler"})
class CPUSamplerCLI
extends ProfilerCLI {
    static final OptionType<Output> CLI_OUTPUT_TYPE = new OptionType("Output", (Function)new Function<String, Output>(){

        @Override
        public Output apply(String s) {
            try {
                return Output.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Output can be: histogram, calltree or json");
            }
        }
    });
    static final OptionType<CPUSampler.Mode> CLI_MODE_TYPE = new OptionType("Mode", (Function)new Function<String, CPUSampler.Mode>(){

        @Override
        public CPUSampler.Mode apply(String s) {
            try {
                return CPUSampler.Mode.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Mode can be: compiled, roots or statements.");
            }
        }
    });
    @Option(name="", help="Enable the CPU sampler.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> ENABLED = new OptionKey((Object)false);
    @Option(name="Mode", help="Describe level of sampling detail. NOTE: Increased detail can lead to reduced accuracy. Modes: 'exclude_inlined_roots' - sample roots excluding inlined functions (default), 'roots' - sample roots including inlined functions, 'statements' - sample all statements.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<CPUSampler.Mode> MODE = new OptionKey((Object)CPUSampler.Mode.EXCLUDE_INLINED_ROOTS, CLI_MODE_TYPE);
    @Option(name="Period", help="Period in milliseconds to sample the stack.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Long> SAMPLE_PERIOD = new OptionKey((Object)1L);
    @Option(name="Delay", help="Delay the sampling for this many milliseconds (default: 0).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Long> DELAY_PERIOD = new OptionKey((Object)0L);
    @Option(name="StackLimit", help="Maximum number of maximum stack elements.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Integer> STACK_LIMIT = new OptionKey((Object)10000);
    @Option(name="Output", help="Print a 'histogram', 'calltree' or 'json' as output (default:HISTOGRAM).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Output> OUTPUT = new OptionKey((Object)Output.HISTOGRAM, CLI_OUTPUT_TYPE);
    @Option(name="FilterRootName", help="Wildcard filter for program roots. (eg. Math.*, default:*).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Object[]> FILTER_ROOT = new OptionKey((Object)new Object[0], WILDCARD_FILTER_TYPE);
    @Option(name="FilterFile", help="Wildcard filter for source file paths. (eg. *program*.sl, default:*).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Object[]> FILTER_FILE = new OptionKey((Object)new Object[0], WILDCARD_FILTER_TYPE);
    @Option(name="FilterMimeType", help="Only profile languages with mime-type. (eg. +, default:no filter).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_MIME_TYPE = new OptionKey((Object)"");
    @Option(name="FilterLanguage", help="Only profile languages with given ID. (eg. js, default:no filter).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> FILTER_LANGUAGE = new OptionKey((Object)"");
    @Option(name="SampleInternal", help="Capture internal elements (default:false).", category=OptionCategory.INTERNAL)
    static final OptionKey<Boolean> SAMPLE_INTERNAL = new OptionKey((Object)false);
    @Option(name="SummariseThreads", help="Print output as a summary of all 'per thread' profiles. (default: false)", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> SUMMARISE_THREADS = new OptionKey((Object)false);
    @Option(name="GatherHitTimes", help="Save a timestamp for each taken sample (default:false).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Boolean> GATHER_HIT_TIMES = new OptionKey((Object)false);
    @Option(name="OutputFile", help="Save output to the given file. Output is printed to output stream by default.", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<String> OUTPUT_FILE = new OptionKey((Object)"");
    @Option(name="MinSamples", help="Remove elements from output if they have less samples than this value (default: 0).", category=OptionCategory.USER, stability=OptionStability.STABLE)
    static final OptionKey<Integer> MIN_SAMPLES = new OptionKey((Object)0);

    CPUSamplerCLI() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void handleOutput(TruffleInstrument.Env env, CPUSampler sampler) {
        try (PrintStream out = CPUSamplerCLI.chooseOutputStream(env, OUTPUT_FILE);){
            if (sampler.hasStackOverflowed()) {
                out.println("-------------------------------------------------------------------------------- ");
                out.println("ERROR: Shadow stack has overflowed its capacity of " + env.getOptions().get(STACK_LIMIT) + " during execution!");
                out.println("The gathered data is incomplete and incorrect!");
                out.println("Use --cpusampler.StackLimit=<" + STACK_LIMIT.getType().getName() + "> to set stack capacity.");
                out.println("-------------------------------------------------------------------------------- ");
                return;
            }
            Boolean summariseThreads = (Boolean)env.getOptions().get(SUMMARISE_THREADS);
            Integer minSamples = (Integer)env.getOptions().get(MIN_SAMPLES);
            switch ((Output)((Object)env.getOptions().get(OUTPUT))) {
                case HISTOGRAM: {
                    CPUSamplerCLI.printSamplingHistogram(out, sampler, summariseThreads, minSamples);
                    return;
                }
                case CALLTREE: {
                    CPUSamplerCLI.printSamplingCallTree(out, sampler, summariseThreads, minSamples);
                    return;
                }
                case JSON: {
                    CPUSamplerCLI.printSamplingJson(out, sampler);
                    return;
                }
            }
            return;
        }
    }

    private static void printSamplingJson(PrintStream out, CPUSampler sampler) {
        JSONObject output = new JSONObject();
        output.put("tool", "cpusampler");
        output.put("version", "0.4.0");
        output.put("sample_count", sampler.getSampleCount());
        output.put("period", sampler.getPeriod());
        output.put("gathered_hit_times", sampler.isGatherSelfHitTimes());
        JSONArray profile = new JSONArray();
        Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadToNodesMap = sampler.getThreadToNodesMap();
        for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> entry : threadToNodesMap.entrySet()) {
            JSONObject perThreadProfile = new JSONObject();
            perThreadProfile.put("thread", entry.getKey().toString());
            perThreadProfile.put("samples", CPUSamplerCLI.getSamplesRec(entry.getValue()));
            profile.put(perThreadProfile);
        }
        output.put("profile", profile);
        out.println(output.toString());
    }

    private static JSONArray getSamplesRec(Collection<ProfilerNode<CPUSampler.Payload>> nodes) {
        JSONArray samples = new JSONArray();
        for (ProfilerNode<CPUSampler.Payload> node : nodes) {
            JSONObject sample = new JSONObject();
            sample.put("root_name", node.getRootName());
            sample.put("source_section", CPUSamplerCLI.sourceSectionToJSON(node.getSourceSection()));
            CPUSampler.Payload payload = node.getPayload();
            sample.put("hit_count", payload.getHitCount());
            sample.put("interpreted_hit_count", payload.getInterpretedHitCount());
            sample.put("compiled_hit_count", payload.getCompiledHitCount());
            sample.put("self_hit_count", payload.getSelfHitCount());
            sample.put("self_interpreted_hit_count", payload.getSelfInterpretedHitCount());
            sample.put("self_compiled_hit_count", payload.getSelfCompiledHitCount());
            sample.put("self_hit_times", payload.getSelfHitTimes());
            sample.put("children", CPUSamplerCLI.getSamplesRec(node.getChildren()));
            samples.put(sample);
        }
        return samples;
    }

    private static Map<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> computeHistogram(Collection<ProfilerNode<CPUSampler.Payload>> profilerNodes) {
        HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> histogram = new HashMap<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>>();
        CPUSamplerCLI.computeHistogramImpl(profilerNodes, histogram);
        return histogram;
    }

    private static void computeHistogramImpl(Collection<ProfilerNode<CPUSampler.Payload>> children, Map<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>> histogram) {
        for (ProfilerNode<CPUSampler.Payload> treeNode : children) {
            List<ProfilerNode<CPUSampler.Payload>> nodes = histogram.computeIfAbsent(new ProfilerCLI.SourceLocation(treeNode.getSourceSection(), treeNode.getRootName()), new Function<ProfilerCLI.SourceLocation, List<ProfilerNode<CPUSampler.Payload>>>(){

                @Override
                public List<ProfilerNode<CPUSampler.Payload>> apply(ProfilerCLI.SourceLocation s) {
                    return new ArrayList<ProfilerNode<CPUSampler.Payload>>();
                }
            });
            nodes.add(treeNode);
            CPUSamplerCLI.computeHistogramImpl(treeNode.getChildren(), histogram);
        }
    }

    private static void printSamplingHistogram(PrintStream out, CPUSampler sampler, boolean summariseThreads, Integer minSamples) {
        int maxLength = 10;
        HashMap<Thread, ArrayList<List<ProfilerNode<CPUSampler.Payload>>>> linesPerThread = new HashMap<Thread, ArrayList<List<ProfilerNode<CPUSampler.Payload>>>>();
        Set<Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>>> entrySet = summariseThreads ? CPUSamplerCLI.makeOneEntryMap(sampler).entrySet() : sampler.getThreadToNodesMap().entrySet();
        for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> node : entrySet) {
            ArrayList<List<ProfilerNode<CPUSampler.Payload>>> lines = new ArrayList<List<ProfilerNode<CPUSampler.Payload>>>(CPUSamplerCLI.computeHistogram(node.getValue()).values());
            Collections.sort(lines, new Comparator<List<ProfilerNode<CPUSampler.Payload>>>(){

                @Override
                public int compare(List<ProfilerNode<CPUSampler.Payload>> o1, List<ProfilerNode<CPUSampler.Payload>> o2) {
                    long sum1 = 0L;
                    for (ProfilerNode<CPUSampler.Payload> tree : o1) {
                        sum1 += (long)tree.getPayload().getSelfHitCount();
                    }
                    long sum2 = 0L;
                    for (ProfilerNode<CPUSampler.Payload> tree : o2) {
                        sum2 += (long)tree.getPayload().getSelfHitCount();
                    }
                    return Long.compare(sum2, sum1);
                }
            });
            for (List list : lines) {
                maxLength = Math.max(CPUSamplerCLI.computeRootNameMaxLength((ProfilerNode)list.get(0)), maxLength);
            }
            linesPerThread.put(node.getKey(), lines);
        }
        String title = String.format(" %-" + maxLength + "s |      Total Time     |  Opt %% ||       Self Time     |  Opt %% | Location             ", "Name");
        long samples = sampler.getSampleCount();
        String sep = CPUSamplerCLI.repeat("-", title.length());
        out.println(sep);
        CPUSamplerCLI.printLegend(out, "Histogram", samples, sampler.getPeriod());
        out.println(sep);
        for (Map.Entry entry : linesPerThread.entrySet()) {
            if (!summariseThreads) {
                out.println(" Thread: " + entry.getKey());
            }
            out.println(title);
            out.println(sep);
            for (List line : (List)entry.getValue()) {
                CPUSamplerCLI.printAttributes(out, sampler, "", line, maxLength, false, minSamples);
            }
            out.println(sep);
        }
    }

    private static Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> makeOneEntryMap(CPUSampler sampler) {
        HashMap<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> oneElementMap = new HashMap<Thread, Collection<ProfilerNode<CPUSampler.Payload>>>(1);
        oneElementMap.put(new Thread("Summary"), sampler.getRootNodes());
        return oneElementMap;
    }

    private static void printSamplingCallTree(PrintStream out, CPUSampler sampler, Boolean summariseThreads, Integer minSamples) {
        ArrayList<ProfilerNode<CPUSampler.Payload>> actualRoots = new ArrayList<ProfilerNode<CPUSampler.Payload>>();
        Map<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> threadToNodesMap = summariseThreads != false ? CPUSamplerCLI.makeOneEntryMap(sampler) : sampler.getThreadToNodesMap();
        for (Collection<ProfilerNode<CPUSampler.Payload>> node : threadToNodesMap.values()) {
            actualRoots.addAll(node);
        }
        int maxLength = Math.max(10, CPUSamplerCLI.computeTitleMaxLength(actualRoots, 0));
        String title = String.format(" %-" + maxLength + "s |      Total Time     |  Opt %% ||       Self Time     |  Opt %% | Location             ", "Name");
        String sep = CPUSamplerCLI.repeat("-", title.length());
        out.println(sep);
        CPUSamplerCLI.printLegend(out, "CallTree", sampler.getSampleCount(), sampler.getPeriod());
        out.println(sep);
        for (Map.Entry<Thread, Collection<ProfilerNode<CPUSampler.Payload>>> node : threadToNodesMap.entrySet()) {
            if (!summariseThreads.booleanValue()) {
                out.println(" Thread: " + node.getKey());
            }
            out.println(title);
            out.println(sep);
            CPUSamplerCLI.printSamplingCallTreeRec(sampler, maxLength, "", node.getValue(), out, minSamples);
            out.println(sep);
        }
    }

    private static void printSamplingCallTreeRec(CPUSampler sampler, int maxRootLength, String prefix, Collection<ProfilerNode<CPUSampler.Payload>> children, PrintStream out, Integer minSamples) {
        ArrayList<ProfilerNode<CPUSampler.Payload>> sortedChildren = new ArrayList<ProfilerNode<CPUSampler.Payload>>(children);
        Collections.sort(sortedChildren, new Comparator<ProfilerNode<CPUSampler.Payload>>(){

            @Override
            public int compare(ProfilerNode<CPUSampler.Payload> o1, ProfilerNode<CPUSampler.Payload> o2) {
                return Long.compare(o2.getPayload().getHitCount(), o1.getPayload().getHitCount());
            }
        });
        for (ProfilerNode profilerNode : sortedChildren) {
            if (profilerNode == null) continue;
            boolean printed = CPUSamplerCLI.printAttributes(out, sampler, prefix, Arrays.asList(profilerNode), maxRootLength, true, minSamples);
            CPUSamplerCLI.printSamplingCallTreeRec(sampler, maxRootLength, printed ? prefix + " " : prefix, profilerNode.getChildren(), out, minSamples);
        }
    }

    private static void printLegend(PrintStream out, String type, long samples, long period) {
        out.println(String.format("Sampling %s. Recorded %s samples with period %dms.", type, samples, period));
        out.println("  Self Time: Time spent on the top of the stack.");
        out.println("  Total Time: Time spent somewhere on the stack.");
        out.println("  Opt %: Percent of time spent in compiled and therefore non-interpreted code.");
    }

    private static int computeTitleMaxLength(Collection<ProfilerNode<CPUSampler.Payload>> children, int baseLength) {
        int maxLength = baseLength;
        for (ProfilerNode<CPUSampler.Payload> treeNode : children) {
            int rootNameLength = CPUSamplerCLI.computeRootNameMaxLength(treeNode);
            maxLength = Math.max(baseLength + rootNameLength, maxLength);
            maxLength = Math.max(maxLength, CPUSamplerCLI.computeTitleMaxLength(treeNode.getChildren(), baseLength + 1));
        }
        return maxLength;
    }

    private static boolean intersectsLines(SourceSection section1, SourceSection section2) {
        int x1 = section1.getStartLine();
        int x2 = section1.getEndLine();
        int y1 = section2.getStartLine();
        int y2 = section2.getEndLine();
        return x2 >= y1 && y2 >= x1;
    }

    private static boolean printAttributes(PrintStream out, CPUSampler sampler, String prefix, List<ProfilerNode<CPUSampler.Payload>> nodes, int maxRootLength, boolean callTree, Integer minSamples) {
        String rootName;
        SourceSection sourceSection;
        long samplePeriod = sampler.getPeriod();
        long samples = sampler.getSampleCount();
        long selfInterpreted = 0L;
        long selfCompiled = 0L;
        long totalInterpreted = 0L;
        long totalCompiled = 0L;
        for (ProfilerNode<CPUSampler.Payload> tree : nodes) {
            CPUSampler.Payload payload = tree.getPayload();
            selfInterpreted += (long)payload.getSelfInterpretedHitCount();
            selfCompiled += (long)payload.getSelfCompiledHitCount();
            if (!tree.isRecursive()) {
                totalInterpreted += (long)payload.getInterpretedHitCount();
                totalCompiled += (long)payload.getCompiledHitCount();
            }
            if (!callTree) continue;
            assert (nodes.size() == 1);
            sourceSection = tree.getSourceSection();
            rootName = tree.getRootName();
            selfCompiled = CPUSamplerCLI.getSelfHitCountForRecursiveChildren(sourceSection, rootName, selfCompiled, tree.getChildren(), true);
            selfInterpreted = CPUSamplerCLI.getSelfHitCountForRecursiveChildren(sourceSection, rootName, selfInterpreted, tree.getChildren(), false);
        }
        long totalSamples = totalInterpreted + totalCompiled;
        if (totalSamples <= (long)minSamples.intValue()) {
            return false;
        }
        assert (totalSamples < samples);
        ProfilerNode<CPUSampler.Payload> firstNode = nodes.get(0);
        sourceSection = firstNode.getSourceSection();
        rootName = firstNode.getRootName();
        if (!firstNode.getTags().contains(StandardTags.RootTag.class)) {
            rootName = rootName + "~" + CPUSamplerCLI.formatIndices(sourceSection, CPUSamplerCLI.needsColumnSpecifier(firstNode));
        }
        long selfSamples = selfInterpreted + selfCompiled;
        long selfTime = selfSamples * samplePeriod;
        double selfCost = (double)selfSamples / (double)samples;
        double selfCompiledP = 0.0;
        if (selfSamples > 0L) {
            selfCompiledP = (double)selfCompiled / (double)selfSamples;
        }
        String selfTimes = String.format("%10dms %5.1f%% | %5.1f%%", selfTime, selfCost * 100.0, selfCompiledP * 100.0);
        long totalTime = totalSamples * samplePeriod;
        double totalCost = (double)totalSamples / (double)samples;
        double totalCompiledP = (double)totalCompiled / (double)totalSamples;
        String totalTimes = String.format("%10dms %5.1f%% | %5.1f%%", totalTime, totalCost * 100.0, totalCompiledP * 100.0);
        String location = CPUSamplerCLI.getShortDescription(sourceSection);
        out.println(String.format(" %-" + Math.max(maxRootLength, 10) + "s | %s || %s | %s ", prefix + rootName, totalTimes, selfTimes, location));
        return true;
    }

    private static long getSelfHitCountForRecursiveChildren(SourceSection sourceSection, String rootName, long selfCompiled, Collection<ProfilerNode<CPUSampler.Payload>> children, boolean compiled) {
        long hitCount = 0L;
        for (ProfilerNode<CPUSampler.Payload> child : children) {
            if (!child.getSourceSection().equals((Object)sourceSection) || !child.getRootName().equals(rootName)) continue;
            hitCount = compiled ? (hitCount += (long)child.getPayload().getSelfCompiledHitCount()) : (hitCount += (long)child.getPayload().getSelfInterpretedHitCount());
            hitCount += CPUSamplerCLI.getSelfHitCountForRecursiveChildren(sourceSection, rootName, hitCount, child.getChildren(), compiled);
        }
        return selfCompiled + hitCount;
    }

    private static boolean needsColumnSpecifier(ProfilerNode<CPUSampler.Payload> firstNode) {
        boolean needsColumnsSpecifier = false;
        SourceSection sourceSection = firstNode.getSourceSection();
        for (ProfilerNode<CPUSampler.Payload> node : firstNode.getParent().getChildren()) {
            if (node.getSourceSection() == sourceSection || !CPUSamplerCLI.intersectsLines(node.getSourceSection(), sourceSection)) continue;
            needsColumnsSpecifier = true;
            break;
        }
        return needsColumnsSpecifier;
    }

    private static int computeRootNameMaxLength(ProfilerNode<CPUSampler.Payload> treeNode) {
        int length = treeNode.getRootName().length();
        if (!treeNode.getTags().contains(StandardTags.RootTag.class)) {
            length += CPUSamplerCLI.formatIndices(treeNode.getSourceSection(), CPUSamplerCLI.needsColumnSpecifier(treeNode)).length() + 1;
        }
        return length;
    }

    static enum Output {
        HISTOGRAM,
        CALLTREE,
        JSON;

    }
}

