/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.message2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.graalvm.shadowed.com.ibm.icu.math.BigDecimal;
import org.graalvm.shadowed.com.ibm.icu.message2.FormattedPlaceholder;
import org.graalvm.shadowed.com.ibm.icu.message2.Formatter;
import org.graalvm.shadowed.com.ibm.icu.message2.FormatterFactory;
import org.graalvm.shadowed.com.ibm.icu.message2.OptUtils;
import org.graalvm.shadowed.com.ibm.icu.message2.PlainStringFormattedValue;
import org.graalvm.shadowed.com.ibm.icu.message2.Selector;
import org.graalvm.shadowed.com.ibm.icu.message2.SelectorFactory;
import org.graalvm.shadowed.com.ibm.icu.number.FormattedNumber;
import org.graalvm.shadowed.com.ibm.icu.number.LocalizedNumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.Notation;
import org.graalvm.shadowed.com.ibm.icu.number.NumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.number.Precision;
import org.graalvm.shadowed.com.ibm.icu.number.Scale;
import org.graalvm.shadowed.com.ibm.icu.number.UnlocalizedNumberFormatter;
import org.graalvm.shadowed.com.ibm.icu.text.FormattedValue;
import org.graalvm.shadowed.com.ibm.icu.text.NumberingSystem;
import org.graalvm.shadowed.com.ibm.icu.text.PluralRules;
import org.graalvm.shadowed.com.ibm.icu.util.CurrencyAmount;
import org.graalvm.shadowed.com.ibm.icu.util.MeasureUnit;

class NumberFormatterFactory
implements FormatterFactory,
SelectorFactory {
    private final String kind;

    public NumberFormatterFactory(String kind) {
        switch (kind) {
            case "number": 
            case "integer": {
                break;
            }
            default: {
                kind = "number";
            }
        }
        this.kind = kind;
    }

    @Override
    public Formatter createFormatter(Locale locale, Map<String, Object> fixedOptions) {
        return new NumberFormatterImpl(locale, fixedOptions, this.kind);
    }

    @Override
    public Selector createSelector(Locale locale, Map<String, Object> fixedOptions) {
        String type;
        PluralRules rules = PluralRules.forLocale(locale, switch (type = OptUtils.getString(fixedOptions, "select", "")) {
            case "ordinal" -> PluralRules.PluralType.ORDINAL;
            default -> PluralRules.PluralType.CARDINAL;
        });
        return new PluralSelectorImpl(locale, rules, fixedOptions, this.kind);
    }

    private static LocalizedNumberFormatter formatterForOptions(Locale locale, Map<String, Object> fixedOptions, String kind) {
        Integer option;
        String strOption;
        String skeleton = OptUtils.getString(fixedOptions, "icu:skeleton");
        if (skeleton != null) {
            return NumberFormatter.forSkeleton(skeleton).locale(locale);
        }
        UnlocalizedNumberFormatter nf = NumberFormatter.with();
        if ("number".equals(kind)) {
            nf = (UnlocalizedNumberFormatter)nf.notation(switch (OptUtils.getString(fixedOptions, "notation", "standard")) {
                case "scientific" -> Notation.scientific();
                case "engineering" -> Notation.engineering();
                case "compact" -> {
                    switch (OptUtils.getString(fixedOptions, "compactDisplay", "short")) {
                        case "long": {
                            yield Notation.compactLong();
                        }
                    }
                    yield Notation.compactShort();
                }
                default -> Notation.simple();
            });
            strOption = OptUtils.getString(fixedOptions, "style", "decimal");
            if (strOption.equals("percent")) {
                nf = (UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)nf.unit(MeasureUnit.PERCENT)).scale(Scale.powerOfTen(2));
            }
            if ((option = OptUtils.getInteger(fixedOptions, "minimumFractionDigits")) != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.minFraction(option));
            }
            if ((option = OptUtils.getInteger(fixedOptions, "maximumFractionDigits")) != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.maxFraction(option));
            }
            if ((option = OptUtils.getInteger(fixedOptions, "minimumSignificantDigits")) != null) {
                nf = (UnlocalizedNumberFormatter)nf.precision(Precision.minSignificantDigits(option));
            }
        }
        if (!(strOption = OptUtils.getString(fixedOptions, "numberingSystem", "")).isEmpty()) {
            strOption = strOption.toLowerCase(Locale.US);
            NumberingSystem ns = NumberingSystem.getInstanceByName(strOption);
            nf = (UnlocalizedNumberFormatter)nf.symbols(ns);
        }
        if ((option = OptUtils.getInteger(fixedOptions, "minimumIntegerDigits")) != null) {
            // empty if block
        }
        if ((option = OptUtils.getInteger(fixedOptions, "maximumSignificantDigits")) != null) {
            nf = (UnlocalizedNumberFormatter)nf.precision(Precision.maxSignificantDigits(option));
        }
        nf = (UnlocalizedNumberFormatter)nf.sign(switch (strOption = OptUtils.getString(fixedOptions, "signDisplay", "auto")) {
            case "always" -> NumberFormatter.SignDisplay.ALWAYS;
            case "exceptZero" -> NumberFormatter.SignDisplay.EXCEPT_ZERO;
            case "negative" -> NumberFormatter.SignDisplay.NEGATIVE;
            case "never" -> NumberFormatter.SignDisplay.NEVER;
            default -> NumberFormatter.SignDisplay.AUTO;
        });
        nf = (UnlocalizedNumberFormatter)nf.grouping(switch (strOption = OptUtils.getString(fixedOptions, "useGrouping", "auto")) {
            case "always" -> NumberFormatter.GroupingStrategy.ON_ALIGNED;
            case "never" -> NumberFormatter.GroupingStrategy.OFF;
            case "min2" -> NumberFormatter.GroupingStrategy.MIN2;
            default -> NumberFormatter.GroupingStrategy.AUTO;
        });
        if (kind.equals("integer")) {
            nf = (UnlocalizedNumberFormatter)nf.precision(Precision.integer());
        }
        return nf.locale(locale);
    }

    static class NumberFormatterImpl
    implements Formatter {
        private final Locale locale;
        private final Map<String, Object> fixedOptions;
        private final LocalizedNumberFormatter icuFormatter;
        private final String kind;
        final boolean advanced;

        NumberFormatterImpl(Locale locale, Map<String, Object> fixedOptions, String kind) {
            this.locale = locale;
            this.fixedOptions = new HashMap<String, Object>(fixedOptions);
            String skeleton = OptUtils.getString(fixedOptions, "icu:skeleton");
            boolean fancy = skeleton != null;
            this.icuFormatter = NumberFormatterFactory.formatterForOptions(locale, fixedOptions, kind);
            this.advanced = fancy;
            this.kind = kind;
        }

        LocalizedNumberFormatter getIcuFormatter() {
            return this.icuFormatter;
        }

        @Override
        public String formatToString(Object toFormat, Map<String, Object> variableOptions) {
            return this.format(toFormat, variableOptions).toString();
        }

        @Override
        public FormattedPlaceholder format(Object toFormat, Map<String, Object> variableOptions) {
            LocalizedNumberFormatter realFormatter;
            if (variableOptions.isEmpty()) {
                realFormatter = this.icuFormatter;
            } else {
                HashMap<String, Object> mergedOptions = new HashMap<String, Object>(this.fixedOptions);
                mergedOptions.putAll(variableOptions);
                realFormatter = NumberFormatterFactory.formatterForOptions(this.locale, mergedOptions, this.kind);
            }
            Integer offset = OptUtils.getInteger(variableOptions, "icu:offset");
            if (offset == null && this.fixedOptions != null) {
                offset = OptUtils.getInteger(this.fixedOptions, "icu:offset");
            }
            if (offset == null) {
                offset = 0;
            }
            FormattedValue result = null;
            if (toFormat == null) {
                throw new NullPointerException("Argument to format can't be null");
            }
            if (toFormat instanceof Double) {
                result = realFormatter.format((Double)toFormat - (double)offset.intValue());
            } else if (toFormat instanceof Long) {
                result = realFormatter.format((Long)toFormat - (long)offset.intValue());
            } else if (toFormat instanceof Integer) {
                result = realFormatter.format((Integer)toFormat - offset);
            } else if (toFormat instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)toFormat;
                result = realFormatter.format(bd.subtract(BigDecimal.valueOf(offset.intValue())));
            } else {
                String strValue;
                Number nrValue;
                result = toFormat instanceof Number ? realFormatter.format(((Number)toFormat).doubleValue() - (double)offset.intValue()) : (toFormat instanceof CurrencyAmount ? realFormatter.format((CurrencyAmount)toFormat) : ((nrValue = OptUtils.asNumber(strValue = Objects.toString(toFormat))) != null ? realFormatter.format(nrValue.doubleValue() - (double)offset.intValue()) : new PlainStringFormattedValue("{|" + strValue + "|}")));
            }
            return new FormattedPlaceholder(toFormat, result);
        }
    }

    private static class PluralSelectorImpl
    implements Selector {
        private static final String NO_MATCH = "\ufffdNO_MATCH\ufffe";
        private final PluralRules rules;
        private Map<String, Object> fixedOptions;
        private LocalizedNumberFormatter icuFormatter;

        private PluralSelectorImpl(Locale locale, PluralRules rules, Map<String, Object> fixedOptions, String kind) {
            this.rules = rules;
            this.fixedOptions = fixedOptions;
            this.icuFormatter = NumberFormatterFactory.formatterForOptions(locale, fixedOptions, kind);
        }

        @Override
        public List<String> matches(Object value, List<String> keys, Map<String, Object> variableOptions) {
            ArrayList<String> result = new ArrayList<String>();
            if (value == null) {
                return result;
            }
            for (String key : keys) {
                if (this.matches(value, key, variableOptions)) {
                    result.add(key);
                    continue;
                }
                result.add(NO_MATCH);
            }
            result.sort(PluralSelectorImpl::pluralComparator);
            return result;
        }

        private static int pluralComparator(String o1, String o2) {
            if (o1.equals(o2)) {
                return 0;
            }
            if (NO_MATCH.equals(o1)) {
                return 1;
            }
            if (NO_MATCH.equals(o2)) {
                return -1;
            }
            if ("*".equals(o1)) {
                return 1;
            }
            if ("*".equals(o2)) {
                return -1;
            }
            if (OptUtils.asNumber(o1) != null) {
                return -1;
            }
            if (OptUtils.asNumber(o2) != null) {
                return 1;
            }
            return o1.compareTo(o2);
        }

        private boolean matches(Object value, String key, Map<String, Object> variableOptions) {
            if ("*".equals(key)) {
                return true;
            }
            Integer offset = OptUtils.getInteger(variableOptions, "icu:offset");
            if (offset == null && this.fixedOptions != null) {
                offset = OptUtils.getInteger(this.fixedOptions, "icu:offset");
            }
            if (offset == null) {
                offset = 0;
            }
            Double valToCheck = Double.MIN_VALUE;
            if (value instanceof FormattedPlaceholder) {
                FormattedPlaceholder fph = (FormattedPlaceholder)value;
                value = fph.getInput();
            }
            if (!(value instanceof Number)) {
                return false;
            }
            valToCheck = ((Number)value).doubleValue();
            Number keyNrVal = OptUtils.asNumber(key);
            if (keyNrVal != null && ((Number)valToCheck).doubleValue() == keyNrVal.doubleValue()) {
                return true;
            }
            FormattedNumber formatted = this.icuFormatter.format(valToCheck - (double)offset.intValue());
            String match = this.rules.select(formatted);
            if (match.equals("other")) {
                match = "*";
            }
            return match.equals(key);
        }
    }
}

