// @formatter:off
// © 2016 and later: Unicode, Inc. and others.
// License & terms of use: http://www.unicode.org/copyright.html
/*
 *******************************************************************************
 * Copyright (C) 2011, International Business Machines Corporation and         *
 * others. All Rights Reserved.                                                *
 *******************************************************************************
 */
package org.graalvm.shadowed.com.ibm.icu.impl;

import org.graalvm.shadowed.com.ibm.icu.text.TimeZoneNames;
import org.graalvm.shadowed.com.ibm.icu.text.TimeZoneNames.Factory;
import org.graalvm.shadowed.com.ibm.icu.util.ULocale;

/**
 * The implementation class of <code>TimeZoneNames.Factory</code>
 */
public class TimeZoneNamesFactoryImpl extends Factory {

    /* (non-Javadoc)
     * @see org.graalvm.shadowed.com.ibm.icu.text.TimeZoneNames.Factory#getTimeZoneNames(org.graalvm.shadowed.com.ibm.icu.util.ULocale)
     */
    @Override
    public TimeZoneNames getTimeZoneNames(ULocale locale) {
        return new TimeZoneNamesImpl(locale);
    }

}
