/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.util;

import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class ASCIIUtils {
    public static boolean isAscii(TruffleString string, TruffleString.GetCodeRangeNode getCodeRangeNode) {
        return getCodeRangeNode.execute((AbstractTruffleString)string, PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII;
    }

    public static byte[] getAsciiBytes(TruffleString string, TruffleString.CopyToByteArrayNode copyToByteArrayNode, TruffleString.SwitchEncodingNode switchEncodingNode) {
        assert (string.getCodeRangeUncached(PythonUtils.TS_ENCODING) == TruffleString.CodeRange.ASCII);
        TruffleString ascii = switchEncodingNode.execute((AbstractTruffleString)string, TruffleString.Encoding.US_ASCII);
        byte[] data = new byte[ascii.byteLength(TruffleString.Encoding.US_ASCII)];
        copyToByteArrayNode.execute((AbstractTruffleString)ascii, 0, data, 0, data.length, TruffleString.Encoding.US_ASCII);
        return data;
    }
}

