/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.struct;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.iterator.PStructUnpackIterator;
import com.oracle.graal.python.enterprise.builtins.objects.struct.PStruct;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructBuiltins;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructNodes;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructUnpackIteratorBuiltinsFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStructUnpackIterator})
public class StructUnpackIteratorBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructUnpackIteratorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.isExhausted()"})
        Object nextExhausted(PStructUnpackIterator self) {
            throw this.raise(PythonBuiltinClassType.StopIteration);
        }

        @Specialization(guards={"!self.isExhausted()"}, limit="3")
        Object next(VirtualFrame frame, PStructUnpackIterator self, @Cached StructNodes.UnpackValueNode unpackValueNode, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib) {
            byte[] bytes;
            int offset;
            PStruct struct = self.getStruct();
            Object buffer = self.getBuffer();
            int bufferLen = bufferLib.getBufferLength(buffer);
            if (struct == null || self.index >= bufferLen) {
                self.setExhausted();
                bufferLib.release(buffer, frame, (Node)this);
                throw this.raise(PythonBuiltinClassType.StopIteration);
            }
            assert (self.index + struct.getSize() <= bufferLen);
            if (bufferLib.hasInternalByteArray(buffer)) {
                offset = self.index;
                bytes = bufferLib.getInternalByteArray(buffer);
            } else {
                offset = 0;
                bytes = new byte[struct.getSize()];
                bufferLib.readIntoByteArray(buffer, self.index, bytes, 0, bytes.length);
            }
            PTuple result = this.factory().createTuple(StructBuiltins.unpackInternal(struct, unpackValueNode, bytes, offset));
            self.index += struct.getSize();
            return result;
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class LengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization(limit="3")
        static int lenHint(PStructUnpackIterator self, @CachedLibrary(value="self.getBuffer()") PythonBufferAccessLibrary bufferLib) {
            if (self.getStruct() == null) {
                return 0;
            }
            int bufferLen = bufferLib.getBufferLength(self.getBuffer());
            return (bufferLen - self.index) / self.getStruct().getSize();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PStructUnpackIterator self) {
            return self;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        protected Object createNew(Object type, Object[] args, PKeyword[] kwds) {
            throw this.raise(PythonBuiltinClassType.TypeError, EnterpriseErrorMessages.CANNOT_CREATE_P_OBJECTS, new Object[]{type});
        }
    }
}

