/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.struct;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.enterprise.builtins.modules.StructModuleBuiltins;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatAlignment;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsLongNode;
import com.oracle.graal.python.lib.PyLongCheckNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PNodeWithState;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.NumericSupport;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.PrimitiveValueProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import java.math.BigInteger;

public final class StructNodes {

    @ImportStatic(value={FormatCode.class})
    public static abstract class UnpackValueNode
    extends StructBaseNode {
        public abstract Object execute(FormatCode var1, FormatAlignment var2, byte[] var3, int var4);

        @Specialization(guards={"isFmtInteger(formatCode)", "numBytes == formatCode.numBytes()", "numericSupport == getNumericSupport(formatAlignment)"}, limit="getNumBytesLimit()")
        Object unpack8Cached(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Cached(value="formatCode.numBytes()") int numBytes, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached(value="createBinaryProfile()") ConditionProfile profilePIntResult, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned) {
            long num;
            if (profileSigned.profile(formatCode.isUnsigned())) {
                num = numericSupport.getLongUnsigned(buffer, offset, numBytes);
            } else {
                num = numericSupport.getLong(buffer, offset, numBytes);
                num = UnpackValueNode.handleSign(formatCode, num);
            }
            if (profilePIntResult.profile(formatCode.isUnsigned() && num < 0L)) {
                return this.factory().createInt(UnpackValueNode.getAsUnsignedBigInt(num));
            }
            return num;
        }

        @Specialization(guards={"isFmtInteger(formatCode)"}, replaces={"unpack8Cached"})
        Object unpack8(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Cached(value="createBinaryProfile()") ConditionProfile profilePIntResult, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned) {
            return this.unpack8Cached(formatCode, formatAlignment, buffer, offset, formatCode.numBytes(), UnpackValueNode.getNumericSupport(formatAlignment), profilePIntResult, profileSigned);
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        Object unpackFloat8(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport) {
            return numericSupport.getDouble(buffer, offset, formatCode.numBytes());
        }

        @Specialization(guards={"isFmtVoidPtr(formatCode)", "formatAlignment.isNative()"})
        Object unpackVoidPtr(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset) {
            throw this.raise(PythonErrorType.NotImplementedError, EnterpriseErrorMessages.STRUCT_NATIVE_NYI);
        }

        @Specialization(guards={"isFmtBoolean(formatCode)"})
        Object unpackBool(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset) {
            return buffer[offset] != 0;
        }

        @Specialization(guards={"isFmtBytes(formatCode)"})
        Object unpackBytes(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset, @Cached(value="createIdentityProfile()") ValueProfile formatProfile) {
            byte[] bytes;
            switch (((Character)formatProfile.profile((Object)Character.valueOf(formatCode.formatDef.format))).charValue()) {
                case 'c': {
                    bytes = new byte[]{buffer[offset]};
                    break;
                }
                case 's': {
                    bytes = new byte[formatCode.size];
                    PythonUtils.arraycopy((Object)buffer, (int)offset, (Object)bytes, (int)0, (int)formatCode.size);
                    break;
                }
                default: {
                    int n = buffer[offset] & 0xFF;
                    if (n >= formatCode.size) {
                        n = formatCode.size - 1;
                    }
                    bytes = new byte[n];
                    PythonUtils.arraycopy((Object)buffer, (int)(offset + 1), (Object)bytes, (int)0, (int)n);
                }
            }
            return this.factory().createBytes(bytes);
        }

        @Specialization(guards={"!isSupportedFormat(formatCode)"})
        byte[] unpackUnsupported(FormatCode formatCode, FormatAlignment formatAlignment, byte[] buffer, int offset) {
            throw this.raise(PythonErrorType.NotImplementedError, EnterpriseErrorMessages.STRUCT_FMT_NOT_YET_SUPPORTED, new Object[]{formatCode});
        }
    }

    @ImportStatic(value={FormatCode.class})
    public static abstract class PackValueNode
    extends StructBaseNode {
        public abstract void execute(VirtualFrame var1, FormatCode var2, FormatAlignment var3, Object var4, byte[] var5, int var6);

        private void packLongInternal(FormatCode formatCode, long value, byte[] buffer, int offset, NumericSupport numericSupport, int numBytes, ConditionProfile profileSigned) {
            long num = profileSigned.profile(formatCode.isUnsigned()) ? this.checkLongUnsigned(formatCode, value) : this.checkLong(formatCode, value);
            numericSupport.putLong(buffer, offset, num, numBytes);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        void packLong(FormatCode formatCode, FormatAlignment formatAlignment, long value, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned) {
            this.packLongInternal(formatCode, value, buffer, offset, numericSupport, formatCode.numBytes(), profileSigned);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        void packInt(FormatCode formatCode, FormatAlignment formatAlignment, int value, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned) {
            this.packLongInternal(formatCode, value, buffer, offset, numericSupport, formatCode.numBytes(), profileSigned);
        }

        @Specialization(guards={"isFmtInteger(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        void packPInt(FormatCode formatCode, FormatAlignment formatAlignment, PInt value, byte[] buffer, int offset, @Bind(value="this") Node inliningTarget, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode) {
            try {
                BigInteger num = this.checkBigInt(formatCode, toJavaBigIntegerNode.execute(inliningTarget, (Object)value));
                numericSupport.putBigInteger(buffer, offset, num, formatCode.numBytes());
            }
            catch (OverflowException oe) {
                throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_O_O_RANGE);
            }
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        void packFloat(FormatCode formatCode, FormatAlignment formatAlignment, double value, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport) {
            numericSupport.putDouble((PNodeWithRaise)this, buffer, offset, value, formatCode.numBytes());
        }

        @Specialization(guards={"isFmtFloat(formatCode)", "numericSupport == getNumericSupport(formatAlignment)"})
        void packPFloat(FormatCode formatCode, FormatAlignment formatAlignment, PFloat value, byte[] buffer, int offset, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport) {
            this.packFloat(formatCode, formatAlignment, value.getValue(), buffer, offset, numericSupport);
        }

        @Specialization(guards={"isFmtBoolean(formatCode)"})
        void packBoolean(FormatCode formatCode, FormatAlignment formatAlignment, boolean value, byte[] buffer, int offset) {
            assert (offset < buffer.length);
            buffer[offset] = (byte)(value ? 1 : 0);
        }

        @Specialization(guards={"isFmtBytes(formatCode)"}, limit="getCallSiteInlineCacheMaxDepth()")
        void packBytes(FormatCode formatCode, FormatAlignment formatAlignment, PBytesLike value, byte[] buffer, int offset, @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @CachedLibrary(value="value") PythonBufferAccessLibrary bufferLib) {
            int n = bufferLib.getBufferLength((Object)value);
            switch (formatProfile.profile(formatCode.formatDef.format)) {
                case 'c': {
                    if (n != 1) {
                        throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_CHR_FMT_BYTES_1);
                    }
                    assert (n <= buffer.length - offset);
                    bufferLib.readIntoByteArray((Object)value, 0, buffer, offset, n);
                    break;
                }
                case 's': {
                    if (n > formatCode.size) {
                        n = formatCode.size;
                    }
                    assert (n <= buffer.length - offset);
                    if (n <= 0) break;
                    bufferLib.readIntoByteArray((Object)value, 0, buffer, offset, n);
                    break;
                }
                default: {
                    if (n > formatCode.size - 1) {
                        n = formatCode.size - 1;
                    }
                    assert (n + 1 <= buffer.length - offset);
                    if (n > 0) {
                        bufferLib.readIntoByteArray((Object)value, 0, buffer, offset + 1, n);
                    }
                    if (n > 255) {
                        n = 255;
                    }
                    buffer[offset] = (byte)n;
                }
            }
        }

        @Specialization(guards={"numericSupport == getNumericSupport(formatAlignment)"}, limit="1")
        void packObjectCached(VirtualFrame frame, FormatCode formatCode, FormatAlignment formatAlignment, Object value, byte[] buffer, int offset, @Bind(value="this") Node inliningTarget, @Cached GetLongNode getLongNode, @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode, @Cached CanBeDoubleNode canBeDoubleNode, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached(value="getNumericSupport(formatAlignment)") NumericSupport numericSupport, @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            if (PackValueNode.isNumberUpToSize8Unsigned(formatCode)) {
                this.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, numericSupport, profileSigned);
            } else if (PackValueNode.isNumberSize8Unsigned(formatCode)) {
                if (value instanceof Integer || value instanceof Long) {
                    this.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, numericSupport, profileSigned);
                } else {
                    try {
                        BigInteger num = this.checkBigInt(formatCode, toJavaBigIntegerNode.execute(inliningTarget, value));
                        PackValueNode.getNumericSupport(formatAlignment).putBigInteger(buffer, offset, num, formatCode.numBytes());
                    }
                    catch (OverflowException oe) {
                        throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_O_O_RANGE);
                    }
                    catch (PException pe) {
                        pe.expect(inliningTarget, PythonBuiltinClassType.TypeError, errorProfile);
                        throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_NOT_T, new Object[]{"an integer"});
                    }
                }
            } else if (PackValueNode.isFmtFloat(formatCode)) {
                if (!canBeDoubleNode.execute(inliningTarget, value)) {
                    throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_NOT_T, new Object[]{"a float"});
                }
                this.packFloat(formatCode, formatAlignment, asDoubleNode.execute(frame, inliningTarget, value), buffer, offset, numericSupport);
            } else if (PackValueNode.isFmtVoidPtr(formatCode)) {
                getLongNode.execute(frame, value, formatCode.isUnsigned());
                this.packLong(formatCode, formatAlignment, getLongNode.execute(frame, value, formatCode.isUnsigned()), buffer, offset, numericSupport, profileSigned);
            } else if (PackValueNode.isFmtBoolean(formatCode)) {
                this.packBoolean(formatCode, formatAlignment, isTrueNode.execute((Frame)frame, inliningTarget, value), buffer, offset);
            } else if (PackValueNode.isFmtBytes(formatCode)) {
                if (!PGuards.isBytes((Object)value)) {
                    throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_FOR_N_MUST_BE, new Object[]{Character.valueOf(formatCode.formatDef.format), "bytes"});
                }
                this.packBytes(formatCode, formatAlignment, (PBytesLike)value, buffer, offset, formatProfile, bufferLib);
            } else {
                throw this.raise(PythonErrorType.NotImplementedError, EnterpriseErrorMessages.STRUCT_FMT_NOT_YET_SUPPORTED, new Object[]{formatCode});
            }
        }

        @Specialization(replaces={"packObjectCached"})
        void packObject(VirtualFrame frame, FormatCode formatCode, FormatAlignment formatAlignment, Object value, byte[] buffer, int offset, @Bind(value="this") Node inliningTarget, @Cached GetLongNode getLongNode, @Cached CastToJavaBigIntegerNode toJavaBigIntegerNode, @Cached CanBeDoubleNode canBeDoubleNode, @Cached PyFloatAsDoubleNode asDoubleNode, @Cached PyObjectIsTrueNode isTrueNode, @Cached(value="createEqualityProfile()") PrimitiveValueProfile formatProfile, @Cached(value="createBinaryProfile()") ConditionProfile profileSigned, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            this.packObjectCached(frame, formatCode, formatAlignment, value, buffer, offset, inliningTarget, getLongNode, toJavaBigIntegerNode, canBeDoubleNode, asDoubleNode, isTrueNode, PackValueNode.getNumericSupport(formatAlignment), formatProfile, profileSigned, errorProfile, bufferLib);
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class StructBaseNode
    extends PNodeWithState {
        public static final BigInteger UBYTE_MASK = BigInteger.valueOf(255L);
        public static final BigInteger ULONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

        public static int getNumBytesLimit() {
            return StructModuleBuiltins.ConstructStructNode.NUM_BYTES_LIMIT;
        }

        public static boolean isFormat(FormatCode formatCode, char fmt) {
            return formatCode.formatDef.format == fmt;
        }

        public static boolean isNumberSize8Unsigned(FormatCode formatCode) {
            return formatCode.formatDef.integer && formatCode.numBytes() == 8 && formatCode.isUnsigned();
        }

        public static boolean isNumberUpToSize8Unsigned(FormatCode formatCode) {
            return formatCode.formatDef.integer && (formatCode.numBytes() != 8 || !formatCode.isUnsigned());
        }

        public static boolean isFmtFloat(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'e') || StructBaseNode.isFormat(formatCode, 'f') || StructBaseNode.isFormat(formatCode, 'd');
        }

        public static boolean isFmtInteger(FormatCode formatCode) {
            return formatCode.formatDef.integer;
        }

        public static boolean isFmtVoidPtr(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'P');
        }

        public static boolean isFmtBoolean(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, '?');
        }

        public static boolean isFmtBytes(FormatCode formatCode) {
            return StructBaseNode.isFormat(formatCode, 'c') || StructBaseNode.isFormat(formatCode, 's') || StructBaseNode.isFormat(formatCode, 'p');
        }

        public static boolean isSupportedFormat(FormatCode formatCode) {
            return StructBaseNode.isFmtBoolean(formatCode) || StructBaseNode.isFmtBytes(formatCode) || StructBaseNode.isFmtFloat(formatCode) || StructBaseNode.isFmtInteger(formatCode) || StructBaseNode.isFmtVoidPtr(formatCode);
        }

        private PException raiseNumberError(FormatCode formatCode) {
            if (formatCode.formatDef.name == null) {
                return this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_O_O_RANGE);
            }
            return this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.FMT_REQ_RANGE, new Object[]{formatCode.formatDef.name, formatCode.formatDef.min, formatCode.formatDef.max});
        }

        public long checkLong(FormatCode formatCode, long value) {
            if (value < formatCode.formatDef.min || value > formatCode.formatDef.max) {
                throw this.raiseNumberError(formatCode);
            }
            return value;
        }

        public long checkLongUnsigned(FormatCode formatCode, long value) {
            if (value < formatCode.formatDef.min || Long.compareUnsigned(value, formatCode.formatDef.max) > 0) {
                throw this.raiseNumberError(formatCode);
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        public BigInteger checkBigInt(FormatCode formatCode, BigInteger value) {
            if (value.compareTo(BigInteger.valueOf(formatCode.formatDef.min)) < 0 || value.compareTo(BigInteger.valueOf(formatCode.formatDef.max).and(ULONG_MASK)) > 0) {
                throw this.raiseNumberError(formatCode);
            }
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger getAsUnsignedBigInt(long value) {
            return BigInteger.valueOf(value).and(ULONG_MASK);
        }

        public static long handleSign(FormatCode code, long num) {
            long value = num;
            if ((value >>> code.numBytes() * 8 - 1 & 1L) == 1L) {
                value |= -(value & 1L << 8 * code.numBytes() - 1);
            }
            return value;
        }

        public static NumericSupport getNumericSupport(FormatAlignment formatAlignment) {
            return formatAlignment.bigEndian ? NumericSupport.bigEndian() : NumericSupport.littleEndian();
        }
    }

    public static abstract class GetLongNode
    extends PNodeWithState {
        public abstract long execute(VirtualFrame var1, Object var2, boolean var3);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        long get(VirtualFrame frame, Object value, boolean unsigned, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PyLongCheckNode pyLongCheckNode, @Cached PyNumberIndexNode indexNode, @Cached PyLongAsLongNode pyLongAsLongNode) {
            long x;
            Object longValue;
            if (!pyLongCheckNode.execute(inliningTarget, value)) {
                if (!indexCheckNode.execute(inliningTarget, value)) throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_NOT_T, new Object[]{"an integer"});
                longValue = indexNode.execute((Frame)frame, inliningTarget, value);
            } else {
                longValue = value;
            }
            try {
                x = pyLongAsLongNode.execute((Frame)frame, inliningTarget, longValue);
            }
            catch (PException pe) {
                pe.expect(inliningTarget, PythonBuiltinClassType.OverflowError, errorProfile);
                throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_O_O_RANGE);
            }
            if (!unsigned || x >= 0L) return x;
            throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_O_O_RANGE);
        }
    }
}

